/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.sapinst.adapter;

import com.sap.sdt.server.ext.sapinst.adapter.SAPinstConstants;
import com.sap.sdt.util.net.AbstractCommLink;
import com.sap.sdt.util.net.NetworkException;
import com.sap.sdt.util.vers.VersionException;
import com.sap.sdt.util.vers.VersionFactory;
import com.sap.sdt.util.vers.VersionIF;

class SAPinstCommLink
extends AbstractCommLink
implements SAPinstConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/ext/sapinst/adapter/SAPinstCommLink.java#3 $";
    protected static final VersionIF splitVers = VersionFactory.createVersion("2.0");
    protected static final VersionIF longDataVersion = VersionFactory.createVersion("3.1");
    private static final int HDR_LEN_HS = 2;
    private static final int HDR_LEN_OLD = 2;
    private static final int HDR_LEN_NEW = 4;
    private static final String DEFAULT_MSG_ENC = "UTF8";
    private int hdrLength = 2;
    private String msgEnc = "UTF8";
    private VersionIF protVers = null;

    SAPinstCommLink() {
    }

    public void send(String msg) throws NetworkException {
        try {
            this.hdrLength = this.protVers == null || this.protVers.isLower(longDataVersion) ? 2 : 4;
        }
        catch (VersionException vE) {
            vE.printStackTrace();
            System.exit(1);
        }
        super.send(msg);
    }

    public String receive() throws NetworkException {
        try {
            this.hdrLength = this.protVers == null || this.protVers.isLower(splitVers) ? 2 : 4;
        }
        catch (VersionException vE) {
            vE.printStackTrace();
            System.exit(1);
        }
        return super.receive();
    }

    public void setProtVers(VersionIF protVers) {
        this.protVers = protVers;
    }

    protected int getHdrLength() {
        return this.hdrLength;
    }

    protected int getMsgLength(byte[] hdr) {
        int length = 0;
        for (int i = 0; i < hdr.length; ++i) {
            length <<= 8;
            length |= hdr[i] & 0xFF;
        }
        return length;
    }

    protected String getMsgEnc() {
        return this.msgEnc;
    }

    protected void setMsgLength(byte[] hdrBuf, int length) {
        for (int i = 0; i < hdrBuf.length; ++i) {
            hdrBuf[hdrBuf.length - i - 1] = (byte)(length >> i * 8);
        }
    }
}

