/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.sapinst.adapter;

import com.sap.sdt.server.core.controls.SDTButton;
import com.sap.sdt.server.core.controls.SDTMessageBox;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstAdapter;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstConstants;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstParserIF;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstToolkit;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import java.util.Iterator;
import java.util.Stack;

class SAPinstAlertParser
implements SAPinstParserIF,
SAPinstConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/ext/sapinst/adapter/SAPinstAlertParser.java#2 $";
    protected SAPinstAdapter adapter = null;

    SAPinstAlertParser(SAPinstAdapter adapter) {
        this.adapter = adapter;
    }

    public void parse(XMLElementIF elem) {
        String title = null;
        SDTMessageBox popup = new SDTMessageBox();
        Stack<XMLElementIF> buttonElements = new Stack<XMLElementIF>();
        Iterator it = elem.getSubElements();
        while (it.hasNext()) {
            XMLElementIF subElem = (XMLElementIF)it.next();
            int type = SAPinstToolkit.getElemType(subElem.getName());
            switch (type) {
                case 3: {
                    title = subElem.getContent();
                    break;
                }
                case 41: {
                    popup.setMessageText(subElem.getContent());
                    break;
                }
                case 10: {
                    buttonElements.push(subElem);
                }
            }
        }
        while (!buttonElements.empty()) {
            this.addButton(popup, (XMLElementIF)buttonElements.pop());
        }
        popup.setTitle(title);
        popup.setModal(false);
        this.adapter.getDialog().showPopup(popup);
    }

    protected void addButton(SDTMessageBox popup, XMLElementIF elem) {
        SDTButton button = new SDTButton();
        button.addActionListener(this.adapter.getAlertListener());
        try {
            SAPinstToolkit.setCaption(button, elem.getElement("caption").getContent());
            this.setActionCommand(button, elem.getElement("action"));
            this.setToolTip(button, elem.getElement("tooltiphelp"));
            button.setDefault(elem.getAttrBoolean("default"));
        }
        catch (XMLException e) {
            e.printStackTrace();
        }
        popup.addButton(button);
    }

    protected void setButtonCaption(SDTButton button, XMLElementIF elem) {
        String caption = null;
        char mnemonic = '#';
        String content = elem.getContent();
        int index = content.indexOf(38);
        if (index != -1) {
            mnemonic = content.charAt(index + 1);
            caption = content.substring(0, index);
            caption = caption + content.substring(index + 1, content.length());
        } else {
            caption = content;
        }
        button.setCaption(caption, mnemonic);
    }

    protected void setActionCommand(SDTButton button, XMLElementIF elem) {
        button.setActionCommand(elem.getContent());
    }

    protected void setToolTip(SDTButton button, XMLElementIF elem) {
        if (elem != null) {
            button.setToolTip(elem.getContent());
        }
    }
}

