/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.sapinst.adapter;

import com.sap.sdt.engine.core.controls.SDTConstants;
import com.sap.sdt.engine.core.event.SDTActionEvent;
import com.sap.sdt.engine.core.services.tool.ToolInfo;
import com.sap.sdt.engine.core.services.tool.ToolServiceIF;
import com.sap.sdt.server.core.controls.SDTActionListener;
import com.sap.sdt.server.core.controls.SDTButton;
import com.sap.sdt.server.core.controls.SDTCheckBox;
import com.sap.sdt.server.core.controls.SDTComboBox;
import com.sap.sdt.server.core.controls.SDTControl;
import com.sap.sdt.server.core.controls.SDTFileBrowser;
import com.sap.sdt.server.core.controls.SDTItemListener;
import com.sap.sdt.server.core.controls.SDTMessageBox;
import com.sap.sdt.server.core.controls.SDTPanel;
import com.sap.sdt.server.core.controls.SDTPasswordField;
import com.sap.sdt.server.core.controls.SDTRadioBox;
import com.sap.sdt.server.core.controls.SDTRadioButton;
import com.sap.sdt.server.core.controls.SDTTextField;
import com.sap.sdt.server.core.controls.SDTView;
import com.sap.sdt.server.core.resources.ResourcePoolParser;
import com.sap.sdt.server.core.services.AdapterException;
import com.sap.sdt.server.core.services.tool.AbstractToolAdapter;
import com.sap.sdt.server.core.services.tool.views.SDTNetWeaverView;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstAlertListener;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstAlertParser;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstCommLink;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstCommLinkException;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstConstants;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstDependency;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstDependencyListener;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstDialogListener;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstDialogParser;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstElemException;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstException;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstFileParser;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstHelpResolver;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstListenerIF;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstLogListener;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstLogParser;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstParserIF;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstToolkit;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstUpdateParser;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstXMLException;
import com.sap.sdt.server.ext.sapinst.adapter.TerminationListener;
import com.sap.sdt.util.net.CommLinkIF;
import com.sap.sdt.util.net.NetworkException;
import com.sap.sdt.util.vers.VersionFactory;
import com.sap.sdt.util.vers.VersionIF;
import com.sap.sdt.util.xml.XMLAdmin;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class SAPinstAdapter
extends AbstractToolAdapter
implements SDTConstants,
SAPinstConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/ext/sapinst/adapter/SAPinstAdapter.java#5 $";
    private static final boolean passwordStripping = true;
    private Map sidToControl = new HashMap();
    private Map controlToSID = new HashMap();
    private Vector dependencies = new Vector();
    private Map defaultValues = new HashMap();
    private SAPinstParserIF dialogParser = new SAPinstDialogParser(this);
    private SAPinstParserIF updateParser = new SAPinstUpdateParser(this);
    private SAPinstParserIF alertParser = new SAPinstAlertParser(this);
    private SAPinstParserIF logParser = new SAPinstLogParser(this);
    private SAPinstParserIF fileParser = new SAPinstFileParser(this);
    private ResourcePoolParser resourcePoolParser = new ResourcePoolParser(this);
    private SAPinstListenerIF dialogListener = new SAPinstDialogListener(this);
    private SAPinstListenerIF alertListener = new SAPinstAlertListener(this);
    private SAPinstListenerIF terminationListener = new TerminationListener(this);
    private SAPinstListenerIF logListener = new SAPinstLogListener(this);
    private SAPinstDependencyListener depListener = new SAPinstDependencyListener(this);
    private SAPinstHelpResolver helpResolver = new SAPinstHelpResolver(this);
    private boolean isWaitingForExit = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SAPinstAdapter(ToolServiceIF service, ToolInfo info) {
        super(service, info);
    }

    public void networkError(NetworkException nwE) {
        this.showConnErrorDialog("Connection Error", this.createErrorText(nwE));
    }

    public void commLinkClosed() {
        this.showConnErrorDialog("Connection Error", this.createErrorText(null));
    }

    public void send(String msg) throws AdapterException {
        String msgStripped = SAPinstAdapter.stripPasswords(msg);
        this.tracer.debug(this.getClass(), "Sent: {0}", msgStripped);
        super.send(msg);
    }

    public void killTool() {
        this.isWaitingForExit = true;
        this.lockDialog();
        this.sendCancel();
    }

    protected void logStartup() {
        this.tracer.info(this.getClass(), "*************************************************");
        this.tracer.info(this.getClass(), "Starting SAPinstGui with the following paramters:");
        this.tracer.info(this.getClass(), "   SAPinstGUI Version               : 1.0.1");
        this.tracer.info(this.getClass(), "   Java Runtime Version             : " + System.getProperty("java.version"));
        this.tracer.info(this.getClass(), "   Java Home Directory              : " + System.getProperty("java.home"));
        this.tracer.info(this.getClass(), "   Java Vendor                      : " + System.getProperty("java.vendor"));
        this.tracer.info(this.getClass(), "   Operating System Architecture    : " + System.getProperty("os.arch"));
        this.tracer.info(this.getClass(), "   Operating System Name            : " + System.getProperty("os.name"));
        this.tracer.info(this.getClass(), "   Operating System Version         : " + System.getProperty("os.version"));
    }

    protected CommLinkIF createCommLink() {
        return new SAPinstCommLink();
    }

    protected int getDefaultPort() {
        return 21212;
    }

    protected void handshake() throws AdapterException {
        this.sendLogon();
        this.receiveReply();
    }

    protected void handleMsg(String msg) throws AdapterException {
        String msgStripped = SAPinstAdapter.stripPasswords(msg);
        this.tracer.debug(this.getClass(), "Received: {0}", msgStripped);
        msg = SAPinstAdapter.quoteIllegalXMLChars(msg);
        StringReader reader = new StringReader(msg);
        XMLElementIF rootElem = null;
        try {
            rootElem = XMLAdmin.createXMLElement(reader);
        }
        catch (XMLException xmlE) {
            throw new SAPinstXMLException(xmlE);
        }
        int parserType = SAPinstToolkit.getRootType(rootElem.getName());
        block1 : switch (parserType) {
            case 0: {
                XMLElementIF elem = (XMLElementIF)rootElem.getSubElements().next();
                switch (SAPinstToolkit.getElemType(elem.getName())) {
                    case 1: {
                        this.dialogParser.parse(elem);
                        break block1;
                    }
                    case 2: {
                        this.updateParser.parse(elem);
                        break block1;
                    }
                }
                throw new SAPinstElemException(rootElem);
            }
            case 1: {
                this.alertParser.parse(rootElem);
                break;
            }
            case 2: {
                this.logParser.parse(rootElem);
                break;
            }
            case 3: {
                this.fileParser.parse(rootElem);
                break;
            }
            case 4: {
                this.exit();
                break;
            }
            case 6: {
                this.resourcePoolParser.parse(rootElem);
                break;
            }
        }
    }

    protected SDTView createToolView() {
        return new SDTNetWeaverView();
    }

    void add(String sid, SDTControl control) {
        this.sidToControl.put(sid, control);
        this.controlToSID.put(control, sid);
    }

    void addDependency(String sid, SDTControl control, boolean mode) {
        SAPinstDependency entry = new SAPinstDependency(sid, control, mode);
        this.dependencies.add(entry);
    }

    void clear() {
        this.sidToControl.clear();
        this.controlToSID.clear();
        this.dependencies.clear();
    }

    SDTNetWeaverView getDialog() {
        return (SDTNetWeaverView)this.getToolView();
    }

    void showFileChooser(SDTControl source) {
        ((SAPinstFileParser)this.fileParser).showFileChooser(source);
    }

    SDTActionListener getDialogListener() {
        return (SDTActionListener)((Object)this.dialogListener);
    }

    SDTActionListener getAlertListener() {
        SDTActionListener listener = null;
        listener = this.isWaitingForExit ? (SDTActionListener)((Object)this.terminationListener) : (SDTActionListener)((Object)this.alertListener);
        return listener;
    }

    SDTActionListener getLogListener() {
        return (SDTActionListener)((Object)this.logListener);
    }

    SDTItemListener getDepListener() {
        return this.depListener;
    }

    SAPinstHelpResolver getHelpResolver() {
        return this.helpResolver;
    }

    SDTControl getControl(String sid) {
        return (SDTControl)this.sidToControl.get(sid);
    }

    Vector getDependencies(String sid) {
        Vector<SAPinstDependency> v = new Vector<SAPinstDependency>();
        for (int i = 0; i < this.dependencies.size(); ++i) {
            SAPinstDependency entry = (SAPinstDependency)this.dependencies.get(i);
            if (!entry.getSID().equals(sid)) continue;
            v.add(entry);
        }
        return v;
    }

    Vector getDependencies(SDTControl control) {
        Vector<SAPinstDependency> v = new Vector<SAPinstDependency>();
        for (int i = 0; i < this.dependencies.size(); ++i) {
            SAPinstDependency entry = (SAPinstDependency)this.dependencies.get(i);
            if (entry.getControl() != control) continue;
            v.add(entry);
        }
        return v;
    }

    String getSID(SDTControl control) {
        return (String)this.controlToSID.get(control);
    }

    void checkDependencies() {
        for (int i = 0; i < this.dependencies.size(); ++i) {
            SAPinstDependency dep = (SAPinstDependency)this.dependencies.get(i);
            if (dep.getControl().isEnabled()) continue;
            this.dependencies.remove(i--);
        }
    }

    void storeDefaultValues() {
        for (int i = 0; i < this.dependencies.size(); ++i) {
            SAPinstDependency dep = (SAPinstDependency)this.dependencies.get(i);
            this.storeDefaultValue(dep.getControl());
        }
    }

    void updateDependencies() {
        Iterator it = this.sidToControl.keySet().iterator();
        while (it.hasNext()) {
            String sid = (String)it.next();
            SDTControl control = (SDTControl)this.sidToControl.get(sid);
            int type = control.getType();
            if (type != 11 && type != 10) continue;
            this.updateDependencies(sid);
        }
    }

    void updateDependencies(String sid) {
        SAPinstDependency dep = null;
        Vector deps = this.getDependencies(sid);
        for (int i = 0; i < deps.size(); ++i) {
            dep = (SAPinstDependency)deps.get(i);
            Vector v = this.getDependencies(dep.getControl());
            boolean isEnabled = true;
            for (int j = 0; j < v.size(); ++j) {
                dep = (SAPinstDependency)v.get(j);
                SDTControl control = this.getControl(dep.getSID());
                isEnabled = isEnabled && !(this.isSelected(control) ^ dep.getMode());
            }
            if (!isEnabled) {
                // empty if block
            }
            dep.getControl().setEnabled(isEnabled);
        }
    }

    void toolTerminated(boolean isTerminated) {
        this.isWaitingForExit = false;
        this.service.toolTerminated(this.getInfo().getID(), isTerminated);
    }

    void exit() {
        this.disconnectTool();
        this.toolTerminated(true);
        this.getDialog().close();
    }

    void lockDialog() {
        this.getDialog().setLocked(true);
        this.getDialog().disableButtons();
        this.getDialog().setWaitCursor(true);
    }

    void unlockDialog() {
        this.getDialog().setLocked(false);
        this.getDialog().enableButtons();
        this.getDialog().setWaitCursor(false);
    }

    private void sendLogon() throws SAPinstException {
        XMLElementIF logon = XMLAdmin.createXMLElement();
        logon.setName("sapinstguilogon");
        logon.setAttr("version", "3.1");
        XMLElementIF version = XMLAdmin.createXMLElement();
        version.setName("logon");
        version.setAttr("version", "1.0");
        version.setAttr("user", System.getProperty("user.name"));
        logon.add(version);
        try {
            this.commLink.send(logon.toString());
        }
        catch (NetworkException nwE) {
            throw new SAPinstCommLinkException(nwE);
        }
    }

    private void receiveReply() throws SAPinstException {
        String reply = null;
        try {
            reply = this.commLink.receive();
        }
        catch (NetworkException nwE) {
            throw new SAPinstCommLinkException(nwE);
        }
        try {
            StringReader reader = new StringReader(reply);
            XMLElementIF elem = XMLAdmin.createXMLElement(reader);
            try {
                XMLElementIF logoff = elem.getElement("logoff");
                String text = "<html>The SAPinst you are trying to connect is busy.<br>";
                text = text + "Please enter the correct host and port.<br></html>";
                this.showConnErrorDialog("SAPinst is busy", text);
            }
            catch (XMLException e) {
                // empty catch block
            }
            String version = elem.getAttrString("version");
            VersionIF remoteProtVers = VersionFactory.createVersion(version);
            ((SAPinstCommLink)this.commLink).setProtVers(remoteProtVers);
        }
        catch (XMLException xmlE) {
            throw new SAPinstXMLException(xmlE);
        }
    }

    private void sendCancel() {
        XMLElementIF response = XMLAdmin.createXMLElement();
        response.setName("sapinstguiresp");
        XMLElementIF action = XMLAdmin.createXMLElement();
        action.setName("action");
        action.setContent("ACTION_CANCEL");
        response.add(action);
        try {
            this.send(response.toString());
        }
        catch (AdapterException aE) {
            aE.printStackTrace();
        }
    }

    private void storeDefaultValue(SDTControl control) {
        if (!this.defaultValues.containsKey(control)) {
            Object defaultValue = null;
            switch (control.getType()) {
                case 3: {
                    Vector children = ((SDTPanel)control).getControls();
                    for (int j = 0; j < children.size(); ++j) {
                        this.storeDefaultValue((SDTControl)children.get(j));
                    }
                    break;
                }
                case 15: {
                    break;
                }
                case 7: {
                    defaultValue = ((SDTTextField)control).getText();
                    break;
                }
                case 8: {
                    defaultValue = ((SDTPasswordField)control).getText();
                    break;
                }
                case 11: {
                    defaultValue = new Boolean(((SDTCheckBox)control).isSelected());
                    break;
                }
                case 20: {
                    List buttons = ((SDTRadioBox)control).getButtons();
                    for (int j = 0; j < buttons.size(); ++j) {
                        this.storeDefaultValue((SDTControl)buttons.get(j));
                    }
                    break;
                }
                case 10: {
                    defaultValue = new Boolean(((SDTRadioButton)control).isSelected());
                    break;
                }
                case 16: {
                    defaultValue = ((SDTFileBrowser)control).getText();
                    break;
                }
                case 12: {
                    defaultValue = ((SDTComboBox)control).getSelectedItem();
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
            this.defaultValues.put(control, defaultValue);
        }
    }

    private void setDefaultValue(SDTControl control) {
        Object value = this.defaultValues.get(control);
        switch (control.getType()) {
            case 3: {
                Vector children = ((SDTPanel)control).getControls();
                for (int j = 0; j < children.size(); ++j) {
                    this.setDefaultValue((SDTControl)children.get(j));
                }
                break;
            }
            case 15: {
                break;
            }
            case 7: {
                ((SDTTextField)control).setText((String)value);
                break;
            }
            case 8: {
                ((SDTPasswordField)control).setText((String)value);
                break;
            }
            case 11: {
                ((SDTCheckBox)control).setSelected((Boolean)value);
                break;
            }
            case 20: {
                List buttons = ((SDTRadioBox)control).getButtons();
                for (int j = 0; j < buttons.size(); ++j) {
                    this.setDefaultValue((SDTControl)buttons.get(j));
                }
                break;
            }
            case 10: {
                ((SDTRadioButton)control).setSelected((Boolean)value);
                break;
            }
            case 16: {
                ((SDTFileBrowser)control).setText((String)value);
                break;
            }
            case 12: {
                ((SDTComboBox)control).setSelectedItem((String)value);
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    private boolean isSelected(SDTControl control) {
        boolean isSelected = false;
        control.updateControl();
        switch (control.getType()) {
            case 11: {
                isSelected = ((SDTCheckBox)control).isSelected();
                break;
            }
            case 10: {
                isSelected = ((SDTRadioButton)control).isSelected();
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        return isSelected;
    }

    private String createErrorText(NetworkException nwE) {
        String text = "<html>Connection to SAPinst broken.<br>";
        if (nwE != null) {
            text = text + "Reason: " + nwE.getMessage() + "<br>";
        }
        text = text + "Please correct the error condition and restart the installation";
        text = text + "</html>";
        return text;
    }

    private void showConnErrorDialog(String title, String text) {
        SDTMessageBox popup = new SDTMessageBox();
        popup.setMessageText(text);
        SDTButton button = new SDTButton();
        button.setCaption("Exit", 'E');
        button.setDefault(true);
        button.addActionListener(new SDTActionListener(){

            public void actionPerformed(SDTActionEvent e) {
                SAPinstAdapter.this.exit();
            }
        });
        popup.addButton(button);
        popup.setTitle(title);
        popup.setModal(true);
        this.getDialog().showPopup(popup);
    }

    private static String quoteIllegalXMLChars(String content) {
        char c;
        boolean illegalCharFound = false;
        int n = content.length();
        for (int i = 0; i < n; ++i) {
            c = content.charAt(i);
            if (c >= ' ' || c == '\t' || c == '\n' || c == '\r') continue;
            illegalCharFound = true;
            break;
        }
        if (illegalCharFound) {
            char[] contentArray = content.toCharArray();
            for (int i = 0; i < contentArray.length; ++i) {
                c = contentArray[i];
                if (c >= ' ' || c == '\t' || c == '\n' || c == '\r') continue;
                contentArray[i] = 35;
            }
            content = new String(contentArray);
        }
        return content;
    }

    private static String stripPasswords(String msg) {
        String encrvalueStart = "<encrvalue";
        String encrvalueEnd = "</encrvalue>";
        StringBuffer stripped = null;
        int iStart = 0;
        int i = 0;
        while ((i = msg.indexOf("<encrvalue", iStart)) > -1) {
            int iContentStart;
            if (stripped == null) {
                stripped = new StringBuffer(msg.length());
            }
            if ((iContentStart = msg.indexOf(62, i + "<encrvalue".length()) + 1) == -1) {
                return msg;
            }
            int iContentEnd = msg.indexOf("</encrvalue>", iContentStart);
            if (iContentEnd == -1) {
                return msg;
            }
            stripped.append(msg.substring(iStart, iContentStart));
            iStart = iContentEnd;
        }
        if (iStart == 0) {
            return msg;
        }
        stripped.append(msg.substring(iStart));
        return stripped.toString();
    }

    static {
        $assertionsDisabled = !SAPinstAdapter.class.desiredAssertionStatus();
    }
}

