/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.sapinst;

import com.sap.sdt.engine.core.communication.Configuration;
import com.sap.sdt.engine.core.services.tool.ToolAdapterInfo;
import com.sap.sdt.engine.core.services.tool.ToolID;
import com.sap.sdt.engine.core.services.tool.ToolInfo;
import com.sap.sdt.engine.ext.sapinst.SAPinstServiceIF;
import com.sap.sdt.server.core.controls.SDTPerspective;
import com.sap.sdt.server.core.services.tool.AbstractToolService;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstAdapter;
import com.sap.sdt.server.ext.sapinst.controls.SAPinstPerspective;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;

public class SAPinstService
extends AbstractToolService
implements SAPinstServiceIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/ext/sapinst/SAPinstService.java#2 $";
    private static final String NAME = "SAPinst";
    private static final String CLASS = "com.sap.sdt.server.adapter.sapinst.SAPinstAdapter";
    private static final String EXECUTABLE = "sapinst";
    private static final int PORT = 21212;

    public SAPinstService() {
        super(NAME);
        this.adapterInfo = new ToolAdapterInfo(NAME, CLASS, EXECUTABLE, 21212);
        this.isClientSide = Configuration.getType() == 0;
    }

    public SAPinstService(String host, int port) {
        this();
        this.toolInfo = new ToolInfo(this.adapterInfo, host, port, "");
        this.adapter = new SAPinstAdapter(this, this.toolInfo);
    }

    public void configure(XMLElementIF configuration) {
        String execPath = null;
        int port = -1;
        try {
            execPath = configuration.getElement("Path").getContent();
            port = Integer.parseInt(configuration.getElement("Port").getContent());
        }
        catch (XMLException xmlE) {
            xmlE.printStackTrace();
            System.exit(1);
        }
        catch (NumberFormatException nfE) {
            nfE.printStackTrace();
            System.exit(1);
        }
        this.toolInfo = new ToolInfo(this.adapterInfo, "ls0017", port, execPath);
        this.adapter = new SAPinstAdapter(this, this.toolInfo);
    }

    public Class getInterface() {
        return SAPinstServiceIF.class;
    }

    public void toolTerminated(ToolID toolID, boolean isTerminated) {
        if (this.isWaitingForExit) {
            this.isWaitingForExit = false;
            this.willExit(isTerminated);
        } else if (this.isClientSide) {
            Configuration.getClientAdmin().exit();
        }
    }

    protected String getName() {
        return NAME;
    }

    protected SDTPerspective createPerspective() {
        if (this.perspective == null) {
            this.perspective = new SAPinstPerspective();
        }
        return this.perspective;
    }

    protected void tryExit() {
        this.isWaitingForExit = true;
        this.adapter.killTool();
    }
}

