/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.r3up.resources;

import com.sap.sdt.server.ext.r3up.adapter.SvrLog;
import com.sap.sdt.util.string.IncompletePairException;
import com.sap.sdt.util.string.PairPositions;
import com.sap.sdt.util.string.PairSearcher;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public class PropertyAdmin
extends Properties {
    private String lastPropFileName = null;
    private String startPattern = "$(";
    private String stopPattern = ")";
    private static int maxReplaceDepth = 16;
    private int curReplaceDepth = 0;

    public PropertyAdmin() {
    }

    public PropertyAdmin(String propFileName) throws IOException {
        this.load(propFileName);
    }

    public String replace(String src, String[] params) {
        if (src == null) {
            return null;
        }
        PairSearcher ps = null;
        try {
            ps = new PairSearcher(src, this.startPattern, this.stopPattern);
        }
        catch (IncompletePairException e) {
            return null;
        }
        if (ps == null || ps.getNumberOfHits() == 0) {
            return src;
        }
        if (this.curReplaceDepth >= maxReplaceDepth) {
            SvrLog.err("Maximum depth of recursion (" + this.curReplaceDepth + ") exceeded for property '" + src + "' in file '" + this.lastPropFileName + "'");
            return src;
        }
        ++this.curReplaceDepth;
        StringBuffer buf = new StringBuffer(2 * src.length());
        int pos = 0;
        for (int i = 0; i < ps.getNumberOfHits(); ++i) {
            String val;
            PairPositions pp = ps.getHitNumber(i);
            String hit = ps.getEnclosedString(i);
            try {
                int num = Integer.parseInt(hit);
                val = params != null && num >= 0 && num <= params.length ? params[num] : this.startPattern + hit + this.stopPattern;
            }
            catch (NumberFormatException e) {
                val = this.get(hit);
            }
            buf.append(src.substring(pos, pp.getStartPos1()));
            buf.append(val);
            pos = pp.getStopPos2();
        }
        buf.append(src.substring(pos, src.length()));
        --this.curReplaceDepth;
        return buf.toString();
    }

    public void load(String propFileName) throws IOException {
        FileInputStream propFile = new FileInputStream(propFileName);
        this.load(propFile);
        propFile.close();
        this.lastPropFileName = propFileName;
        SvrLog.out("Property file '" + propFileName + "' read");
    }

    public String get(String key) {
        String prop = this.getProperty(key);
        if (prop != null) {
            return this.replace(prop, null);
        }
        SvrLog.out("Property '" + key + "' not found in file '" + this.lastPropFileName + "'");
        return key;
    }

    public String get(String key, String param) {
        String[] params = new String[]{param};
        return this.replace(this.getProperty(key), params);
    }

    public String get(String key, String[] params) {
        return this.replace(this.getProperty(key), params);
    }

    public int get(String key, int notFound) {
        try {
            int radix;
            String val = this.get(key).toUpperCase();
            if (val.startsWith("0X")) {
                radix = 16;
                val = val.substring(2);
            } else if (val.startsWith("0")) {
                radix = 8;
                val = val.substring(1);
            } else {
                radix = 10;
            }
            return Integer.parseInt(val, radix);
        }
        catch (StringIndexOutOfBoundsException e0) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return notFound;
    }

    public void print() {
        System.out.println("PropertyAdmin listing");
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = this.get(key);
            System.out.println(key + " = " + value);
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            return;
        }
        PropertyAdmin admin = new PropertyAdmin();
        for (int i = 0; i < args.length; ++i) {
            try {
                admin.load(args[i]);
                continue;
            }
            catch (IOException e) {
                System.err.println("Cannot load " + args[i] + " : " + e.getMessage());
            }
        }
        admin.print();
    }
}

