/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.r3up.adapter;

import com.sap.sdt.server.core.controls.SDTActionListener;
import com.sap.sdt.server.core.controls.SDTButton;
import com.sap.sdt.server.core.controls.SDTControl;
import com.sap.sdt.server.core.controls.SDTPanel;
import com.sap.sdt.server.ext.r3up.adapter.MsgProcessorConstants;
import com.sap.sdt.server.ext.r3up.adapter.R3upAdapter;
import com.sap.sdt.server.ext.r3up.adapter.R3upMsgElem;
import com.sap.sdt.server.ext.r3up.adapter.ServerInternalError;
import com.sap.sdt.server.ext.r3up.adapter.WizardElement;
import com.sap.sdt.server.ext.r3up.adapter.WizardElementQuery;
import com.sap.sdt.server.ext.r3up.adapter.WizardElementSelect;
import com.sap.sdt.server.ext.r3up.adapter.WizardElementText;
import com.sap.sdt.server.ext.r3up.adapter.WizardQuestion;
import com.sap.sdt.server.ext.r3up.resources.TextAdmin;
import java.util.Enumeration;
import java.util.Vector;

class WizardScreen
extends WizardElement
implements MsgProcessorConstants {
    private Integer handle;
    private boolean isSummaryScreen;
    private WizardElementText wizTitle;
    private String title = null;
    private String text = null;
    private Vector wizElemVect;
    private boolean containsQuestion;
    private TextAdmin tA;
    private R3upMsgElem msgElem;

    private WizardElement createSubElement(R3upMsgElem param) {
        WizardElement wizElem;
        switch (param.getMsgType()) {
            case 14: {
                throw new ServerInternalError("Screen directly nested in Screen");
            }
            case 15: {
                throw new ServerInternalError("Screen directly nested in Screen");
            }
            case 1: {
                wizElem = new WizardElementText(this.adapter, param);
                break;
            }
            case 0: {
                wizElem = new WizardElementText(this.adapter, param);
                break;
            }
            case 8: {
                wizElem = new WizardElementSelect(this.adapter, param, 1);
                break;
            }
            case 6: {
                wizElem = new WizardElementSelect(this.adapter, param, 0);
                break;
            }
            case 5: {
                wizElem = new WizardElementQuery(this.adapter, param, 0);
                break;
            }
            case 4: {
                wizElem = new WizardElementQuery(this.adapter, param, 1);
                break;
            }
            case 7: {
                this.containsQuestion = true;
                wizElem = new WizardQuestion(this.adapter, param);
                break;
            }
            default: {
                wizElem = null;
            }
        }
        return wizElem;
    }

    private SDTButton getNavigationButton(String buttonText) {
        SDTButton button = new SDTButton();
        button.setCaption(this.tA.get(buttonText), '#');
        return button;
    }

    private SDTButton getHelpButton(SDTActionListener aL) {
        if (this.msgElem.getAttrValue(8) == null) {
            return null;
        }
        SDTButton helpButton = new SDTButton();
        helpButton.setCaption(this.tA.get("HELP"), '#');
        helpButton.addActionListener(aL);
        return helpButton;
    }

    WizardScreen(R3upAdapter adapter, R3upMsgElem msg) {
        this(adapter, msg, new Integer(msg.getHandleVal()));
    }

    WizardScreen(R3upAdapter adapter, R3upMsgElem msg, Integer newHandle) {
        super(adapter);
        this.handle = newHandle;
        this.msgElem = msg;
        this.wizElemVect = new Vector();
        this.containsQuestion = false;
        this.tA = adapter.getTextAdmin();
        if (msg.getMsgType() != 15) {
            WizardElement wizElem = this.createSubElement(msg);
            if (wizElem != null) {
                this.wizElemVect.addElement(wizElem);
            }
        } else {
            this.title = msg.getAttrValue(2);
            this.text = msg.getAttrValue(3);
            Enumeration e = msg.getParameters();
            while (e.hasMoreElements()) {
                R3upMsgElem param = (R3upMsgElem)e.nextElement();
                WizardElement wizElem = this.createSubElement(param);
                if (wizElem == null) continue;
                this.wizElemVect.addElement(wizElem);
            }
        }
    }

    String getTitle() {
        return this.title;
    }

    String getText() {
        return this.text;
    }

    SDTControl getControl(Vector actButtons, Vector inputElems, Vector inputMsg) {
        return this.getControl(actButtons, inputElems, inputMsg, false);
    }

    SDTControl getControl(Vector actButtons, Vector inputElems, Vector inputMsg, boolean isSingle) {
        boolean useScroll;
        int noOfElems = this.wizElemVect.size();
        boolean bl = useScroll = WizardScreen.useScrollPane() || isSingle && WizardScreen.useScrollPaneSingle();
        if (useScroll) {
            throw new RuntimeException("Scroll not yet implemented");
        }
        SDTPanel screenPanel = new SDTPanel();
        int elemInx = 1;
        Enumeration e = this.wizElemVect.elements();
        while (e.hasMoreElements()) {
            WizardElement wizElem = (WizardElement)e.nextElement();
            SDTControl child = wizElem.getControl(actButtons, inputElems, inputMsg);
            screenPanel.add(child);
            ++elemInx;
        }
        if (useScroll) {
            throw new RuntimeException("Scroll not yet implemented");
        }
        return screenPanel;
    }

    boolean doesContainQuestion() {
        return this.containsQuestion;
    }

    Vector getButtonPanel(SDTActionListener actionListener, SDTButton buttonOk, SDTPanel first, SDTPanel prev, SDTPanel next, SDTPanel last) {
        SDTButton helpButton;
        Vector<SDTButton> buttons = new Vector<SDTButton>();
        if (first != null || prev != null || next != null || last != null) {
            buttons.add(this.getNavigationButton("FIRST_PAGE"));
            buttons.add(this.getNavigationButton("PREVIOUS_PAGE"));
            buttons.add(this.getNavigationButton("NEXT_PAGE"));
            buttons.add(this.getNavigationButton("LAST_PAGE"));
        }
        buttons.add(buttonOk);
        if (next != null) {
            buttonOk.setEnabled(false);
        }
        if ((helpButton = this.getHelpButton(actionListener)) != null) {
            buttons.add(helpButton);
        }
        return buttons;
    }

    Vector getButtonPanel(SDTActionListener actionListener, Vector actionButtons, Vector inputElems, Vector inputMsg) {
        WizardElement wizElem = null;
        Vector buttons = null;
        Enumeration e = this.wizElemVect.elements();
        while (e.hasMoreElements() && !((wizElem = (WizardElement)e.nextElement()) instanceof WizardQuestion)) {
        }
        if (wizElem == null) {
            throw new ServerInternalError("No WizardQuestion found on screen");
        }
        if (!(wizElem instanceof WizardQuestion)) {
            throw new ServerInternalError("No WizardQuestion found on screen");
        }
        buttons = ((WizardQuestion)wizElem).getButtonPanel(actionListener, actionButtons, inputElems, inputMsg);
        SDTButton helpButton = this.getHelpButton(actionListener);
        if (helpButton != null) {
            buttons.add(helpButton);
        }
        return buttons;
    }
}

