/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.r3up.adapter;

import com.sap.sdt.server.core.controls.SDTActionListener;
import com.sap.sdt.server.core.controls.SDTButton;
import com.sap.sdt.server.core.controls.SDTControl;
import com.sap.sdt.server.ext.r3up.adapter.MsgReplyBool;
import com.sap.sdt.server.ext.r3up.adapter.R3upAdapter;
import com.sap.sdt.server.ext.r3up.adapter.R3upMsgElem;
import com.sap.sdt.server.ext.r3up.adapter.WizardElement;
import com.sap.sdt.server.ext.r3up.adapter.WizardElementText;
import java.util.Enumeration;
import java.util.Vector;

class WizardQuestion
extends WizardElement {
    private Integer handle;
    private WizardElementText headerText;
    private Vector buttonInfos = new Vector();

    WizardQuestion(R3upAdapter adapter, R3upMsgElem msg) {
        super(adapter);
        this.handle = new Integer(msg.getHandleVal());
        this.headerText = new WizardElementText(adapter, msg.getAttrValue(3));
        Enumeration e = msg.getParameters();
        while (e.hasMoreElements()) {
            R3upMsgElem param = (R3upMsgElem)e.nextElement();
            this.buttonInfos.addElement(new ButtonInfo(param.getAttrValue(5), new Integer(param.getHandleVal()), param.getAttrValue(6), param));
        }
    }

    SDTControl getControl(Vector actionButtons, Vector inputElems, Vector inputMsg) {
        return this.headerText.getControl(actionButtons, inputElems, inputMsg);
    }

    SDTControl getControl() {
        return this.getControl(null, null, null);
    }

    Vector getButtonPanel(SDTActionListener actionListener, Vector actionButtons, Vector inputElems, Vector inputMsg) {
        Vector<SDTButton> buttons = new Vector<SDTButton>();
        int index = 0;
        Enumeration e = this.buttonInfos.elements();
        while (e.hasMoreElements()) {
            ButtonInfo buttonInfo = (ButtonInfo)e.nextElement();
            SDTButton button = new SDTButton();
            button.setCaption(buttonInfo.getName(), '#');
            this.storeInputIdent(button, new MsgReplyBool(buttonInfo.getHandle(), index));
            this.storeInputControl(button, (SDTControl)button);
            button.addActionListener(actionListener);
            actionButtons.addElement(button);
            inputElems.addElement(button);
            inputMsg.addElement(buttonInfo.getMessage());
            buttons.add(button);
            ++index;
        }
        return buttons;
    }

    private class ButtonInfo {
        private String name;
        private String value;
        private Integer handle;
        private R3upMsgElem message;

        private String toUpperFirst(String text) {
            return text.substring(0, 1).toUpperCase() + text.substring(1);
        }

        ButtonInfo(String newName, Integer newHandle, String newValue, R3upMsgElem newMessage) {
            this.name = this.toUpperFirst(newName);
            this.value = newValue;
            this.handle = newHandle;
            this.message = newMessage;
        }

        String getName() {
            return this.name;
        }

        String getValue() {
            return this.value;
        }

        Integer getHandle() {
            return this.handle;
        }

        R3upMsgElem getMessage() {
            return this.message;
        }
    }
}

