/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.r3up.adapter;

import com.sap.sdt.server.core.controls.SDTButton;
import com.sap.sdt.server.core.controls.SDTPanel;
import com.sap.sdt.server.core.services.tool.views.SDTNetWeaverView;
import com.sap.sdt.server.ext.r3up.adapter.KeyConstants;
import com.sap.sdt.server.ext.r3up.adapter.MsgProcessor;
import com.sap.sdt.server.ext.r3up.adapter.R3upAdapter;
import com.sap.sdt.server.ext.r3up.adapter.R3upMsgElem;
import com.sap.sdt.server.ext.r3up.adapter.WizardMain;
import java.util.Vector;

class WizardMsgProcessor
extends MsgProcessor
implements KeyConstants {
    private String title = "FOO";
    private int currentScreen = 0;
    private SDTPanel[] empty = new SDTPanel[0];
    private SDTPanel[] panels = this.empty;

    WizardMsgProcessor(R3upAdapter adapter) {
        super(adapter);
    }

    void doWizard(R3upMsgElem msg) {
        WizardMain wizard;
        switch (msg.getMsgType()) {
            case 14: {
                wizard = new WizardMain(this.adapter, this, msg);
                break;
            }
            default: {
                wizard = new WizardMain(this.adapter, this, msg, -1);
            }
        }
        msg.setWizard(wizard);
    }

    void showInputInternal(R3upMsgElem msg) {
        if (msg == null || msg.getWizard() == null) {
            return;
        }
        WizardMain wizard = msg.getWizard();
        this.panels = wizard.getPanels();
        SDTNetWeaverView dialog = (SDTNetWeaverView)this.adapter.getToolView();
        dialog.remove(this.adapter.getEchoPanel());
        this.currentScreen = wizard.getFirstScreenInx();
        dialog.setTitle(wizard.getScreen(this.currentScreen).getTitle());
        dialog.setDescription(wizard.getScreen(this.currentScreen).getText());
        dialog.add(this.panels[this.currentScreen]);
        Vector buttons = wizard.getButtons();
        if (buttons != null) {
            for (int i = 0; i < buttons.size(); ++i) {
                dialog.addButton((SDTButton)buttons.get(i));
            }
        }
        dialog.refresh();
    }

    void showNextScreen() {
        this.showScreen(this.currentScreen + 1);
    }

    void showPreviousScreen() {
        this.showScreen(this.currentScreen - 1);
    }

    void showLastScreen() {
        this.showScreen(this.panels.length - 1);
    }

    void showFirstScreen() {
        this.showScreen(0);
    }

    private void showScreen(int index) {
        SDTNetWeaverView dialog = (SDTNetWeaverView)this.adapter.getToolView();
        dialog.remove(this.panels[this.currentScreen]);
        dialog.add(this.panels[index]);
        this.currentScreen = index;
    }

    private void closeInputInternal(R3upMsgElem msg, boolean keep) {
        this.adapter.clear();
        SDTNetWeaverView dialog = (SDTNetWeaverView)this.adapter.getToolView();
        dialog.removeButtons();
        dialog.remove(this.panels[0]);
        dialog.add(this.adapter.getEchoPanel());
        dialog.refresh();
        this.panels = this.empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showInput(R3upMsgElem msg) {
        SDTPanel[] sDTPanelArray = this.empty;
        synchronized (this.empty) {
            this.showInputInternal(msg);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeInput(R3upMsgElem msg, boolean keep) {
        SDTPanel[] sDTPanelArray = this.empty;
        synchronized (this.empty) {
            this.closeInputInternal(msg, keep);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }
}

