/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.r3up.adapter;

import com.sap.sdt.server.core.controls.SDTActionListener;
import com.sap.sdt.server.core.controls.SDTButton;
import com.sap.sdt.server.core.controls.SDTControl;
import com.sap.sdt.server.core.controls.SDTPanel;
import com.sap.sdt.server.ext.r3up.adapter.KeyConstants;
import com.sap.sdt.server.ext.r3up.adapter.MsgProcessorConstants;
import com.sap.sdt.server.ext.r3up.adapter.R3upAdapter;
import com.sap.sdt.server.ext.r3up.adapter.R3upMsgElem;
import com.sap.sdt.server.ext.r3up.adapter.R3upMsgParserConstants;
import com.sap.sdt.server.ext.r3up.adapter.WizardElement;
import com.sap.sdt.server.ext.r3up.adapter.WizardInterface;
import com.sap.sdt.server.ext.r3up.adapter.WizardScreen;
import com.sap.sdt.server.ext.r3up.resources.TextAdmin;
import java.util.Enumeration;
import java.util.Vector;

class WizardMain
extends WizardElement
implements WizardInterface,
MsgProcessorConstants,
R3upMsgParserConstants,
KeyConstants {
    private Integer handle;
    private int firstScreenInx;
    private Vector wizScreenVect;
    private TextAdmin tA;
    private SDTActionListener aL;
    private R3upMsgElem msg;
    private Vector buttons = null;

    private int getFirstWizScreenInx() {
        int inx = 0;
        Enumeration e = this.msg.getParameters();
        while (e.hasMoreElements()) {
            if (((R3upMsgElem)e.nextElement()).getAttrValue(10) != null) {
                return inx;
            }
            ++inx;
        }
        return 0;
    }

    private boolean containsQuestion() {
        Enumeration e = this.wizScreenVect.elements();
        while (e.hasMoreElements()) {
            if (!((WizardScreen)e.nextElement()).doesContainQuestion()) continue;
            return true;
        }
        return false;
    }

    WizardMain(R3upAdapter adapter, SDTActionListener aL, R3upMsgElem msg) {
        this(adapter, aL, msg, msg.getHandleVal());
    }

    WizardMain(R3upAdapter adapter, SDTActionListener aL, R3upMsgElem msg, int handleVal) {
        super(adapter);
        this.tA = adapter.getTextAdmin();
        this.aL = aL;
        this.msg = msg;
        this.handle = new Integer(handleVal);
        this.firstScreenInx = this.getFirstWizScreenInx();
        this.wizScreenVect = new Vector();
        if (msg.getMsgType() != 14) {
            WizardScreen wizScreen = new WizardScreen(adapter, msg);
            if (wizScreen != null) {
                this.wizScreenVect.addElement(wizScreen);
            }
        } else {
            Enumeration e = msg.getParameters();
            while (e.hasMoreElements()) {
                R3upMsgElem param = (R3upMsgElem)e.nextElement();
                WizardScreen wizScreen = new WizardScreen(adapter, param);
                if (wizScreen == null) continue;
                this.wizScreenVect.addElement(wizScreen);
            }
        }
    }

    int getFirstScreenInx() {
        return this.firstScreenInx;
    }

    WizardScreen getScreen(int index) {
        return (WizardScreen)this.wizScreenVect.get(index);
    }

    SDTPanel[] getQuestionPanel(SDTActionListener actionListener, Vector inputElems, Vector inputMsg) {
        Vector actionButtons = new Vector();
        SDTPanel[] panels = new SDTPanel[]{new SDTPanel()};
        WizardScreen questionScreen = (WizardScreen)this.wizScreenVect.firstElement();
        SDTControl questionPanel = questionScreen.getControl(actionButtons, inputElems, inputMsg, true);
        this.buttons = questionScreen.getButtonPanel(actionListener, actionButtons, inputElems, inputMsg);
        panels[0].add(questionPanel);
        return panels;
    }

    SDTPanel[] getScreenPanel(SDTActionListener actionListener, Vector inputElems, Vector inputMsg) {
        int scrInx;
        int noOfPanels = this.wizScreenVect.size();
        SDTPanel[] panels = new SDTPanel[noOfPanels];
        for (scrInx = 0; scrInx < noOfPanels; ++scrInx) {
            panels[scrInx] = new SDTPanel();
        }
        Vector<SDTButton> actionButtons = new Vector<SDTButton>();
        SDTButton finalButtonOk = new SDTButton();
        finalButtonOk.setCaption(this.tA.get("OK"), '#');
        actionButtons.addElement(finalButtonOk);
        finalButtonOk.addActionListener(actionListener);
        scrInx = 0;
        Enumeration e = this.wizScreenVect.elements();
        while (e.hasMoreElements()) {
            SDTButton buttonOk;
            SDTPanel lastPanel;
            SDTPanel nextPanel;
            SDTPanel prevPanel;
            SDTPanel firstPanel;
            WizardScreen wizElem = (WizardScreen)e.nextElement();
            if (noOfPanels == 1) {
                firstPanel = null;
                prevPanel = null;
                nextPanel = null;
                lastPanel = null;
                buttonOk = finalButtonOk;
            } else if (scrInx == 0) {
                firstPanel = null;
                prevPanel = null;
                nextPanel = panels[scrInx + 1];
                lastPanel = panels[noOfPanels - 1];
                buttonOk = new SDTButton();
                buttonOk.setCaption(this.tA.get("OK"), '#');
            } else if (scrInx == noOfPanels - 1) {
                firstPanel = panels[0];
                prevPanel = panels[scrInx - 1];
                nextPanel = null;
                lastPanel = null;
                buttonOk = finalButtonOk;
            } else {
                firstPanel = panels[0];
                prevPanel = panels[scrInx - 1];
                nextPanel = panels[scrInx + 1];
                lastPanel = panels[noOfPanels - 1];
                buttonOk = new SDTButton();
                buttonOk.setCaption(this.tA.get("OK"), '#');
            }
            this.buttons = wizElem.getButtonPanel(actionListener, buttonOk, firstPanel, prevPanel, nextPanel, lastPanel);
            SDTControl screenPanel = wizElem.getControl(actionButtons, inputElems, inputMsg, noOfPanels == 1);
            SDTPanel thisPanel = panels[scrInx];
            thisPanel.add(screenPanel);
            ++scrInx;
        }
        return panels;
    }

    SDTPanel getDialog() {
        SDTPanel dialog = new SDTPanel();
        SDTPanel[] panels = this.getPanels();
        for (int index = 0; index < panels.length; ++index) {
            dialog.add(panels[index]);
        }
        return dialog;
    }

    SDTPanel[] getPanels() {
        Vector iElems = new Vector();
        Vector iMsgs = new Vector();
        SDTPanel[] panels = this.containsQuestion() ? this.getQuestionPanel(this.aL, iElems, iMsgs) : this.getScreenPanel(this.aL, iElems, iMsgs);
        R3upMsgElem[] elemArr = new R3upMsgElem[iElems.size()];
        int index = 0;
        Enumeration e = iMsgs.elements();
        while (e.hasMoreElements()) {
            elemArr[index] = (R3upMsgElem)e.nextElement();
            ++index;
        }
        this.msg.setIndexedElems(elemArr);
        return panels;
    }

    Vector getButtons() {
        return this.buttons;
    }
}

