/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.r3up.adapter;

import com.sap.sdt.engine.core.controls.table.SDTTableColumn;
import com.sap.sdt.engine.core.controls.table.SDTTableRow;
import com.sap.sdt.server.core.controls.SDTCaptionComponent;
import com.sap.sdt.server.core.controls.SDTCheckBox;
import com.sap.sdt.server.core.controls.SDTControl;
import com.sap.sdt.server.core.controls.SDTPanel;
import com.sap.sdt.server.core.controls.SDTRadioBox;
import com.sap.sdt.server.core.controls.SDTRadioButton;
import com.sap.sdt.server.core.controls.SDTStyledText;
import com.sap.sdt.server.core.controls.SDTTable;
import com.sap.sdt.server.ext.r3up.adapter.MsgReplyBool;
import com.sap.sdt.server.ext.r3up.adapter.R3upAdapter;
import com.sap.sdt.server.ext.r3up.adapter.R3upMsgElem;
import com.sap.sdt.server.ext.r3up.adapter.ServerInternalError;
import com.sap.sdt.server.ext.r3up.adapter.WizardElement;
import com.sap.sdt.server.ext.r3up.adapter.WizardElementText;
import com.sap.sdt.server.ext.r3up.resources.TextAdmin;
import java.util.Enumeration;
import java.util.Vector;

class WizardElementSelect
extends WizardElement {
    private static final int MAX_CHOICES = 16;
    private Integer handle;
    private boolean single;
    private boolean fewRows;
    private WizardElementText wizHeader;
    private WizardElementText wizSummary;
    private Vector headRows;
    private Vector optRows;
    private R3upMsgElem selMessage;
    private TextAdmin tA;
    private boolean foobar = false;

    void doLayoutMany(SDTPanel queryPanel, Vector actButtons, Vector inputElems, Vector inputMsg) {
        throw new RuntimeException("GuiList not implemented");
    }

    void doLayoutFew(SDTPanel queryPanel, Vector actButtons, Vector inputElems, Vector inputMsg) {
        SelectRow selRow;
        SDTPanel headerPanel = new SDTPanel();
        Enumeration e = this.headRows.elements();
        while (e.hasMoreElements()) {
            selRow = (SelectRow)e.nextElement();
            SDTStyledText tmpLabel = new SDTStyledText(false);
            tmpLabel.setText(selRow.getName());
            headerPanel.add(tmpLabel);
        }
        queryPanel.add(headerPanel);
        SDTControl control = null;
        SDTControl container = this.createContainer();
        Enumeration e2 = this.optRows.elements();
        while (e2.hasMoreElements()) {
            selRow = (SelectRow)e2.nextElement();
            control = this.createSelectControl(selRow);
            MsgReplyBool reply = new MsgReplyBool(selRow.getHandle(), inputElems.size());
            this.storeInputIdent(control, reply);
            this.storeInputControl(actButtons, control);
            inputElems.addElement(control);
            inputMsg.addElement(selRow.getMessage());
            this.addControl(container, control);
        }
        queryPanel.add(container);
    }

    WizardElementSelect(R3upAdapter adapter, R3upMsgElem msg, int multiSelect) {
        super(adapter);
        this.tA = adapter.getTextAdmin();
        switch (multiSelect) {
            case 0: {
                this.single = true;
                break;
            }
            case 1: {
                this.single = false;
                break;
            }
            default: {
                throw new ServerInternalError("unknown WizardElementSelect 'multiSelect' value");
            }
        }
        this.handle = new Integer(msg.getHandleVal());
        this.selMessage = msg;
        String text = msg.getAttrValue(2);
        text = text != null ? text + "\n" : "";
        text = text + msg.getAttrValue(3);
        if (msg.getAttrValue(3).startsWith("Select the PREPARE modules")) {
            this.foobar = true;
        }
        this.wizHeader = new WizardElementText(adapter, text);
        this.wizSummary = new WizardElementText(adapter, msg.getAttrValue(9));
        this.headRows = new Vector();
        this.optRows = new Vector();
        this.fewRows = msg.getNoOfParameters() <= 16;
        Enumeration e = msg.getParameters();
        while (e.hasMoreElements()) {
            R3upMsgElem param = (R3upMsgElem)e.nextElement();
            Integer rowHandle = new Integer(param.getHandleVal());
            String name = param.getAttrValue(5);
            String value = param.getAttrValue(6);
            if (this.fewRows && value == null) {
                throw new ServerInternalError("Invalid attribute value");
            }
            boolean state = value.equalsIgnoreCase("X");
            boolean head = value.equalsIgnoreCase("H");
            if (head) {
                this.headRows.addElement(new SelectRow(name, value, state, rowHandle));
                continue;
            }
            if (this.fewRows) {
                this.optRows.addElement(new SelectRow(name, value, state, rowHandle, param));
                continue;
            }
            this.optRows.addElement(new SelectRow(name, value, state, rowHandle));
        }
    }

    SDTControl getControl(Vector actButtons, Vector inputElems, Vector inputMsg) {
        SDTControl child = this.wizHeader.getControl();
        SDTPanel selectPanel = new SDTPanel();
        selectPanel.add(child);
        this.foobar = false;
        if (this.foobar) {
            this.layoutTable(selectPanel, actButtons, inputElems, inputMsg);
            return selectPanel;
        }
        if (this.fewRows) {
            this.doLayoutFew(selectPanel, actButtons, inputElems, inputMsg);
        } else {
            this.doLayoutMany(selectPanel, actButtons, inputElems, inputMsg);
        }
        return selectPanel;
    }

    private SDTControl createContainer() {
        SDTControl container = null;
        container = this.single ? new SDTRadioBox() : new SDTPanel();
        return container;
    }

    private SDTControl createSelectControl(SelectRow selRow) {
        SDTCaptionComponent control = null;
        if (this.single) {
            SDTRadioButton rB = new SDTRadioButton();
            rB.setCaption(selRow.getName(), '#');
            rB.setSelected(selRow.getState());
            control = rB;
        } else {
            SDTCheckBox cB = new SDTCheckBox();
            cB.setCaption(selRow.getName(), '#');
            cB.setSelected(selRow.getState());
            control = cB;
        }
        return control;
    }

    private void addControl(SDTControl container, SDTControl control) {
        if (this.single) {
            ((SDTRadioBox)container).add((SDTRadioButton)control);
        } else {
            ((SDTPanel)container).add(control);
        }
    }

    private void layoutTable(SDTPanel queryPanel, Vector actButtons, Vector inputElems, Vector inputMsg) {
        SDTTable table = new SDTTable();
        SDTTableColumn c1 = new SDTTableColumn();
        c1.setCaption("Name");
        c1.setColumnType(0);
        c1.setEnabled(false);
        SDTTableColumn c2 = new SDTTableColumn();
        c2.setCaption("Status");
        c2.setColumnType(0);
        c2.setEnabled(false);
        SDTTableColumn c3 = new SDTTableColumn();
        c3.setCaption("Mandatory");
        c3.setColumnType(0);
        c3.setEnabled(false);
        SDTTableColumn c4 = new SDTTableColumn();
        c4.setCaption("Select");
        c4.setColumnType(1);
        c4.setEnabled(true);
        table.addColumn(c1);
        table.addColumn(c2);
        table.addColumn(c3);
        table.addColumn(c4);
        table.enableAddRemove(true);
        Enumeration e = this.optRows.elements();
        while (e.hasMoreElements()) {
            SelectRow selRow = (SelectRow)e.nextElement();
            String text = selRow.getName();
            boolean isSelected = selRow.getState();
            SDTTableRow row = new SDTTableRow();
            text = text.trim();
            String[] str = new String[3];
            int pos = text.length();
            int hits = 0;
            for (int i = text.length() - 1; i > 0; --i) {
                if (text.charAt(i) != ' ') continue;
                str[hits] = text.substring(i + 1, pos);
                ++hits;
                while (text.charAt(i) == ' ') {
                    --i;
                }
                pos = i + 1;
                if (hits != 2) continue;
                str[hits] = text.substring(0, pos);
                break;
            }
            row.add(str[2]);
            row.add(str[1]);
            row.add(str[0]);
            row.add(new Boolean(isSelected));
            table.addRow(row);
        }
        queryPanel.add(table);
    }

    private class SelectRow {
        private String name;
        private String value;
        private boolean state;
        private Integer handle;
        private R3upMsgElem message;

        SelectRow(String newName, String newValue, boolean newState, Integer newHandle, R3upMsgElem newMessage) {
            this.name = newName;
            this.value = newValue;
            this.state = newState;
            this.handle = newHandle;
            this.message = newMessage;
        }

        SelectRow(String newName, String newValue, boolean newState, Integer newHandle) {
            this(newName, newValue, newState, newHandle, null);
        }

        SelectRow(String newName, String newValue, boolean newState) {
            this(newName, newValue, newState, new Integer(-1), null);
        }

        String getName() {
            return this.name;
        }

        String getValue() {
            return this.value;
        }

        boolean getState() {
            return this.state;
        }

        Integer getHandle() {
            return this.handle;
        }

        R3upMsgElem getMessage() {
            return this.message;
        }
    }
}

