/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.r3up.adapter;

import com.sap.sdt.server.core.controls.SDTCaptionComponent;
import com.sap.sdt.server.core.controls.SDTControl;
import com.sap.sdt.server.core.controls.SDTPasswordField;
import com.sap.sdt.server.core.controls.SDTTextField;
import com.sap.sdt.server.ext.r3up.adapter.MsgReplyString;
import com.sap.sdt.server.ext.r3up.adapter.R3upAdapter;
import com.sap.sdt.server.ext.r3up.adapter.R3upMsgElem;
import com.sap.sdt.server.ext.r3up.adapter.ServerInternalError;
import com.sap.sdt.server.ext.r3up.adapter.WizardElement;
import java.util.Vector;

class WizardElementInfield
extends WizardElement {
    private Integer handle;
    private String text;
    private String value;
    private boolean hide;
    private boolean lastInputRow;
    private int rowIndex;
    private R3upMsgElem msgElem;

    WizardElementInfield(R3upAdapter adapter, R3upMsgElem msg, int hiddenInput, int whichRow, int fieldInx) {
        super(adapter);
        switch (hiddenInput) {
            case 0: {
                this.hide = true;
                break;
            }
            case 1: {
                this.hide = false;
                break;
            }
            default: {
                throw new ServerInternalError("unknown WizardElementInfield 'hiddenInput' value");
            }
        }
        switch (whichRow) {
            case 2: {
                this.lastInputRow = true;
                break;
            }
            case -1: 
            case 0: 
            case 1: {
                this.lastInputRow = false;
                break;
            }
            default: {
                throw new ServerInternalError("unknown WizardElementInfield 'lastInputRow' value");
            }
        }
        this.rowIndex = fieldInx;
        this.handle = new Integer(msg.getHandleVal());
        this.text = msg.getAttrValue(5);
        this.value = msg.getAttrValue(6);
        this.msgElem = msg;
        msg.setEcho(!this.hide);
    }

    WizardElementInfield(R3upAdapter adapter, R3upMsgElem msg) {
        this(adapter, msg, 1, -1, 0);
    }

    SDTControl getControl(Vector actButtons, Vector inputGlyph, Vector inputMsg) {
        SDTCaptionComponent elemField = null;
        if (this.msgElem.echoAllowed()) {
            elemField = new SDTTextField();
            elemField.setCaption(this.text, '#');
            if (this.value != null) {
                ((SDTTextField)elemField).setText(this.value);
            }
        } else {
            elemField = new SDTPasswordField();
            ((SDTPasswordField)elemField).setCaption(this.text, '#');
            if (this.value != null) {
                ((SDTPasswordField)elemField).setText(this.value);
            }
        }
        this.storeInputIdent(elemField, new MsgReplyString(this.handle, inputGlyph.size()));
        this.storeInputControl(actButtons, (SDTControl)elemField);
        inputGlyph.addElement(elemField);
        inputMsg.addElement(this.msgElem);
        return elemField;
    }
}

