/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.r3up.adapter;

public class RestrictedBuffer {
    public static final int DefaultCapacity = 50;
    private int capacity;
    private String[] buffer;
    private int writePos;
    private int noOfItems;

    public RestrictedBuffer() {
        this(50);
    }

    public RestrictedBuffer(int capacity) {
        this.capacity = capacity;
        this.buffer = new String[capacity];
        this.writePos = 0;
        this.noOfItems = 0;
    }

    public synchronized void insert(String item) {
        this.buffer[this.writePos] = item;
        this.writePos = (this.writePos + 1) % this.capacity;
        if (this.noOfItems < this.capacity) {
            ++this.noOfItems;
        }
    }

    public synchronized void insert(String[] items) {
        for (int i = 0; i < items.length; ++i) {
            this.buffer[this.writePos] = items[i];
            this.writePos = (this.writePos + 1) % this.capacity;
            if (this.noOfItems >= this.capacity) continue;
            ++this.noOfItems;
        }
    }

    public synchronized String[] getContent() {
        String[] content = new String[this.noOfItems];
        int readPos = this.writePos;
        for (int index = this.noOfItems - 1; index >= 0; --index) {
            if (--readPos < 0) {
                readPos = this.noOfItems - 1;
            }
            content[index] = this.buffer[readPos];
        }
        return content;
    }
}

