/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.r3up.adapter;

import com.sap.sdt.server.ext.r3up.adapter.MsgIdConstants;
import com.sap.sdt.server.ext.r3up.adapter.R3upException;
import com.sap.sdt.server.ext.r3up.adapter.R3upInvalidMsgException;
import com.sap.sdt.server.ext.r3up.adapter.R3upMsgParserConstants;
import com.sap.sdt.server.ext.r3up.adapter.R3upMsgReply;
import com.sap.sdt.server.ext.r3up.adapter.R3upNoSuchElementException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

class R3upMsgTokenizer
implements R3upMsgParserConstants,
MsgIdConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/ext/r3up/adapter/R3upMsgTokenizer.java#2 $";
    private char[] message;
    private char[] curToken;
    private int curPos;
    private int lastPos;

    R3upMsgTokenizer() {
        this.message = null;
        this.curPos = 0;
        this.lastPos = 0;
    }

    R3upMsgTokenizer(char[] message) {
        this.setMessage(message);
    }

    void setMessage(char[] message) {
        this.message = message;
        this.curPos = 0;
        this.lastPos = message.length - 1;
        this.curToken = new char[message.length];
    }

    boolean hasMoreTokens() {
        return this.curPos <= this.lastPos;
    }

    String nextToken() throws R3upInvalidMsgException, R3upNoSuchElementException {
        boolean inToken = false;
        boolean inString = false;
        int readPos = this.curPos;
        int writePos = 0;
        block10: while (readPos <= this.lastPos) {
            char c = this.message[readPos];
            switch (c) {
                case ' ': {
                    if (inString) {
                        this.curToken[writePos] = c;
                        ++readPos;
                        ++writePos;
                        continue block10;
                    }
                    if (inToken) {
                        this.curPos = readPos + 1;
                        return new String(this.curToken, 0, writePos);
                    }
                    ++readPos;
                    continue block10;
                }
                case '{': {
                    if (inToken) {
                        if (inString) {
                            throw new R3upInvalidMsgException("msg.r3up.0008", new String(this.message));
                        }
                        this.curPos = readPos;
                        return new String(this.curToken, 0, writePos);
                    }
                    this.curPos = readPos + 1;
                    return MSG_START_STR;
                }
                case '}': {
                    if (inToken) {
                        if (inString) {
                            throw new R3upInvalidMsgException("msg.r3up.0008", new String(this.message));
                        }
                        this.curPos = readPos;
                        return new String(this.curToken, 0, writePos);
                    }
                    this.curPos = readPos + 1;
                    return MSG_END_STR;
                }
                case '\"': {
                    if (inString) {
                        this.curPos = readPos + 1;
                        return new String(this.curToken, 0, writePos);
                    }
                    if (inToken) {
                        this.curPos = readPos;
                        return new String(this.curToken, 0, writePos);
                    }
                    inString = true;
                    inToken = true;
                    ++readPos;
                    continue block10;
                }
                case '\\': {
                    if (R3upMsgReply.getEscapeMode() == 1) {
                        if (this.message[readPos + 1] == '\"') {
                            this.curToken[writePos] = this.message[readPos + 1];
                            readPos += 2;
                            ++writePos;
                            continue block10;
                        }
                        this.curToken[writePos] = c;
                        ++readPos;
                        ++writePos;
                        continue block10;
                    }
                    switch (this.message[readPos + 1]) {
                        case '\"': 
                        case '\\': 
                        case '{': 
                        case '}': {
                            this.curToken[writePos] = this.message[readPos + 1];
                            readPos += 2;
                            ++writePos;
                            continue block10;
                        }
                    }
                    this.curToken[writePos] = c;
                    ++readPos;
                    ++writePos;
                    continue block10;
                }
            }
            if (!inToken) {
                inToken = true;
            }
            this.curToken[writePos] = c;
            ++readPos;
            ++writePos;
        }
        throw new R3upNoSuchElementException();
    }

    public static void main(String[] args) throws IOException {
        String input;
        System.out.println("MSG_START = '{'");
        System.out.println("MSG_END   = '}'");
        InputStreamReader inStream = new InputStreamReader(System.in);
        BufferedReader reader = new BufferedReader(inStream);
        R3upMsgTokenizer t = new R3upMsgTokenizer();
        while ((input = reader.readLine()) != null) {
            System.out.println(input.length() + ": " + input);
            char[] message = input.toCharArray();
            try {
                t.setMessage(message);
                System.out.println("The tokens:");
                while (t.hasMoreTokens()) {
                    System.out.println(t.nextToken());
                }
            }
            catch (R3upException e) {
                System.out.println("error: " + e.getMessage());
            }
        }
    }
}

