/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.r3up.adapter;

import com.sap.sdt.server.ext.r3up.adapter.R3upMsgElem;
import com.sap.sdt.server.ext.r3up.adapter.R3upMsgParser;
import com.sap.sdt.server.ext.r3up.adapter.R3upMsgParserConstants;

abstract class R3upMsgReply
implements R3upMsgParserConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/ext/r3up/adapter/R3upMsgReply.java#2 $";
    static final int ESCAPE_MODE_1 = 1;
    static final int ESCAPE_MODE_2 = 2;
    static int escapeMode = 2;
    protected static final int INITIAL_REPLY_LENGTH = 256;
    protected int accessIndex;
    private R3upMsgElem checkMsg = null;
    private int checkHandle;
    protected String echoHeader;

    static int getEscapeMode() {
        return escapeMode;
    }

    static void setEscapeMode(int mode) {
        escapeMode = mode;
    }

    R3upMsgReply(R3upMsgElem ref, int id) {
        this.accessIndex = id;
        this.checkMsg = ref;
        this.checkHandle = ref.getHandleVal();
        this.echoHeader = null;
    }

    R3upMsgReply(int handle, int id) {
        this.accessIndex = id;
        this.checkHandle = handle;
        this.echoHeader = null;
    }

    R3upMsgReply(R3upMsgElem ref) {
        this(ref, -1);
    }

    void setId(int id) {
        this.accessIndex = id;
    }

    int getId() {
        return this.accessIndex;
    }

    void setEchoHead(String head) {
        this.echoHeader = head;
    }

    String getEchoHead() {
        return this.echoHeader;
    }

    protected abstract String getReplyString(R3upMsgElem var1, Object var2);

    protected abstract String getEchoMessage(R3upMsgElem var1, Object var2);

    String toReplyString(R3upMsgElem[] indexedElems, Object replyData) {
        if (indexedElems[this.accessIndex].getHandleVal() != this.checkHandle) {
            String text = this.getClass().getName() + ".toReplyString() : ";
            text = text + "\n   R3upMsgElem.getHandleVal () = ";
            text = text + indexedElems[this.accessIndex].getHandleVal();
            text = text + "\n   checkHandle                 = " + this.checkHandle;
            text = text + "\n\n   " + indexedElems[this.accessIndex] + "\n";
            if (this.checkMsg != null) {
                text = text + "\n   CheckMessage:\n";
                text = text + "   " + this.checkMsg + "\n";
            }
            throw new Error();
        }
        return this.getReplyString(indexedElems[this.accessIndex], replyData);
    }

    String toEchoMessage(R3upMsgElem[] indexedElems, Object replyData) {
        if (indexedElems[this.accessIndex].getHandleVal() != this.checkHandle) {
            String text = this.getClass().getName() + ".toEchoMessage() : ";
            text = text + "referenced R3upMsgElem.getHandleVal() != checkHandle";
            throw new Error();
        }
        if (this.echoHeader == null) {
            return this.getEchoMessage(indexedElems[this.accessIndex], replyData);
        }
        return "\n" + this.echoHeader + "\n" + this.getEchoMessage(indexedElems[this.accessIndex], replyData);
    }

    protected String createReply(int refHandle, String value) {
        StringBuffer tmpBuf = new StringBuffer(256);
        tmpBuf.append(" " + R3upMsgParser.getAttrName(7) + " ");
        tmpBuf.append('{');
        tmpBuf.append(R3upMsgParser.getAttrName(1) + " ");
        tmpBuf.append(R3upMsgParser.getAttrName(4) + " ");
        tmpBuf.append(refHandle);
        if (value != null) {
            tmpBuf.append(" " + R3upMsgParser.getAttrName(6) + " ");
            tmpBuf.append(value);
        }
        tmpBuf.append(MSG_END_STR);
        return tmpBuf.toString();
    }

    protected String createEcho(R3upMsgElem elem, String value) {
        String part = "";
        if (value == null) {
            return "";
        }
        String name = elem.getAttrValue(5);
        if (name == null) {
            return part;
        }
        part = part + "> " + name;
        part = elem.echoAllowed() ? part + " " + value : part + " <hidden input>";
        return part;
    }

    protected String getValue(String data) {
        switch (escapeMode) {
            case 1: {
                return this.getValueEscapedV1(data);
            }
            case 2: {
                return this.getValueEscapedV2(data);
            }
        }
        String text = this.getClass().getName() + ".getValue() : ";
        text = text + "unknown escape mode";
        throw new Error();
    }

    protected String getValueEscapedV1(String data) {
        StringBuffer tmpBuf = new StringBuffer(data);
        int curLen = data.length();
        for (int curPos = 0; curPos < curLen; ++curPos) {
            char curChar = tmpBuf.charAt(curPos);
            if (curChar != '\"') continue;
            tmpBuf.insert(curPos, '\\');
            ++curLen;
            ++curPos;
        }
        tmpBuf.insert(0, '\"');
        tmpBuf.append('\"');
        return tmpBuf.toString();
    }

    protected String getValueEscapedV2(String data) {
        StringBuffer tmpBuf = new StringBuffer(data);
        int curLen = data.length();
        block3: for (int curPos = 0; curPos < curLen; ++curPos) {
            switch (tmpBuf.charAt(curPos)) {
                case '\"': 
                case '\\': 
                case '{': 
                case '}': {
                    tmpBuf.insert(curPos, '\\');
                    ++curLen;
                    ++curPos;
                    continue block3;
                }
            }
        }
        tmpBuf.insert(0, '\"');
        tmpBuf.append('\"');
        return tmpBuf.toString();
    }
}

