/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.r3up.adapter;

import com.sap.sdt.server.ext.r3up.adapter.MsgIdConstants;
import com.sap.sdt.server.ext.r3up.adapter.R3upException;
import com.sap.sdt.server.ext.r3up.adapter.R3upInvalidMsgException;
import com.sap.sdt.server.ext.r3up.adapter.R3upMsgElem;
import com.sap.sdt.server.ext.r3up.adapter.R3upMsgParserConstants;
import com.sap.sdt.server.ext.r3up.adapter.R3upMsgTokenizer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

class R3upMsgParser
implements R3upMsgParserConstants,
MsgIdConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/ext/r3up/adapter/R3upMsgParser.java#2 $";
    static String[] attrNames = null;
    static String[] msgNames;
    R3upMsgTokenizer tokenizer = new R3upMsgTokenizer();

    static int getAttrType(String attribute) {
        for (int type = 0; type < 21; ++type) {
            if (!attribute.equals(attrNames[type])) continue;
            return type;
        }
        return -1;
    }

    static String getAttrName(int attrType) {
        if (attrType > -1 && attrType < 21) {
            return attrNames[attrType];
        }
        return "<unknown attribute type>";
    }

    static int getMsgType(String msg) {
        for (int type = 0; type < 20; ++type) {
            if (!msg.equals(msgNames[type])) continue;
            return type;
        }
        return -1;
    }

    static String getMsgName(int msgType) {
        if (msgType > -1 && msgType < 20) {
            return msgNames[msgType];
        }
        return "<unknown message type>";
    }

    R3upMsgParser() {
    }

    R3upMsgElem parse() throws R3upException {
        R3upMsgElem elem = new R3upMsgElem();
        while (this.tokenizer.hasMoreTokens()) {
            String token = this.tokenizer.nextToken();
            if (token.equals(MSG_END_STR)) {
                return elem;
            }
            int attrType = R3upMsgParser.getAttrType(token);
            if (attrType == -1) {
                throw new R3upInvalidMsgException("msg.r3up.0002", token);
            }
            if (!this.tokenizer.hasMoreTokens()) {
                throw new R3upInvalidMsgException("msg.r3up.0003", token);
            }
            token = this.tokenizer.nextToken();
            if (token.equals(MSG_START_STR)) {
                if (attrType == 7) {
                    elem.addParameter(this.parse());
                    continue;
                }
                throw new R3upInvalidMsgException("msg.r3up.0004", token);
            }
            if (attrType == 0) {
                int msgType = R3upMsgParser.getMsgType(token);
                if (msgType == -1) {
                    throw new R3upInvalidMsgException("msg.r3up.0005", token);
                }
                elem.setMsgType(msgType);
            }
            elem.setAttrValue(attrType, token);
        }
        throw new R3upInvalidMsgException("msg.r3up.0006", MSG_END_STR);
    }

    public R3upMsgElem parse(char[] message) throws R3upException {
        this.tokenizer.setMessage(message);
        String token = this.tokenizer.nextToken();
        if (!token.equals(MSG_START_STR)) {
            throw new R3upInvalidMsgException("msg.r3up.0007", Character.toString('{'));
        }
        return this.parse();
    }

    public static void main(String[] args) throws IOException {
        String input;
        R3upMsgParser parser = new R3upMsgParser();
        InputStreamReader inStream = new InputStreamReader(System.in);
        BufferedReader reader = new BufferedReader(inStream);
        while ((input = reader.readLine()) != null) {
            System.out.println(input.length() + ": " + input);
            char[] message = input.toCharArray();
            try {
                System.out.println(parser.parse(message).toString());
            }
            catch (R3upException e) {
                System.out.println("error: " + e.getMessage());
            }
        }
    }

    static {
        attrNames = new String[21];
        R3upMsgParser.attrNames[0] = "TYPE";
        R3upMsgParser.attrNames[1] = "HANDLE";
        R3upMsgParser.attrNames[2] = "TITLE";
        R3upMsgParser.attrNames[3] = "TEXT";
        R3upMsgParser.attrNames[4] = "REFERENCE";
        R3upMsgParser.attrNames[5] = "NAME";
        R3upMsgParser.attrNames[6] = "VALUE";
        R3upMsgParser.attrNames[7] = "PARAMETER";
        R3upMsgParser.attrNames[8] = "HELPTEXT";
        R3upMsgParser.attrNames[9] = "WIZSUMTEXT";
        R3upMsgParser.attrNames[11] = "WIZCOLOR";
        R3upMsgParser.attrNames[10] = "WIZACTSCREEN";
        R3upMsgParser.attrNames[12] = "Mclass";
        R3upMsgParser.attrNames[13] = "Mname";
        R3upMsgParser.attrNames[14] = "Mtime";
        R3upMsgParser.attrNames[15] = "Mearliest";
        R3upMsgParser.attrNames[16] = "Mlatest";
        R3upMsgParser.attrNames[17] = "Mpercentage";
        R3upMsgParser.attrNames[18] = "Mgreen";
        R3upMsgParser.attrNames[19] = "Myellow";
        R3upMsgParser.attrNames[20] = "Mred";
        msgNames = null;
        msgNames = new String[20];
        R3upMsgParser.msgNames[0] = "Information";
        R3upMsgParser.msgNames[1] = "Error";
        R3upMsgParser.msgNames[2] = "Event";
        R3upMsgParser.msgNames[3] = "Help";
        R3upMsgParser.msgNames[4] = "Query";
        R3upMsgParser.msgNames[5] = "Password";
        R3upMsgParser.msgNames[6] = "Decision";
        R3upMsgParser.msgNames[7] = "Question";
        R3upMsgParser.msgNames[8] = "Choice";
        R3upMsgParser.msgNames[9] = "Reply";
        R3upMsgParser.msgNames[10] = "Halt";
        R3upMsgParser.msgNames[11] = "Resume";
        R3upMsgParser.msgNames[12] = "Version";
        R3upMsgParser.msgNames[13] = "ShowFile";
        R3upMsgParser.msgNames[14] = "Wizard";
        R3upMsgParser.msgNames[15] = "Screen";
        R3upMsgParser.msgNames[16] = "ShowNote";
        R3upMsgParser.msgNames[18] = "Status";
        R3upMsgParser.msgNames[19] = "ShowURL";
        R3upMsgParser.msgNames[17] = "PhaseList";
    }
}

