/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.r3up.adapter;

import com.sap.sdt.server.core.controls.SDTPanel;
import com.sap.sdt.server.ext.r3up.adapter.MsgIdConstants;
import com.sap.sdt.server.ext.r3up.adapter.R3upException;
import com.sap.sdt.server.ext.r3up.adapter.R3upInvalidMsgException;
import com.sap.sdt.server.ext.r3up.adapter.R3upMsgParser;
import com.sap.sdt.server.ext.r3up.adapter.R3upMsgParserConstants;
import com.sap.sdt.server.ext.r3up.adapter.WizardMain;
import java.util.Enumeration;
import java.util.Vector;

class R3upMsgElem
implements R3upMsgParserConstants,
MsgIdConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/ext/r3up/adapter/R3upMsgElem.java#2 $";
    public static final int UNKNOWN_VALUE = -1;
    SDTPanel dialog = null;
    WizardMain wizard = null;
    R3upMsgElem[] indexedElems = null;
    int msgType = -1;
    String[] attributes = new String[21];
    Vector parameters = null;
    int handleVal = -1;
    int referenceVal = -1;
    boolean echoAllowed = true;

    public R3upMsgElem() {
        for (int i = 0; i < this.attributes.length; ++i) {
            this.attributes[i] = null;
        }
        this.parameters = new Vector();
    }

    void setMsgType(int msgType) {
        this.msgType = msgType;
    }

    int getMsgType() {
        return this.msgType;
    }

    void setAttrValue(int attrType, String attrVal) throws R3upException {
        if (this.attributes[attrType] != null) {
            throw new R3upInvalidMsgException("msg.r3up.0001", R3upMsgParser.getAttrName(attrType));
        }
        this.attributes[attrType] = attrVal;
        if (attrType == 1) {
            try {
                this.handleVal = Integer.parseInt(attrVal);
            }
            catch (NumberFormatException e) {
                this.handleVal = -1;
            }
        } else if (attrType == 4) {
            try {
                this.referenceVal = Integer.parseInt(attrVal);
            }
            catch (NumberFormatException e) {
                this.referenceVal = -1;
            }
        }
    }

    String getAttrValue(int attrType) {
        return this.attributes[attrType];
    }

    void addParameter(R3upMsgElem elem) {
        this.parameters.addElement(elem);
    }

    Enumeration getParameters() {
        return this.parameters.elements();
    }

    R3upMsgElem getParameter(int handleVal) {
        Enumeration e = this.getParameters();
        while (e.hasMoreElements()) {
            R3upMsgElem param = (R3upMsgElem)e.nextElement();
            if (param.getHandleVal() != handleVal) continue;
            return param;
        }
        return null;
    }

    R3upMsgElem getParameterAt(int index) {
        try {
            R3upMsgElem param = (R3upMsgElem)this.parameters.elementAt(index);
            return param;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    int getNoOfParameters() {
        return this.parameters.size();
    }

    int getHandleVal() {
        return this.handleVal;
    }

    int getReferenceVal() {
        return this.referenceVal;
    }

    boolean containsInput() {
        return this.dialog != null || this.wizard != null;
    }

    void setDialog(SDTPanel dialog) {
        this.dialog = dialog;
    }

    SDTPanel getDialog() {
        return this.dialog;
    }

    void setWizard(WizardMain wizard) {
        this.wizard = wizard;
    }

    WizardMain getWizard() {
        return this.wizard;
    }

    void setIndexedElems(R3upMsgElem[] inxElems) {
        this.indexedElems = inxElems;
    }

    R3upMsgElem[] getIndexedElems() {
        return this.indexedElems;
    }

    void setEcho(boolean allowEcho) {
        this.echoAllowed = allowEcho;
    }

    boolean echoAllowed() {
        return this.echoAllowed;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        this.toString(text, "  ");
        return text.append("\n").toString();
    }

    void toString(StringBuffer text, String indent) {
        text.append("Message type: " + R3upMsgParser.getMsgName(this.msgType));
        for (int i = 0; i < this.attributes.length; ++i) {
            if (this.attributes[i] == null) continue;
            text.append(indent + R3upMsgParser.getAttrName(i) + " = " + this.attributes[i]);
        }
        String nextIndent = indent + indent;
        Enumeration e = this.getParameters();
        while (e.hasMoreElements()) {
            ((R3upMsgElem)e.nextElement()).toString(text, nextIndent);
            text.append("\n");
        }
    }
}

