/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.r3up.adapter;

import com.sap.sdt.server.ext.r3up.adapter.Debug;
import com.sap.sdt.server.ext.r3up.adapter.Env;
import com.sap.sdt.server.ext.r3up.adapter.SvrLog;
import java.io.File;
import java.util.StringTokenizer;

public class R3upEnv
extends Env {
    public static String uaArchive = "ua.jar";
    public static String uaGuiArchive = "uagui.jar";
    private static String r3upName = "R3up";
    private static final String r3upLogName = "R3up.log";
    private static final String r3upStopName = "R3UPPHAS.BRK";
    private static String classPath;
    private static String tmpDir;
    private static String upgDir;
    private static String upgBinDir;
    private static String upgLogDir;
    private static String upgUaDir;
    private static String upgUaProsaSrcDir;
    private static String r3upPath;
    private static String r3upLogPath;
    private static String r3upStopPath;
    private static String userHome;
    private static boolean isNT;

    public static void setUaArchiveName(String uaArchiveName) {
        uaArchive = uaArchiveName;
    }

    public static String getUaArchiveName() {
        return uaArchive;
    }

    public static void setUaGuiArchiveName(String uaGuiArchiveName) {
        uaGuiArchive = uaGuiArchiveName;
    }

    public static String getUaGuiArchiveName() {
        return uaGuiArchive;
    }

    public R3upEnv() {
        this(null, null);
    }

    public R3upEnv(String upgDir) {
        this(upgDir, null);
    }

    public R3upEnv(String upgDir, String tmpDir) {
        if (upgDir == null) {
            R3upEnv.setUpgradeDir(this.findUpgDir());
        } else {
            R3upEnv.setUpgradeDir(upgDir);
        }
        R3upEnv.setTmpDir(tmpDir);
    }

    public String findUpgDir() {
        classPath = System.getProperty("java.class.path");
        if (classPath == null) {
            return null;
        }
        StringTokenizer sT = new StringTokenizer(classPath, File.pathSeparator);
        while (sT.hasMoreTokens()) {
            String token = sT.nextToken();
            if (!token.endsWith(uaArchive)) continue;
            String path = new File(token).getAbsolutePath();
            Debug.print(17, "R3upEnv.findUpgDir (" + path + ")");
            path = new File(path).getParent();
            if (path == null) continue;
            Debug.print(17, "R3upEnv.findUpgDir (" + path + ")");
            path = new File(path).getParent();
            if (path == null) continue;
            Debug.print(17, "R3upEnv.findUpgDir (" + path + ")");
            File tmpUpgDir = new File(path);
            if (tmpUpgDir == null || !tmpUpgDir.exists() || !tmpUpgDir.isDirectory() || !tmpUpgDir.canRead() || !tmpUpgDir.canWrite()) continue;
            return tmpUpgDir.getAbsolutePath();
        }
        return null;
    }

    public static String getClassPath() {
        return classPath;
    }

    public static String getTmpDir() {
        return tmpDir;
    }

    public static String getUpgDir() {
        return upgDir;
    }

    public static String getUpgBinDir() {
        if (upgBinDir == null) {
            R3upEnv.updateUpgBinDir();
        }
        return upgBinDir;
    }

    public static String getUpgLogDir() {
        if (upgLogDir == null) {
            R3upEnv.updateUpgLogDir();
        }
        return upgLogDir;
    }

    public static String getUpgUaDir() {
        if (upgUaDir == null) {
            R3upEnv.updateUpgUaDir();
        }
        return upgUaDir;
    }

    public static String getUpgUaProsaSrcDir() {
        if (upgUaProsaSrcDir == null) {
            R3upEnv.updateUpgUaProsaSrcDir();
        }
        return upgUaProsaSrcDir;
    }

    public static String getR3upPath() {
        if (r3upPath == null) {
            R3upEnv.updateR3upPath();
        }
        return r3upPath;
    }

    public static String getR3upLogPath() {
        if (r3upLogPath == null) {
            R3upEnv.updateR3upLogPath();
        }
        return r3upLogPath;
    }

    public static String getR3upStopPath() {
        if (r3upStopPath == null) {
            R3upEnv.updateR3upStopPath();
        }
        return r3upStopPath;
    }

    public static void updateUpgBinDir() {
        upgBinDir = R3upEnv.concatPath(upgDir, "bin");
        if (R3upEnv.checkDir(upgBinDir) != null) {
            upgBinDir = null;
        }
    }

    static void updateUpgLogDir() {
        upgLogDir = R3upEnv.concatPath(upgDir, "log");
        if (R3upEnv.checkDir(upgLogDir) != null) {
            upgLogDir = null;
        }
    }

    static void updateUpgUaDir() {
        upgUaDir = R3upEnv.concatPath(upgDir, "ua");
        if (R3upEnv.checkDir(upgUaDir) != null) {
            upgUaDir = null;
        }
    }

    static void updateUpgUaProsaSrcDir() {
        upgUaProsaSrcDir = R3upEnv.concatPath(upgUaDir, "prosa");
        if (R3upEnv.checkDir(upgUaProsaSrcDir) != null) {
            upgUaProsaSrcDir = null;
        }
    }

    static void updateR3upPath() {
        r3upPath = R3upEnv.concatPath(upgDir, isNT ? "exe" : "bin");
        if (R3upEnv.checkFile(r3upPath = R3upEnv.concatPath(r3upPath, r3upName)) != null) {
            r3upPath = null;
        }
    }

    static void updateR3upLogPath() {
        r3upLogPath = R3upEnv.concatPath(upgLogDir, r3upLogName);
    }

    static void updateR3upStopPath() {
        r3upStopPath = R3upEnv.concatPath(upgBinDir, r3upStopName);
    }

    public static void setTmpDir(String newTmpDir) {
        tmpDir = R3upEnv.checkDir(newTmpDir) == null ? newTmpDir : R3upEnv.getUpgUaDir();
        if (tmpDir == null) {
            return;
        }
        SvrLog.stdout("Temporary directory is '" + R3upEnv.getTmpDir() + "'");
    }

    public static void setUpgradeDir(String newUpgDir) {
        if (newUpgDir == null) {
            return;
        }
        if (R3upEnv.checkDir(newUpgDir) != null) {
            return;
        }
        upgDir = newUpgDir;
        R3upEnv.updatePathes();
    }

    private static void updatePathes() {
        R3upEnv.updateUpgBinDir();
        R3upEnv.updateUpgLogDir();
        R3upEnv.updateUpgUaDir();
        R3upEnv.updateUpgUaProsaSrcDir();
        R3upEnv.updateR3upPath();
        R3upEnv.updateR3upLogPath();
        R3upEnv.updateR3upStopPath();
    }

    public void print() {
        System.out.println("Directories:");
        System.out.println(" - java classpath      " + classPath);
        System.out.println(" - tmpDir              " + R3upEnv.getTmpDir());
        System.out.println(" - upgDir              " + R3upEnv.getUpgDir());
        System.out.println(" - upgBinDir           " + R3upEnv.getUpgBinDir());
        System.out.println(" - upgLogDir           " + R3upEnv.getUpgLogDir());
        System.out.println(" - upgUpgUaDir         " + R3upEnv.getUpgUaDir());
        System.out.println(" - upgUpgUaProsaSrcDir " + R3upEnv.getUpgUaProsaSrcDir());
        System.out.println(" - r3upPath            " + R3upEnv.getR3upPath());
        System.out.println(" - r3upLogPath         " + R3upEnv.getR3upLogPath());
        System.out.println(" - r3upStopPath        " + R3upEnv.getR3upStopPath());
    }

    public static void main(String[] args) {
        R3upEnv env = null;
        if (args.length == 0) {
            env = new R3upEnv();
        } else if (args.length == 1) {
            env = new R3upEnv(args[0]);
        } else if (args.length > 2) {
            env = new R3upEnv(args[0], args[1]);
        }
        env.print();
    }

    static {
        tmpDir = null;
        upgDir = null;
        upgBinDir = null;
        upgLogDir = null;
        upgUaDir = null;
        r3upPath = null;
        r3upLogPath = null;
        sep = File.separator;
        if (File.separatorChar == '\\') {
            isNT = true;
            r3upName = r3upName + ".exe";
        } else if (File.separatorChar == '/') {
            isNT = false;
        }
    }
}

