/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.r3up.adapter;

import com.sap.sdt.server.core.util.Dater;
import com.sap.sdt.server.ext.r3up.adapter.KeyConstants;
import com.sap.sdt.server.ext.r3up.adapter.R3upAdapter;
import com.sap.sdt.server.ext.r3up.adapter.RestrictedBuffer;
import java.io.PrintWriter;

public class R3upEcho
implements KeyConstants {
    private static final int MAX_ECHO_LINES = 32;
    private R3upAdapter adapter;
    private RestrictedBuffer echoBuffer = null;
    private String statusPrefix = "";
    private String statusLine = "";
    private String waitString = null;
    private PrintWriter logFile = null;

    public R3upEcho(R3upAdapter adapter) {
        this.adapter = adapter;
        this.waitString = adapter.getTextAdmin().get("WAITING_SINCE") + " ";
        this.echoBuffer = new RestrictedBuffer(32);
    }

    private void writeLog(String line) {
    }

    void echoLine(String line) {
        this.echoBuffer.insert(line);
        String echo = "";
        String[] lines = this.echoBuffer.getContent();
        for (int i = 0; i < lines.length; ++i) {
            echo = echo + lines[i] + "\n";
        }
        this.adapter.appendEchoArea(echo);
        this.writeLog(line);
    }

    void echoWaitMessage(String prefix) {
        String line = "\n";
        line = line + (prefix != null ? prefix : this.waitString);
        line = line + Dater.getDateTime();
        line = line + "\n";
        this.echoLine(line);
    }

    void echoStatusLine(String text) {
        this.statusLine = text;
        this.adapter.setStatusLine(this.statusPrefix + this.statusLine);
    }

    void echoStatusLinePrefix(String prefix) {
        this.statusPrefix = prefix;
        this.adapter.setStatusLine(this.statusPrefix + this.statusLine);
    }
}

