/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.r3up.adapter;

import com.sap.sdt.engine.core.controls.SDTConstants;
import com.sap.sdt.engine.core.services.tool.ToolInfo;
import com.sap.sdt.engine.core.services.tool.ToolServiceIF;
import com.sap.sdt.server.core.controls.SDTButton;
import com.sap.sdt.server.core.controls.SDTCheckBox;
import com.sap.sdt.server.core.controls.SDTControl;
import com.sap.sdt.server.core.controls.SDTPasswordField;
import com.sap.sdt.server.core.controls.SDTRadioButton;
import com.sap.sdt.server.core.controls.SDTStyledText;
import com.sap.sdt.server.core.controls.SDTTextField;
import com.sap.sdt.server.core.controls.SDTView;
import com.sap.sdt.server.core.services.tool.AbstractToolAdapter;
import com.sap.sdt.server.core.services.tool.views.SDTNetWeaverView;
import com.sap.sdt.server.ext.r3up.adapter.Debug;
import com.sap.sdt.server.ext.r3up.adapter.KeyConstants;
import com.sap.sdt.server.ext.r3up.adapter.MsgReply;
import com.sap.sdt.server.ext.r3up.adapter.R3upCommLink;
import com.sap.sdt.server.ext.r3up.adapter.R3upEcho;
import com.sap.sdt.server.ext.r3up.adapter.R3upException;
import com.sap.sdt.server.ext.r3up.adapter.R3upMsgElem;
import com.sap.sdt.server.ext.r3up.adapter.R3upMsgParser;
import com.sap.sdt.server.ext.r3up.adapter.R3upMsgProcessor;
import com.sap.sdt.server.ext.r3up.adapter.R3upMsgProcessorIF;
import com.sap.sdt.server.ext.r3up.adapter.WizardMsgProcessor;
import com.sap.sdt.server.ext.r3up.resources.PropertyAdmin;
import com.sap.sdt.server.ext.r3up.resources.TextAdmin;
import com.sap.sdt.util.net.CommLinkIF;
import com.sap.sdt.util.net.NetworkException;
import com.sap.sdt.util.vers.VersionFactory;
import com.sap.sdt.util.vers.VersionIF;
import com.sap.sdt.util.vers.VersionNotComparableException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class R3upAdapter
extends AbstractToolAdapter
implements KeyConstants,
SDTConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/ext/r3up/adapter/R3upAdapter.java#2 $";
    private static final VersionIF protVers = VersionFactory.createVersion("1.7");
    private static final VersionIF escVers = VersionFactory.createVersion("1.6");
    private static final int DEFAULT_PORT = 4240;
    private R3upMsgParser parser = null;
    private R3upMsgProcessorIF processor = null;
    private PropertyAdmin pA = null;
    private TextAdmin tA = null;
    private R3upEcho echo = null;
    private SDTStyledText echoPanel = null;
    private String echoText = "";
    private Map controlMap = null;
    private Map identMap = null;

    public R3upAdapter(ToolServiceIF service, ToolInfo info) {
        super(service, info);
        this.startPropertyAdmin();
        this.startTextAdmin();
        this.parser = new R3upMsgParser();
        this.processor = "on".equalsIgnoreCase(this.pA.get("UA_WIZARD_USE_DIALOGS")) ? new R3upMsgProcessor(this) : new WizardMsgProcessor(this);
        this.controlMap = new HashMap();
        this.identMap = new HashMap();
        this.echo = new R3upEcho(this);
        this.createEchoPanel();
        this.echo.echoStatusLinePrefix(this.tA.get("R3UP_NOTCONNECTED"));
        this.echo.echoStatusLine("");
    }

    public void networkError(NetworkException nwE) {
        System.out.println("networkError()");
        nwE.printStackTrace();
        System.exit(1);
    }

    public void commLinkClosed() {
        System.out.println("commLinkClosed()");
        System.exit(1);
    }

    protected void handshake() {
    }

    protected CommLinkIF createCommLink() {
        return new R3upCommLink();
    }

    protected int getDefaultPort() {
        return 4240;
    }

    protected void handleMsg(String msg) {
        this.tracer.debug(this.getClass(), "Received: {0}", msg);
        try {
            R3upMsgElem elem = this.parser.parse(msg.toCharArray());
            this.processor.processMsg(elem);
        }
        catch (R3upException e) {
            e.printStackTrace();
        }
    }

    protected SDTView createToolView() {
        SDTNetWeaverView dialog = new SDTNetWeaverView();
        dialog.setGuiTitle("Upgrade Assistant");
        return dialog;
    }

    void checkVersion(String versionString) {
        Object version = null;
        Debug.print(17, "R3upAdmin.checkVersion (UaServer: " + protVers + ", R3up: " + versionString + ")");
        try {
            int compResult;
            int index = versionString.lastIndexOf(" ");
            String prefix = versionString.substring(0, index);
            String versNo = versionString.substring(index + 1);
            version = VersionFactory.createVersion(versNo);
            if (escVers.compare((VersionIF)version) >= 0) {
                MsgReply.setEscapeMode(1);
            }
            if ((compResult = protVers.compare((VersionIF)version)) == 0 || compResult >= 2) {
                this.echo.echoStatusLinePrefix(this.tA.get("R3UP_CONNECTED"));
                return;
            }
        }
        catch (StringIndexOutOfBoundsException e) {
        }
        catch (VersionNotComparableException e) {
            e.printStackTrace();
        }
        String[] params = new String[]{((Object)protVers).toString(), version.toString()};
        this.echo.echoStatusLinePrefix(this.tA.get("R3UP_NOTCONNECTED"));
        this.echo.echoStatusLine("");
        this.echo.echoLine("\n" + this.tA.get("R3UP_UAS_WRONG_VERS", params));
    }

    public PropertyAdmin getPropertyAdmin() {
        return this.pA;
    }

    public TextAdmin getTextAdmin() {
        return this.tA;
    }

    SDTControl getEchoPanel() {
        return this.echoPanel;
    }

    R3upEcho getEcho() {
        return this.echo;
    }

    void storeInputControl(SDTButton button, SDTControl control) {
        if (!this.controlMap.containsKey(button)) {
            this.controlMap.put(button, new Vector());
        }
        ((Vector)this.controlMap.get(button)).add(control);
    }

    void storeInputIdent(SDTControl control, Object ident) {
        this.identMap.put(control, ident);
    }

    Vector getInputControls(SDTControl source) {
        return (Vector)this.controlMap.get(source);
    }

    Object getInputIdent(SDTControl control) {
        return this.identMap.get(control);
    }

    Object getInputData(SDTControl control) {
        Object data = null;
        switch (control.getType()) {
            case 7: {
                data = ((SDTTextField)control).getText();
                break;
            }
            case 8: {
                data = ((SDTPasswordField)control).getText();
                break;
            }
            case 11: {
                data = new Boolean(((SDTCheckBox)control).isSelected());
                break;
            }
            case 10: {
                data = new Boolean(((SDTRadioButton)control).isSelected());
                break;
            }
            case 9: {
                data = new Boolean(true);
                break;
            }
        }
        return data;
    }

    void clear() {
        this.controlMap.clear();
        this.identMap.clear();
    }

    void appendEchoArea(String line) {
        this.echoPanel.setText(line);
    }

    void setStatusLine(String status) {
        this.getToolView().setStatus(status);
    }

    private void startPropertyAdmin() {
        this.pA = new PropertyAdmin();
        InputStream props = this.pA.getClass().getResourceAsStream("UaServer.properties");
        try {
            this.pA.load(props);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void startTextAdmin() {
        this.tA = new TextAdmin();
        InputStream text = this.tA.getClass().getResourceAsStream("UaTextE.properties");
        try {
            this.tA.load(text);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private void createEchoPanel() {
        this.echoPanel = new SDTStyledText(true);
    }
}

