/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.r3up.adapter;

import com.sap.sdt.engine.core.event.SDTActionEvent;
import com.sap.sdt.server.core.controls.SDTActionListener;
import com.sap.sdt.server.core.controls.SDTControl;
import com.sap.sdt.server.core.services.AdapterException;
import com.sap.sdt.server.ext.r3up.adapter.Debug;
import com.sap.sdt.server.ext.r3up.adapter.DebugConstants;
import com.sap.sdt.server.ext.r3up.adapter.EventAdmin;
import com.sap.sdt.server.ext.r3up.adapter.EventObserver;
import com.sap.sdt.server.ext.r3up.adapter.KeyConstants;
import com.sap.sdt.server.ext.r3up.adapter.MsgProcessorConstants;
import com.sap.sdt.server.ext.r3up.adapter.MsgReply;
import com.sap.sdt.server.ext.r3up.adapter.R3upAdapter;
import com.sap.sdt.server.ext.r3up.adapter.R3upMsgElem;
import com.sap.sdt.server.ext.r3up.adapter.R3upMsgParser;
import com.sap.sdt.server.ext.r3up.adapter.R3upMsgParserConstants;
import com.sap.sdt.server.ext.r3up.adapter.R3upMsgProcessorIF;
import com.sap.sdt.server.ext.r3up.adapter.ServerError;
import com.sap.sdt.server.ext.r3up.adapter.ServerInternalError;
import com.sap.sdt.server.ext.r3up.adapter.SvrLog;
import com.sap.sdt.server.ext.r3up.adapter.UpgInputObserver;
import com.sap.sdt.server.ext.r3up.resources.TextAdmin;
import java.util.Enumeration;
import java.util.Vector;

abstract class MsgProcessor
extends SDTActionListener
implements R3upMsgProcessorIF,
EventObserver,
DebugConstants,
KeyConstants,
MsgProcessorConstants,
R3upMsgParserConstants {
    private static final int INITIAL_REPLY_LENGTH = 256;
    private static int handleCounter = 1;
    protected TextAdmin tA;
    protected EventAdmin eA;
    protected R3upMsgParser parser;
    protected String curPhaseName;
    protected R3upMsgElem helpMsg;
    protected R3upAdapter adapter;
    private Object sync = new Object();
    private volatile R3upMsgElem currentMsg;
    private volatile R3upMsgElem lastMsg = null;
    private Vector listUpgInputObservers = new Vector();

    static synchronized int getHandle() {
        return handleCounter++;
    }

    public void actionPerformed(SDTActionEvent event) {
        this.adapter.getToolView().updateControl();
        SDTControl source = (SDTControl)event.getSource();
        Vector controls = this.adapter.getInputControls(source);
        Object[] elems = new Object[controls.size()];
        Object[] data = new Object[controls.size()];
        for (int i = 0; i < elems.length; ++i) {
            SDTControl control = (SDTControl)controls.get(i);
            elems[i] = this.adapter.getInputIdent(control);
            data[i] = this.adapter.getInputData(control);
        }
        this.process(new Integer(-1), elems, data);
    }

    abstract void doWizard(R3upMsgElem var1);

    abstract void showInput(R3upMsgElem var1);

    abstract void closeInput(R3upMsgElem var1, boolean var2);

    MsgProcessor(R3upAdapter adapter) {
        this.adapter = adapter;
        this.tA = adapter.getTextAdmin();
        this.eA = new EventAdmin();
        this.eA.addEventObserver(this);
        this.parser = new R3upMsgParser();
        this.helpMsg = null;
    }

    protected R3upMsgElem getCurrentMsg() {
        return this.currentMsg;
    }

    protected R3upMsgElem getLastMsg() {
        return this.lastMsg;
    }

    protected void setCurrentMsg(R3upMsgElem msg) {
        this.lastMsg = this.currentMsg;
        this.currentMsg = msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closedLink() {
        Object object = this.sync;
        synchronized (object) {
            this.closeInput(this.currentMsg, false);
            if (this.currentMsg != null && this.currentMsg.containsInput()) {
                this.sync.notify();
            }
            this.setCurrentMsg(null);
            this.helpMsg = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMsg(R3upMsgElem msg) {
        switch (msg.getMsgType()) {
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 15: {
                this.doWizard(msg);
                break;
            }
            case 0: {
                this.doInformation(msg);
                break;
            }
            case 3: {
                this.helpMsg = msg;
                break;
            }
            case 2: {
                this.doEvent(msg);
                break;
            }
            case 12: {
                this.doVersion(msg);
                break;
            }
            case 13: {
                break;
            }
            case 16: {
                break;
            }
            case 19: {
                break;
            }
            case 17: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        this.setCurrentMsg(msg);
        if (!this.getCurrentMsg().containsInput()) {
            return;
        }
        Object object = this.sync;
        synchronized (object) {
            String echoMsg = this.generateEchoMessage(this.getCurrentMsg());
            this.showInput(this.getCurrentMsg());
            this.adapter.getEcho().echoLine("\n" + echoMsg);
            this.adapter.getEcho().echoWaitMessage(null);
            this.notifyUpgInputStart(this.curPhaseName, echoMsg);
            Debug.print(35, "MsgProcessor.process (): ()");
            try {
                this.sync.wait();
            }
            catch (InterruptedException e) {
                throw new Error();
            }
        }
    }

    void doVersion(R3upMsgElem msg) {
        String vers = msg.getAttrValue(3);
        Debug.print(17, "MsgProcessor.doVersion (" + vers + ")");
        this.adapter.checkVersion(vers);
    }

    void doEvent(R3upMsgElem msg) {
        String eventName = msg.getAttrValue(5);
        String eventValue = msg.getAttrValue(6);
        Debug.print(17, "MsgProcessor.doEvent (" + eventName + " = " + eventValue + ")");
        this.eA.updateEventObservers(eventName, eventValue);
    }

    void doInformation(R3upMsgElem msg) {
        Debug.print(17, "MsgProcessor.doInformation ()");
        String text = msg.getAttrValue(3);
        if (text == null) {
            throw new ServerInternalError("Empty text");
        }
        this.adapter.appendEchoArea("\n" + text);
    }

    char[] generateReply(R3upMsgElem msg, Object[] elems, Object[] data) {
        switch (msg.getMsgType()) {
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 15: {
                break;
            }
            default: {
                return null;
            }
        }
        StringBuffer tmpBuf = new StringBuffer(256);
        R3upMsgElem[] indexedElems = msg.getIndexedElems();
        if (indexedElems.length < elems.length) {
            throw new ServerInternalError("error in generateReply(): Wrong number of message elements in index");
        }
        tmpBuf.append(MSG_START_STR);
        tmpBuf.append(R3upMsgParser.getAttrName(1) + " ");
        tmpBuf.append(MsgProcessor.getHandle() + " ");
        tmpBuf.append(R3upMsgParser.getAttrName(0) + " ");
        tmpBuf.append(R3upMsgParser.getMsgName(9) + " ");
        tmpBuf.append(R3upMsgParser.getAttrName(4) + " ");
        tmpBuf.append(msg.getHandleVal());
        for (int index = 0; index < elems.length; ++index) {
            if (!(elems[index] instanceof MsgReply)) {
                throw new ServerError("invalid message: " + elems[index]);
            }
            MsgReply reply = (MsgReply)elems[index];
            tmpBuf.append(reply.toReplyString(indexedElems, data[index]));
        }
        tmpBuf.append(MSG_END_STR);
        int tmpLen = tmpBuf.length();
        char[] tmpChars = new char[tmpLen];
        tmpBuf.getChars(0, tmpLen, tmpChars, 0);
        return tmpChars;
    }

    String generateEchoMessage(R3upMsgElem msg) {
        String line = "";
        if (msg.getMsgType() == 14 || msg.getMsgType() == 15) {
            if (msg.getMsgType() == 14) {
                line = line + "  >>>>>>>>>> Input Wizard <<<<<<<<<<\n";
            }
            Enumeration f = msg.getParameters();
            while (f.hasMoreElements()) {
                line = line + this.generateEchoMessage((R3upMsgElem)f.nextElement());
            }
        } else {
            String title = msg.getAttrValue(2);
            String text = msg.getAttrValue(3);
            line = line + "\n";
            if (title != null) {
                line = line + title + "\n";
            }
            if (text != null) {
                line = line + text + "\n";
            }
            Enumeration e = msg.getParameters();
            while (e.hasMoreElements()) {
                R3upMsgElem param = (R3upMsgElem)e.nextElement();
                String name = param.getAttrValue(5);
                if (name == null) continue;
                line = line + "? " + name + "\n";
            }
        }
        return line;
    }

    String generateEchoMessage(R3upMsgElem msg, Object[] elems, Object[] data) {
        R3upMsgElem[] indexedElems = msg.getIndexedElems();
        if (indexedElems.length < elems.length) {
            throw new ServerInternalError(this.getClass().getName() + ".generateEchoMessage (): " + "Wrong number of message elements in index");
        }
        String line = "\n";
        String title = msg.getAttrValue(2);
        String text = msg.getAttrValue(3);
        if (title != null) {
            line = line + title + "\n";
        }
        if (text != null) {
            line = line + text + "\n";
        }
        for (int index = 0; index < elems.length; ++index) {
            if (!(elems[index] instanceof MsgReply)) {
                throw new ServerError(this.getClass().getName() + ".generateEchoMessage(): " + "invalid message: " + elems[index]);
            }
            MsgReply reply = (MsgReply)elems[index];
            String echo = reply.toEchoMessage(indexedElems, data[index]);
            if (echo.length() == 0) continue;
            line = line + echo + "\n";
        }
        return line;
    }

    void setHelpMsg(R3upMsgElem msg) {
        this.helpMsg = msg;
    }

    R3upMsgElem getHelpMsg() {
        return this.helpMsg;
    }

    public void process(int event, String eventVal) {
        switch (event) {
            case 0: {
                this.curPhaseName = this.tA.get("CUR_UPG_PHASE") + ": " + eventVal;
                this.adapter.getEcho().echoStatusLine(this.curPhaseName);
                break;
            }
            case 1: {
                this.curPhaseName = this.tA.get("CUR_UPG_PHASE") + ": <>";
                this.adapter.getEcho().echoStatusLine(this.curPhaseName);
                break;
            }
            case 2: {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Object id, Object[] elems, Object[] data) {
        int value = (Integer)id;
        if (value == -109) {
            this.closeInput(this.getCurrentMsg(), false);
            return;
        }
        if (value == -110) {
            return;
        }
        if (value == -111) {
            if (elems.length <= 0 || !(elems[0] instanceof R3upMsgElem)) {
                return;
            }
            return;
        }
        Object object = this.sync;
        synchronized (object) {
            if (this.getCurrentMsg() == null) {
                String text = "Invalid reply from " + id + "\n";
                for (int i = 0; i < elems.length; ++i) {
                    text = text + "  " + i + ": " + elems[i];
                    text = text + " = " + data[i] + "\n";
                }
                SvrLog.err(text + "\n");
                if (this.getLastMsg() != null) {
                    SvrLog.err("The last message was:\n - " + this.getLastMsg() + "\n");
                } else {
                    SvrLog.err("The last message was empty.\n");
                }
                return;
            }
            this.closeInput(this.getCurrentMsg(), true);
            try {
                char[] reply = this.generateReply(this.getCurrentMsg(), elems, data);
                this.adapter.getEcho().echoLine("\n" + this.generateEchoMessage(this.getCurrentMsg(), elems, data));
                this.adapter.send(new String(reply));
                this.setCurrentMsg(null);
            }
            catch (ServerError e) {
                SvrLog.err(e.getMessage());
                return;
            }
            catch (AdapterException e) {
                e.printStackTrace();
            }
            this.notifyUpgInputStop();
            Debug.print(35, "MsgProcessor.process (): sync.notify ()");
            this.sync.notify();
        }
    }

    public void addUpgInputObserver(UpgInputObserver observer) {
        this.listUpgInputObservers.addElement(observer);
    }

    public void removeUpgInputObserver(UpgInputObserver observer) {
        this.listUpgInputObservers.removeElement(observer);
    }

    private void notifyUpgInputStart(String title, String text) {
        Enumeration e = this.listUpgInputObservers.elements();
        while (e.hasMoreElements()) {
            ((UpgInputObserver)e.nextElement()).start(title, text);
        }
    }

    private void notifyUpgInputStop() {
        Enumeration e = this.listUpgInputObservers.elements();
        while (e.hasMoreElements()) {
            ((UpgInputObserver)e.nextElement()).stop();
        }
    }
}

