/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.navigator.controls;

import com.sap.sdt.engine.core.admin.ServerAdminIF;
import com.sap.sdt.engine.core.admin.ServerID;
import com.sap.sdt.engine.core.communication.Configuration;
import com.sap.sdt.engine.core.controls.SDTControlFactoryIF;
import com.sap.sdt.engine.core.controls.SDTViewIF;
import com.sap.sdt.engine.core.services.tool.ToolAdapterInfo;
import com.sap.sdt.engine.core.services.tool.ToolID;
import com.sap.sdt.engine.core.services.tool.ToolInfo;
import com.sap.sdt.engine.ext.navigator.NavigatorServiceIF;
import com.sap.sdt.engine.ext.navigator.controls.SDTNavigatorPerspectiveIF;
import com.sap.sdt.server.core.controls.SDTPerspective;
import com.sap.sdt.server.core.controls.SDTView;
import com.sap.sdt.server.ext.navigator.controls.SDTConnectionsView;
import com.sap.sdt.server.ext.navigator.controls.SDTNavigationView;
import com.sap.sdt.server.ext.navigator.controls.SDTToolView;

public class SDTNavigatorPerspective
extends SDTPerspective {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/ext/navigator/controls/SDTNavigatorPerspective.java#2 $";
    private NavigatorServiceIF toolService = null;

    public SDTNavigatorPerspective() {
        SDTNavigationView navigationView = new SDTNavigationView();
        this.addView(navigationView);
        SDTConnectionsView connectionsView = new SDTConnectionsView();
        this.addView(connectionsView);
        this.addView(new SDTToolView());
    }

    public void setToolService(NavigatorServiceIF toolService) {
        this.toolService = toolService;
    }

    public void addServer(ServerID server, String host, int port) {
        this.delegate().addServer(server, host, port);
    }

    public void addAdapterType(ServerID server, ToolAdapterInfo adapter) {
        this.delegate().addAdapterType(server, adapter);
    }

    public void addToolInstance(ServerID server, ToolInfo tool) {
        this.delegate().addToolInstance(server, tool);
    }

    public void removeToolInstance(ServerID server, ToolID tool) {
        this.delegate().removeToolInstance(server, tool);
    }

    public void connectToolInstance(ServerID server, ToolInfo tool) {
        this.delegate().connectToolInstance(server, tool);
    }

    public void disconnectToolInstance(ServerID server, ToolID tool) {
        this.delegate().disconnectToolInstance(server, tool);
    }

    public void setToolView(SDTView toolView) {
        this.delegate().setToolView((SDTViewIF)toolView.getDelegate());
    }

    public void resetToolView() {
        this.delegate().resetToolView();
    }

    protected void createDelegate() {
        SDTControlFactoryIF factory = Configuration.getControlFactory();
        this.delegate = factory.createNavigatorPerspective();
        super.createDelegate();
        ServerAdminIF admin = Configuration.getServerAdmin();
        this.addServer(admin.getID(), "localhost", 4711);
        ToolAdapterInfo[] adapters = this.toolService.getAdapterTypes();
        for (int i = 0; i < adapters.length; ++i) {
            this.addAdapterType(admin.getID(), adapters[i]);
        }
    }

    private final SDTNavigatorPerspectiveIF delegate() {
        return (SDTNavigatorPerspectiveIF)this.delegate;
    }
}

