/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.navigator;

import com.sap.sdt.engine.core.admin.ClientID;
import com.sap.sdt.engine.core.admin.SDTGuiAdminIF;
import com.sap.sdt.engine.core.admin.ServerAdminIF;
import com.sap.sdt.engine.core.communication.ClientConnection;
import com.sap.sdt.engine.core.communication.Configuration;
import com.sap.sdt.engine.core.services.tool.ToolAdapterInfo;
import com.sap.sdt.engine.core.services.tool.ToolID;
import com.sap.sdt.engine.core.services.tool.ToolInfo;
import com.sap.sdt.engine.ext.navigator.NavigatorServiceIF;
import com.sap.sdt.server.core.controls.SDTPerspective;
import com.sap.sdt.server.core.services.AbstractGuiService;
import com.sap.sdt.server.core.services.AdapterException;
import com.sap.sdt.server.core.services.tool.AdapterFactory;
import com.sap.sdt.server.core.services.tool.ToolAdapterIF;
import com.sap.sdt.server.ext.navigator.MulticastCmdConsumer;
import com.sap.sdt.server.ext.navigator.controls.SDTNavigatorPerspective;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class NavigatorService
extends AbstractGuiService
implements NavigatorServiceIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/ext/navigator/NavigatorService.java#2 $";
    private ServerAdminIF serverAdmin = Configuration.getServerAdmin();
    private Vector adapterTypes = new Vector();
    private Map tools = new HashMap();
    private Map clients = new HashMap();
    private boolean isWaitingForExit = false;

    public NavigatorService() {
        super("NavigatorService");
    }

    public void configure(XMLElementIF configuration) {
        Iterator it = configuration.getSubElements();
        while (it.hasNext()) {
            XMLElementIF entry = (XMLElementIF)it.next();
            try {
                String aN = entry.getAttrString("name");
                String cN = entry.getElement("AdapterClass").getContent();
                String eN = entry.getElement("ExecutableName").getContent();
                int dP = Integer.parseInt(entry.getElement("DefaultPort").getContent());
                this.adapterTypes.add(new ToolAdapterInfo(cN, aN, eN, dP));
            }
            catch (XMLException xmlE) {
                xmlE.printStackTrace();
                System.exit(1);
            }
            catch (NumberFormatException nfE) {
                nfE.printStackTrace();
                System.exit(1);
            }
        }
    }

    public Class getInterface() {
        return NavigatorServiceIF.class;
    }

    public void toolTerminated(ToolID toolID, boolean isTerminated) {
        if (isTerminated) {
            this.tools.remove(toolID);
            if (this.tools.size() == 0) {
                this.willExit(true);
            }
        } else {
            this.isWaitingForExit = false;
            this.willExit(false);
        }
    }

    public ToolAdapterInfo[] getAdapterTypes() {
        ToolAdapterInfo[] info = new ToolAdapterInfo[this.adapterTypes.size()];
        return this.adapterTypes.toArray(info);
    }

    public void startTool(ToolInfo tool) {
        ToolAdapterIF adapter = this.createAdapter(tool);
        adapter.setConsumer(new MulticastCmdConsumer());
        adapter.startTool();
        Iterator it = this.clients.values().iterator();
        while (it.hasNext()) {
            SDTNavigatorPerspective nP = (SDTNavigatorPerspective)it.next();
            nP.addToolInstance(this.serverAdmin.getID(), tool);
        }
    }

    public void connectTool(ToolID tool) {
        ToolAdapterIF tA = this.getTool(tool);
        try {
            tA.connectTool();
        }
        catch (AdapterException aE) {
            aE.printStackTrace();
            System.exit(1);
        }
    }

    public void disconnectTool(ToolID tool) {
        this.getTool(tool).disconnectTool();
    }

    public void terminateTool(ToolID tool) {
        this.getTool(tool).killTool();
        Iterator it = this.clients.values().iterator();
        while (it.hasNext()) {
            SDTNavigatorPerspective nP = (SDTNavigatorPerspective)it.next();
            nP.removeToolInstance(this.serverAdmin.getID(), tool);
        }
    }

    public void connectGui(ClientID gui, ToolID tool, String role) {
        ToolAdapterIF tA = this.getTool(tool);
        ClientConnection connection = this.serverAdmin.getClientConnection(gui);
        this.getMCConsumer(tool).addConsumer(connection, role);
        this.getNavigator(gui).connectToolInstance(this.serverAdmin.getID(), tA.getInfo());
    }

    public void disconnectGui(ClientID gui, ToolID tool) {
        ClientConnection connection = this.serverAdmin.getClientConnection(gui);
        this.getMCConsumer(tool).removeConsumer(connection);
        this.getNavigator(gui).disconnectToolInstance(this.serverAdmin.getID(), tool);
        this.getNavigator(gui).resetToolView();
    }

    protected SDTPerspective createPerspective() {
        SDTNavigatorPerspective nP = new SDTNavigatorPerspective();
        nP.setToolService(this);
        return nP;
    }

    protected void setPerspective(ClientID gui) {
        ServerAdminIF sA = Configuration.getServerAdmin();
        SDTGuiAdminIF gA = (SDTGuiAdminIF)sA.getClientAdmin(gui);
        gA.setPerspective(this.getPerspective(gui));
    }

    protected void tryExit() {
        this.isWaitingForExit = true;
        Iterator it = this.tools.values().iterator();
        while (it.hasNext()) {
            ToolAdapterIF tool = (ToolAdapterIF)it.next();
            tool.killTool();
        }
    }

    private ToolAdapterIF createAdapter(ToolInfo tool) {
        ToolAdapterIF adapter = AdapterFactory.createTool(tool);
        this.register(adapter);
        adapter.start();
        return adapter;
    }

    private void register(ToolAdapterIF adapter) {
        this.tools.put(adapter.getInfo().getID(), adapter);
    }

    private ToolAdapterIF getTool(ToolID tool) {
        return (ToolAdapterIF)this.tools.get(tool);
    }

    private MulticastCmdConsumer getMCConsumer(ToolID tool) {
        return (MulticastCmdConsumer)this.getTool(tool).getConsumer();
    }

    private SDTGuiAdminIF getGuiAdmin(ClientID gui) {
        return (SDTGuiAdminIF)this.serverAdmin.getClientAdmin(gui);
    }

    private SDTNavigatorPerspective getNavigator(ClientID gui) {
        return (SDTNavigatorPerspective)this.clients.get(gui);
    }
}

