/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.jump.adapter;

import com.sap.sdt.server.ext.jump.adapter.JumpConstants;
import com.sap.sdt.util.xml.XMLElementIF;
import java.io.File;

class JumpToolkit
implements JumpConstants {
    private static final String[] packetNames = new String[2];
    private static final Class[] columnTypes = new Class[4];
    private static final String[] errTypes = new String[4];
    private static final String[] msgTypes = new String[2];
    private static final String[] eventTypes = new String[4];

    private JumpToolkit() {
    }

    static int getPacketType(String packetName) {
        int packetType = -1;
        for (int i = 0; i < 2; ++i) {
            if (!packetName.equals(packetNames[i])) continue;
            packetType = i;
            break;
        }
        return packetType;
    }

    static int getColumnType(Class columnClass) {
        int columnType = -1;
        for (int i = 0; i < 4; ++i) {
            if (columnClass != columnTypes[i]) continue;
            columnType = i;
            break;
        }
        return columnType;
    }

    static int getErrorType(String errorName) {
        int errorType = -1;
        for (int i = 0; i < 4; ++i) {
            if (!errorName.equals(errTypes[i])) continue;
            errorType = i;
            break;
        }
        return errorType;
    }

    static int getMsgType(XMLElementIF elem) {
        int msgType = 0;
        String name = elem.getName();
        for (int i = 0; i < 1; ++i) {
            if (!name.equals(msgTypes[i])) continue;
            msgType = i + 1;
            break;
        }
        return msgType;
    }

    static int getEventType(String event) {
        int eventType = -1;
        for (int i = 0; i < 4; ++i) {
            if (!event.equals(eventTypes[i])) continue;
            eventType = i;
            break;
        }
        return eventType;
    }

    static {
        JumpToolkit.packetNames[0] = "logon";
        JumpToolkit.packetNames[1] = "error";
        JumpToolkit.columnTypes[0] = String.class;
        JumpToolkit.columnTypes[1] = Boolean.class;
        JumpToolkit.columnTypes[2] = Long.class;
        JumpToolkit.columnTypes[3] = File.class;
        JumpToolkit.errTypes[0] = "malformed";
        JumpToolkit.errTypes[1] = "vrstoolow";
        JumpToolkit.errTypes[2] = "vrstoohi";
        JumpToolkit.errTypes[3] = "busy";
        JumpToolkit.msgTypes[0] = "Event";
        JumpToolkit.eventTypes[0] = "Unit";
        JumpToolkit.eventTypes[1] = "Module";
        JumpToolkit.eventTypes[2] = "Phase";
        JumpToolkit.eventTypes[3] = "Status";
    }
}

