/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.jump.adapter;

import com.sap.sdt.engine.core.event.SDTActionEvent;
import com.sap.sdt.server.core.controls.SDTActionListener;
import com.sap.sdt.server.core.controls.SDTButton;
import com.sap.sdt.server.core.controls.SDTControl;
import com.sap.sdt.server.core.controls.SDTMessageBox;
import com.sap.sdt.server.ext.jump.adapter.AbstractJumpAdapter;
import com.sap.sdt.server.ext.jump.adapter.JumpConstants;

public class JumpActionListener
extends SDTActionListener
implements JumpConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/ext/jump/adapter/JumpActionListener.java#2 $";
    private AbstractJumpAdapter adapter;

    public JumpActionListener(AbstractJumpAdapter adapter) {
        this.adapter = adapter;
    }

    public void actionPerformed(SDTActionEvent e) {
        this.adapter.getDialog().setWaitCursor(true);
        this.adapter.getDialog().setLocked(true);
        this.adapter.getDialog().disableButtons();
        if ("Next".equals(e.getActionCommand())) {
            this.adapter.handleNextAction();
        } else if ("Browse".equals(e.getActionCommand())) {
            this.showErrorPopup();
        } else if ("Error".equals(e.getActionCommand())) {
            this.adapter.getDialog().hidePopup();
            this.adapter.getDialog().setWaitCursor(false);
            this.adapter.getDialog().setLocked(false);
            this.adapter.getDialog().enableButtons();
        } else {
            SDTControl source = (SDTControl)e.getSource();
            this.adapter.handleGenericAction(source);
        }
    }

    private void showErrorPopup() {
        SDTMessageBox popup = new SDTMessageBox();
        String errorText = "<html>Remote file browsing not yet supported in JUMP.<br>Please enter the path manually.</html>";
        SDTButton button = new SDTButton();
        button.addActionListener(this);
        button.setActionCommand("Error");
        button.setCaption("OK", '#');
        button.setDefault(true);
        popup.setMessageText(errorText);
        popup.addButton(button);
        popup.setTitle("Unsupported Operation");
        popup.setModal(false);
        this.adapter.getDialog().showPopup(popup);
    }
}

