/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.jump.adapter;

import com.sap.sdt.engine.core.controls.SDTConstants;
import com.sap.sdt.engine.core.controls.table.SDTTableColumn;
import com.sap.sdt.engine.core.controls.table.SDTTableRow;
import com.sap.sdt.engine.core.services.tool.ToolInfo;
import com.sap.sdt.engine.core.services.tool.ToolServiceIF;
import com.sap.sdt.server.core.controls.SDTActionListener;
import com.sap.sdt.server.core.controls.SDTButton;
import com.sap.sdt.server.core.controls.SDTCheckBox;
import com.sap.sdt.server.core.controls.SDTComponent;
import com.sap.sdt.server.core.controls.SDTContainer;
import com.sap.sdt.server.core.controls.SDTControl;
import com.sap.sdt.server.core.controls.SDTFileBrowser;
import com.sap.sdt.server.core.controls.SDTPanel;
import com.sap.sdt.server.core.controls.SDTPasswordField;
import com.sap.sdt.server.core.controls.SDTProgressPanel;
import com.sap.sdt.server.core.controls.SDTRadioBox;
import com.sap.sdt.server.core.controls.SDTRadioButton;
import com.sap.sdt.server.core.controls.SDTStyledText;
import com.sap.sdt.server.core.controls.SDTTable;
import com.sap.sdt.server.core.controls.SDTTextField;
import com.sap.sdt.server.core.controls.SDTView;
import com.sap.sdt.server.core.services.AdapterException;
import com.sap.sdt.server.core.services.tool.AbstractToolAdapter;
import com.sap.sdt.server.core.services.tool.views.SDTNetWeaverView;
import com.sap.sdt.server.ext.jump.adapter.HandshakeFailedException;
import com.sap.sdt.server.ext.jump.adapter.JumpActionListener;
import com.sap.sdt.server.ext.jump.adapter.JumpBusyException;
import com.sap.sdt.server.ext.jump.adapter.JumpConstants;
import com.sap.sdt.server.ext.jump.adapter.JumpException;
import com.sap.sdt.server.ext.jump.adapter.JumpToolkit;
import com.sap.sdt.server.ext.jump.adapter.MalformedPacketException;
import com.sap.sdt.server.ext.jump.adapter.VersionTooHighException;
import com.sap.sdt.server.ext.jump.adapter.VersionTooLowException;
import com.sap.sdt.trace.TracerAdmin;
import com.sap.sdt.trace.TracerIF;
import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.dialog.CheckBox;
import com.sap.sdt.util.dialog.CompositeDialog;
import com.sap.sdt.util.dialog.DialogConstants;
import com.sap.sdt.util.dialog.ExclusiveSelectionDialog;
import com.sap.sdt.util.dialog.FileInputDialog;
import com.sap.sdt.util.dialog.InfoDialog;
import com.sap.sdt.util.dialog.InputField;
import com.sap.sdt.util.dialog.MultiSelectionDialog;
import com.sap.sdt.util.dialog.MultiTextInputDialog;
import com.sap.sdt.util.dialog.OKCancelDialog;
import com.sap.sdt.util.dialog.PasswordInputDialog;
import com.sap.sdt.util.dialog.PushButton;
import com.sap.sdt.util.dialog.RadioButton;
import com.sap.sdt.util.dialog.RadioButtonGroup;
import com.sap.sdt.util.dialog.SingleTextInputDialog;
import com.sap.sdt.util.dialog.TableInputDialog;
import com.sap.sdt.util.dialog.UtilDialogFactory;
import com.sap.sdt.util.dialog.UtilDialogIF;
import com.sap.sdt.util.dialog.UtilDialogMessageFactory;
import com.sap.sdt.util.misc.Alarm;
import com.sap.sdt.util.misc.AlarmClock;
import com.sap.sdt.util.misc.AlarmObserverIF;
import com.sap.sdt.util.net.CommLinkIF;
import com.sap.sdt.util.net.DefaultCommLink;
import com.sap.sdt.util.net.NetworkException;
import com.sap.sdt.util.value.table.TableModel;
import com.sap.sdt.util.vers.VersionFactory;
import com.sap.sdt.util.vers.VersionIF;
import com.sap.sdt.util.xml.XMLAdmin;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public abstract class AbstractJumpAdapter
extends AbstractToolAdapter
implements AlarmObserverIF,
JumpConstants,
DialogConstants,
SDTConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/ext/jump/adapter/AbstractJumpAdapter.java#2 $";
    protected SDTPanel dialogPanel = null;
    protected SDTProgressPanel progressPanel = null;
    private static final int DEFAULT_PORT = 6666;
    private static final VersionIF VERSION;
    private VersionIF protVers = null;
    private Map controlToElemMap = new HashMap();
    private SDTActionListener listener = new JumpActionListener(this);
    private UtilDialogIF currentDialog = null;
    private boolean isOKCancel = false;
    private List progressListItems = null;
    private AlarmClock alarmClock = null;
    private Alarm alarmRequest = null;
    private long alarmDelay = -1L;
    private TracerIF trc = null;
    private Object dialogSync = new Object();
    private Object progressSync = new Object();
    private boolean progressCanceled = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractJumpAdapter(ToolServiceIF service, ToolInfo info) {
        super(service, info);
        this.trc = TracerAdmin.getTracer();
        this.dialogPanel = new SDTPanel();
        this.progressPanel = new SDTProgressPanel(this.resourcePool);
        this.setProgressListItems(new ArrayList());
        this.createAlarm();
        this.getDialog().setGuiTitle(this.getTitle());
        this.getDialog().setTitle(this.getTitle());
        this.getDialog().setDescription(this.getDescription());
    }

    public void networkError(NetworkException nwE) {
        System.out.println("networkError()");
        nwE.printStackTrace();
        System.exit(1);
    }

    public void commLinkClosed() {
        System.out.println("commLinkClosed()");
        System.exit(1);
    }

    public void alarm(Alarm request) {
        this.alarmRequest = null;
        this.showProgressPanel(false);
    }

    public void handleNextAction() {
        this.sendResponse();
    }

    public void handleGenericAction(SDTControl source) {
        Iterator it = this.controlToElemMap.keySet().iterator();
        while (it.hasNext()) {
            SDTControl control = (SDTControl)it.next();
            if (control.getType() != 9) continue;
            PushButton pB = (PushButton)this.controlToElemMap.get(control);
            if (control == source) {
                pB.setValue(true);
                continue;
            }
            pB.setValue(false);
        }
        this.sendResponse();
    }

    protected CommLinkIF createCommLink() {
        return new DefaultCommLink();
    }

    protected void handshake() throws AdapterException {
        try {
            XMLElementIF packet = XMLAdmin.createXMLElement();
            packet.setName("logon");
            packet.setAttr("version", ((Object)VERSION).toString());
            this.sendPacket(packet);
            packet = this.receivePacket();
            switch (JumpToolkit.getPacketType(packet.getName())) {
                case 0: {
                    this.handlePacketLogon(packet);
                    break;
                }
                case 1: {
                    this.handlePacketError(packet);
                    break;
                }
                default: {
                    throw new MalformedPacketException(packet);
                }
            }
        }
        catch (JumpException jE) {
            throw jE;
        }
        catch (DiagException diagE) {
            throw new HandshakeFailedException(diagE);
        }
    }

    protected int getDefaultPort() {
        return 6666;
    }

    protected SDTView createToolView() {
        return new SDTNetWeaverView();
    }

    protected void handleMsg(String msg) throws AdapterException {
        try {
            this.trc.debug(this.getClass(), "Received: " + msg);
            StringReader reader = new StringReader(msg);
            XMLElementIF elem = XMLAdmin.createXMLElement(reader);
            switch (JumpToolkit.getMsgType(elem)) {
                case 1: {
                    this.handleEvent(elem);
                    break;
                }
                case 0: {
                    this.handleDialog(elem);
                    break;
                }
            }
        }
        catch (DiagException diagE) {
            throw new AdapterException(diagE);
        }
    }

    protected abstract String getTitle();

    protected abstract String getDescription();

    SDTNetWeaverView getDialog() {
        return (SDTNetWeaverView)this.getToolView();
    }

    private void sendPacket(XMLElementIF packet) throws DiagException {
        this.commLink.send(packet.toString());
    }

    private XMLElementIF receivePacket() throws DiagException {
        String msg = this.commLink.receive();
        StringReader reader = new StringReader(msg);
        return XMLAdmin.createXMLElement(reader);
    }

    private void handlePacketLogon(XMLElementIF packet) throws DiagException {
        this.protVers = this.getProtVers(packet);
    }

    private void handlePacketError(XMLElementIF packet) throws DiagException {
        String reason = packet.getAttrString("reason");
        switch (JumpToolkit.getErrorType(reason)) {
            case 0: {
                throw new MalformedPacketException();
            }
            case 1: {
                throw new VersionTooLowException(VERSION, this.getProtVers(packet));
            }
            case 2: {
                throw new VersionTooHighException(VERSION, this.getProtVers(packet));
            }
            case 3: {
                throw new JumpBusyException();
            }
        }
    }

    private VersionIF getProtVers(XMLElementIF packet) throws XMLException {
        String attr = packet.getAttrString("version");
        return VersionFactory.createVersion(attr);
    }

    private void handleEvent(XMLElementIF elem) throws DiagException {
        String event = elem.getAttrString("type");
        String status = elem.getElement("Status").getContent();
        this.getDialog().setStatus(status);
        switch (JumpToolkit.getEventType(event)) {
            case 0: {
                ArrayList<String> list = new ArrayList<String>();
                Iterator it = elem.getSubElements();
                while (it.hasNext()) {
                    XMLElementIF subElem = (XMLElementIF)it.next();
                    if (!subElem.getName().equals("Phase")) continue;
                    list.add(subElem.getContentTrimmed());
                }
                this.setProgressListItems(list);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                String phase = elem.getElement("Phase").getContent();
                int index = this.progressListItems.indexOf(phase);
                this.progressPanel.setProgressListIndex(index);
                break;
            }
            case 3: {
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDialog(XMLElementIF elem) throws DiagException {
        try {
            Object object = this.progressSync;
            synchronized (object) {
                this.stopAlarm();
                this.progressCanceled = true;
                this.currentDialog = UtilDialogMessageFactory.toDialog(elem);
                this.dialogPanel.removeAll();
                this.getDialog().removeButtons();
                String title = this.currentDialog.getTitle();
                String descr = this.currentDialog.getDescription();
                if (title == null || title.length() == 0) {
                    title = this.getTitle();
                }
                if (descr == null || descr.length() == 0) {
                    descr = this.getDescription();
                }
                if (!($assertionsDisabled || title != null && title.length() != 0)) {
                    throw new AssertionError();
                }
                if (!($assertionsDisabled || descr != null && descr.length() != 0)) {
                    throw new AssertionError();
                }
                this.getDialog().setTitle(title);
                this.getDialog().setDescription(descr);
                this.handleDialog((SDTContainer)this.dialogPanel, this.currentDialog);
                this.addButtons();
                this.toolView.refresh();
                this.getDialog().setWaitCursor(false);
            }
            object = this.dialogSync;
            synchronized (object) {
                this.dialogSync.wait();
            }
            this.showProgressPanel(true);
            this.progressCanceled = false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void handleDialog(SDTContainer parent, UtilDialogIF dialog) {
        switch (UtilDialogFactory.getDialogType(dialog.getType())) {
            case 0: {
                this.handleDialog(parent, (SingleTextInputDialog)dialog);
                break;
            }
            case 1: {
                this.handleDialog(parent, (MultiTextInputDialog)dialog);
                break;
            }
            case 2: {
                this.handleDialog(parent, (ExclusiveSelectionDialog)dialog);
                break;
            }
            case 3: {
                this.handleDialog(parent, (MultiSelectionDialog)dialog);
                break;
            }
            case 4: {
                this.handleDialog(parent, (OKCancelDialog)dialog);
                break;
            }
            case 5: {
                this.handleDialog(parent, (InfoDialog)dialog);
                break;
            }
            case 6: {
                this.handleDialog(parent, (CompositeDialog)dialog);
                break;
            }
            case 7: {
                this.handleDialog(parent, (PasswordInputDialog)dialog);
                break;
            }
            case 8: {
                this.handleDialog(parent, (FileInputDialog)dialog);
                break;
            }
            case 9: {
                this.handleDialog(parent, (TableInputDialog)dialog);
                break;
            }
            default: {
                System.out.println(dialog.getType());
            }
        }
    }

    private void handleDialog(SDTContainer parent, SingleTextInputDialog dialog) {
        SDTStyledText heading = new SDTStyledText(false);
        heading.setText(dialog.getHeading());
        InputField inputField = dialog.getInputField();
        SDTTextField textField = new SDTTextField();
        textField.setCaption(inputField.getLabel().getText(), '#');
        textField.setText(inputField.getValue().toString());
        this.add(textField, inputField);
        parent.add(heading);
        parent.add(textField);
    }

    private void handleDialog(SDTContainer parent, MultiTextInputDialog dialog) {
        SDTStyledText header = new SDTStyledText(false);
        header.setText(dialog.getHeading());
        parent.add(header);
        InputField[] fields = dialog.getInputFieldArray();
        for (int i = 0; i < fields.length; ++i) {
            SDTTextField field = new SDTTextField();
            field.setCaption(fields[i].getLabel().getText(), '#');
            field.setText(fields[i].getValue().toString());
            this.add(field, fields[i]);
            parent.add(field);
        }
    }

    private void handleDialog(SDTContainer parent, ExclusiveSelectionDialog dialog) {
        SDTStyledText header = new SDTStyledText(false);
        header.setText(dialog.getHeading());
        parent.add(header);
        SDTRadioBox box = new SDTRadioBox();
        RadioButtonGroup rbG = dialog.getRadioButtonGroup();
        for (int i = 0; i < rbG.getRadioButtonCount(); ++i) {
            RadioButton rB = rbG.getRadioButton(i);
            SDTRadioButton button = new SDTRadioButton();
            button.setCaption(rB.getLabel().getText(), '#');
            button.setSelected(rB.isSelected());
            this.add(button, rB);
            box.add(button);
        }
        parent.add(box);
    }

    private void handleDialog(SDTContainer parent, MultiSelectionDialog dialog) {
        SDTStyledText header = new SDTStyledText(false);
        header.setText(dialog.getHeading());
        parent.add(header);
        CheckBox[] cbA = dialog.getCheckBoxArray();
        for (int i = 0; i < cbA.length; ++i) {
            SDTCheckBox cB = new SDTCheckBox();
            cB.setCaption(cbA[i].getLabel().getText(), '#');
            cB.setSelected(cbA[i].isSelected());
            this.add(cB, cbA[i]);
            parent.add(cB);
        }
    }

    private void handleDialog(SDTContainer parent, OKCancelDialog dialog) {
        this.isOKCancel = true;
        this.addOKCancelButtons(dialog);
    }

    private void handleDialog(SDTContainer parent, InfoDialog dialog) {
        SDTStyledText textArea = new SDTStyledText(false);
        textArea.setText(dialog.getText());
        parent.add(textArea);
    }

    private void handleDialog(SDTContainer parent, CompositeDialog dialog) {
        SDTPanel panel = new SDTPanel();
        Iterator it = dialog.getChilds().iterator();
        while (it.hasNext()) {
            this.handleDialog((SDTContainer)panel, (UtilDialogIF)it.next());
        }
        parent.add(panel);
    }

    private void handleDialog(SDTContainer parent, PasswordInputDialog dialog) {
        SDTStyledText header = new SDTStyledText(false);
        header.setText(dialog.getHeading());
        parent.add(header);
        SDTPasswordField pwd = new SDTPasswordField();
        InputField iF = dialog.getInputField();
        pwd.setConfirm(dialog.getRetypePassword());
        pwd.setCaption(iF.getLabel().getText(), '#');
        this.add(pwd, iF);
        parent.add(pwd);
    }

    private void handleDialog(SDTContainer parent, FileInputDialog dialog) {
        SDTStyledText header = new SDTStyledText(false);
        header.setText(dialog.getHeading());
        parent.add(header);
        SDTFileBrowser fB = new SDTFileBrowser();
        InputField iF = dialog.getInputField();
        fB.setCaption(iF.getLabel().getText(), '#');
        fB.setText(iF.getValue().toString());
        fB.addBrowseListener("Browse", this.listener);
        this.add(fB, iF);
        parent.add(fB);
    }

    private void handleDialog(SDTContainer parent, TableInputDialog dialog) {
        int i;
        SDTTable table = new SDTTable();
        table.setCaption(dialog.getHeading(), '#');
        table.enableAddRemove(true);
        TableModel tM = dialog.getTableModel();
        for (i = 0; i < tM.getColumnCount(); ++i) {
            SDTTableColumn column = new SDTTableColumn();
            column.setCaption(tM.getColumnName(i));
            column.setEnabled(tM.isCellEditable(0, i));
            this.setColumnType(column, tM.getColumnClass(i));
            table.addColumn(column);
        }
        for (i = 0; i < tM.getRowCount(); ++i) {
            SDTTableRow row = new SDTTableRow();
            for (int j = 0; j < tM.getColumnCount(); ++j) {
                row.add(tM.getValueAt(i, j));
            }
            table.addRow(row);
        }
        parent.add(table);
        this.add(table, tM);
    }

    private void add(SDTControl control, Object element) {
        this.controlToElemMap.put(control, element);
    }

    private void setColumnType(SDTTableColumn column, Class cls) {
        switch (JumpToolkit.getColumnType(cls)) {
            case 0: {
                column.setColumnType(0);
                break;
            }
            case 1: {
                column.setColumnType(1);
                break;
            }
            case 2: {
                column.setColumnType(0);
                column.setConstraint(1, true);
                break;
            }
            case 3: {
                column.setColumnType(3);
                break;
            }
            default: {
                column.setColumnType(0);
            }
        }
    }

    private void addButtons() {
        if (this.isOKCancel) {
            this.isOKCancel = false;
        } else {
            this.addDefaultButtons();
        }
    }

    private void addOKCancelButtons(OKCancelDialog dialog) {
        Iterator it = dialog.getButtons().iterator();
        while (it.hasNext()) {
            PushButton pB = (PushButton)it.next();
            String aC = pB.getActionCommand();
            String bC = pB.getText();
            SDTButton button = new SDTButton();
            button.setActionCommand(aC);
            button.setCaption(bC, '#');
            button.addActionListener(this.listener);
            this.getDialog().addButton(button);
            this.add(button, pB);
        }
    }

    private void addDefaultButtons() {
        SDTButton ok = new SDTButton();
        ok.setCaption("Next", '#');
        ok.addActionListener(this.listener);
        this.getDialog().addButton(ok);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResponse() {
        try {
            this.toolView.updateControl();
            this.updateElements();
            this.currentDialog.updateVariables();
            String msg = UtilDialogMessageFactory.toString(this.currentDialog);
            this.trc.debug(this.getClass(), "Sending message " + msg);
            this.commLink.send(msg);
            Object object = this.dialogSync;
            synchronized (object) {
                this.dialogSync.notify();
            }
        }
        catch (DiagException diagEx) {
            this.trc.error(this.getClass(), diagEx);
        }
    }

    private void updateElements() {
        this.updateComposite(this.dialogPanel);
    }

    private void updateControl(SDTControl control) {
        switch (control.getType()) {
            case 3: 
            case 13: {
                this.updateComposite((SDTContainer)control);
                break;
            }
            case 20: {
                this.updateRadioBox((SDTRadioBox)control);
                break;
            }
            case 15: {
                this.updateTable((SDTTable)control);
                break;
            }
            default: {
                this.updateComponent((SDTComponent)control);
            }
        }
    }

    private void updateComposite(SDTContainer composite) {
        Vector controls = composite.getControls();
        for (int i = 0; i < controls.size(); ++i) {
            this.updateControl((SDTControl)controls.get(i));
        }
    }

    private void updateRadioBox(SDTRadioBox radioBox) {
        Iterator it = radioBox.getButtons().iterator();
        while (it.hasNext()) {
            SDTRadioButton radioButton = (SDTRadioButton)it.next();
            this.updateComponent(radioButton);
        }
    }

    private void updateTable(SDTTable table) {
        TableModel tM = (TableModel)this.controlToElemMap.get(table);
        for (int i = 0; i < tM.getRowCount(); ++i) {
            List data = table.getRow(i).getCells();
            for (int j = 0; j < tM.getColumnCount(); ++j) {
                tM.setValueAt(data.get(j), i, j);
            }
        }
    }

    private void updateComponent(SDTComponent component) {
        Object elem = this.controlToElemMap.get(component);
        String text = null;
        boolean isSelected = false;
        switch (component.getType()) {
            case 7: {
                text = ((SDTTextField)component).getText();
                ((InputField)elem).updateValue(text);
                break;
            }
            case 10: {
                isSelected = ((SDTRadioButton)component).isSelected();
                ((RadioButton)elem).setSelected(isSelected);
                break;
            }
            case 11: {
                isSelected = ((SDTCheckBox)component).isSelected();
                ((CheckBox)elem).setSelected(isSelected);
                break;
            }
            case 8: {
                text = ((SDTPasswordField)component).getText();
                ((InputField)elem).updateValue(text);
                break;
            }
            case 16: {
                text = ((SDTFileBrowser)component).getText();
                ((InputField)elem).updateValue(text);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showProgressPanel(boolean keep) {
        if (keep) {
            this.startAlarm();
        } else {
            Object object = this.progressSync;
            synchronized (object) {
                if (!this.progressCanceled) {
                    this.dialogPanel.removeAll();
                    this.dialogPanel.add(this.progressPanel);
                    this.getDialog().refresh();
                }
            }
        }
    }

    private void createAlarm() {
        this.alarmDelay = 500L;
        this.alarmClock = new AlarmClock();
        this.alarmRequest = null;
    }

    private void startAlarm() {
        if (this.alarmDelay < 0L) {
            return;
        }
        this.alarmRequest = this.alarmClock.createAlarm(this, this.alarmDelay);
    }

    private void stopAlarm() {
        if (this.alarmDelay < 0L) {
            return;
        }
        if (this.alarmRequest != null) {
            this.alarmClock.stopAlarm(this.alarmRequest);
            this.alarmRequest = null;
        }
    }

    private void setProgressListItems(List list) {
        this.progressListItems = list;
        String[] str = new String[list.size()];
        this.progressPanel.setProgressList(list.toArray(str));
    }

    static {
        $assertionsDisabled = !AbstractJumpAdapter.class.desiredAssertionStatus();
        VERSION = VersionFactory.createVersion("1.0");
    }
}

