/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.core.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class StackTrace {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/core/util/StackTrace.java#2 $";
    private static final int CLASSNAME = 0;
    private static final int METHODNAME = 1;
    private static final String PREFIX = " - ";
    private static final String THREAD_CLASS = "Thread class: ";
    private static final String THREAD_NAME = "Thread name: ";
    private static final String STACKLEVEL = "at";
    private static final char OPENBRACE = '(';
    private static final char DOT = '.';

    private static String getName(String entry, int mode) {
        int n = entry.lastIndexOf(40);
        if (n < 0) {
            return null;
        }
        String name = entry.substring(0, n);
        int m = name.lastIndexOf(46);
        if (m < 0) {
            return null;
        }
        switch (mode) {
            case 0: {
                return name.substring(0, m);
            }
            case 1: {
                return name.substring(m + 1, n);
            }
        }
        return null;
    }

    private static String[] copyToArray(Vector v) {
        String[] array = new String[v.size()];
        int index = 0;
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            array[index++] = (String)e.nextElement();
        }
        return array;
    }

    private static String[] getStack(Throwable t, boolean flag) {
        StringTokenizer sT = new StringTokenizer(StackTrace.getStackRaw(t));
        Vector<Object> v = new Vector<Object>();
        while (sT.hasMoreElements()) {
            String el = (String)sT.nextElement();
            if (!el.equals(STACKLEVEL)) continue;
            if (!sT.hasMoreElements()) break;
            if (flag) {
                sT.nextElement();
                flag = false;
                continue;
            }
            v.addElement(sT.nextElement());
        }
        return StackTrace.copyToArray(v);
    }

    private static String getStackInfo(String[] frames) {
        int n = frames.length - 1;
        Thread curThread = Thread.currentThread();
        String stackInfo = THREAD_CLASS + curThread.getClass().toString();
        stackInfo = stackInfo + " Thread name: " + curThread.getName() + "\n";
        int i = 0;
        while (i < frames.length) {
            stackInfo = stackInfo + " - [" + n + "] ";
            stackInfo = stackInfo + frames[i] + "\n";
            ++i;
            --n;
        }
        return stackInfo;
    }

    public static String getCurrentClassName() {
        String[] s = StackTrace.getStack(new Throwable(), true);
        return s.length > 0 ? StackTrace.getName(s[0], 0) : null;
    }

    public static String getCurrentMethodName() {
        String[] s = StackTrace.getStack(new Throwable(), true);
        return s.length > 0 ? StackTrace.getName(s[0], 1) : null;
    }

    public static String getClassName(int frameNo) {
        String[] s = StackTrace.getStack(new Throwable(), true);
        if (frameNo >= 0 && s.length > frameNo) {
            return StackTrace.getName(s[frameNo], 0);
        }
        return null;
    }

    public static String getMethodName(int frameNo) {
        String[] s = StackTrace.getStack(new Throwable(), true);
        if (frameNo >= 0 && s.length > frameNo) {
            return StackTrace.getName(s[frameNo], 1);
        }
        return null;
    }

    public static String[] getStack() {
        return StackTrace.getStack(new Throwable(), true);
    }

    public static String[] getStack(Throwable t) {
        return StackTrace.getStack(t, false);
    }

    public static String getStackRaw() {
        return StackTrace.getStackRaw(new Throwable());
    }

    public static String getStackRaw(Throwable t) {
        StringWriter sWriter = new StringWriter();
        t.printStackTrace(new PrintWriter(sWriter));
        return sWriter.toString();
    }

    public static String getStackInfo() {
        return StackTrace.getStackInfo(StackTrace.getStack());
    }

    public static String getStackInfo(Throwable t) {
        return StackTrace.getStackInfo(StackTrace.getStack(t, false));
    }
}

