/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.core.util;

import com.sap.sdt.server.core.util.Dater;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class ServerLog {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/core/util/ServerLog.java#2 $";
    private static boolean quiet = false;
    private static String prefix = "SDTServer> ";
    private static PrintWriter printer = null;

    protected void finalize() {
        if (printer != null) {
            printer.close();
            printer = null;
        }
    }

    public static String setLogFile(String path) {
        try {
            if (printer != null) {
                printer.close();
                printer = null;
            }
            FileWriter writer = new FileWriter(path, true);
            printer = new PrintWriter((Writer)writer, true);
            printer.println("\n" + prefix + "New server started at " + Dater.getDateTime() + "\n");
            return null;
        }
        catch (IOException e) {
            printer = null;
            return "IOException: " + e.getMessage();
        }
    }

    public static void stdout(String message) {
        ServerLog.stdout(prefix, message);
    }

    public static void stdout(String prefix, String message) {
        if (quiet) {
            return;
        }
        System.out.println(prefix + message);
    }

    public static void stderr(String message) {
        ServerLog.stdout(prefix, message);
    }

    public static void stderr(String prefix, String message) {
        System.err.println(prefix + "ERROR: " + message);
    }

    public static void out(String message) {
        ServerLog.out(prefix, message);
    }

    public static void out(String prefix, String message) {
        if (quiet) {
            return;
        }
        String text = prefix + message;
        if (printer != null) {
            printer.println(text);
        } else {
            System.out.println(text);
        }
    }

    public static void err(String message) {
        ServerLog.err(prefix, message);
    }

    public static void err(String prefix, String message) {
        String text = prefix + "ERROR: " + message;
        if (printer != null) {
            printer.println(text);
        } else {
            System.err.println(text);
        }
    }
}

