/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.core.util;

import com.sap.sdt.server.core.util.FileInfo;
import java.io.File;

public class DirInfo
extends File {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/core/util/DirInfo.java#2 $";
    public static final int NAME = 0;
    public static final int DATE = 1;
    public static final int SIZE = 2;
    private static final int SORT_TRADEOFF = 8;
    private static final char sepChar = ' ';
    private static final int sepLen = 2;
    private FileInfo[] dirDirs = null;
    private FileInfo[] dirFiles = null;
    private int sortKey = 1;
    private boolean contentsRead = false;

    public DirInfo(String dirName) {
        super(dirName);
    }

    public DirInfo(String dirName, int sortKey) {
        this(dirName);
        this.sortKey = sortKey;
    }

    private void readContents() {
        FileInfo entry;
        String[] dirEntries = this.list();
        FileInfo[] entries = new FileInfo[dirEntries.length];
        int iEntries = 0;
        int iFiles = 0;
        int iDirs = 0;
        for (int i = 0; i < dirEntries.length; ++i) {
            if (dirEntries[i] == null || !(entry = new FileInfo(this.getAbsolutePath(), dirEntries[i])).exists()) continue;
            entries[iEntries++] = entry;
            if (entry.isDirectory()) {
                ++iDirs;
                continue;
            }
            if (!entry.isFile()) continue;
            ++iFiles;
        }
        this.dirDirs = new FileInfo[iDirs];
        this.dirFiles = new FileInfo[iFiles];
        iDirs = 0;
        iFiles = 0;
        int nEntries = iEntries;
        for (iEntries = 0; iEntries < nEntries; ++iEntries) {
            entry = entries[iEntries];
            if (entry.isDirectory()) {
                this.dirDirs[iDirs++] = entry;
                continue;
            }
            if (!entry.isFile()) continue;
            this.dirFiles[iFiles++] = entry;
        }
    }

    private void format(FileInfo[] entries) {
        FileInfo info;
        int iEntries;
        int tmpLen = 0;
        String tmpStr = null;
        int curPos = 0;
        int noOfSpaces = 0;
        int maxNameLen = 0;
        int maxDateLen = 0;
        int maxSizeLen = 0;
        for (iEntries = 0; iEntries < entries.length; ++iEntries) {
            info = entries[iEntries];
            if (info.getName().length() > maxNameLen) {
                maxNameLen = info.getName().length();
            }
            if (info.getDate().length() > maxDateLen) {
                maxDateLen = info.getDate().length();
            }
            if (info.getSize().length() <= maxSizeLen) continue;
            maxSizeLen = info.getSize().length();
        }
        char[] buffer = new char[maxNameLen + maxDateLen + maxSizeLen + 4];
        for (iEntries = 0; iEntries < entries.length; ++iEntries) {
            info = entries[iEntries];
            curPos = 0;
            tmpStr = info.getName();
            tmpLen = tmpStr.length();
            tmpStr.getChars(0, tmpLen, buffer, curPos);
            curPos += tmpLen;
            for (noOfSpaces = maxNameLen - tmpLen; noOfSpaces > 0; --noOfSpaces) {
                buffer[curPos++] = 32;
            }
            for (noOfSpaces = 2; noOfSpaces > 0; --noOfSpaces) {
                buffer[curPos++] = 32;
            }
            tmpStr = info.getDate();
            tmpLen = tmpStr.length();
            for (noOfSpaces = maxDateLen - tmpLen; noOfSpaces > 0; --noOfSpaces) {
                buffer[curPos++] = 32;
            }
            tmpStr.getChars(0, tmpLen, buffer, curPos);
            curPos += tmpLen;
            for (noOfSpaces = 2; noOfSpaces > 0; --noOfSpaces) {
                buffer[curPos++] = 32;
            }
            tmpStr = info.getSize();
            tmpLen = tmpStr.length();
            for (noOfSpaces = maxSizeLen - tmpLen; noOfSpaces > 0; --noOfSpaces) {
                buffer[curPos++] = 32;
            }
            tmpStr.getChars(0, tmpLen, buffer, curPos);
            info.setFormat(new String(buffer));
        }
    }

    private void sort(FileInfo[] entries, int sortKey) {
        if (entries.length > 8) {
            this.qsort(entries, 0, entries.length - 1, sortKey);
        } else {
            this.ssort(entries, sortKey);
        }
    }

    private void ssort(FileInfo[] entries, int sortKey) {
        for (int i = entries.length - 1; i >= 0; --i) {
            int max = i;
            for (int j = i - 1; j >= 0; --j) {
                if (!entries[j].isLower(entries[max], sortKey)) continue;
                max = j;
            }
            FileInfo tmp = entries[i];
            entries[i] = entries[max];
            entries[max] = tmp;
        }
    }

    private void qsort(FileInfo[] a, int l, int r, int key) {
        if (l > r) {
            return;
        }
        FileInfo t = null;
        FileInfo v = a[(l + r) / 2];
        int i = l;
        int j = r;
        while (true) {
            if (a[i].isLower(v, key)) {
                ++i;
                continue;
            }
            while (v.isLower(a[j], key)) {
                --j;
            }
            if (i <= j) {
                t = a[i];
                a[i] = a[j];
                a[j] = t;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (l < j) {
            this.qsort(a, l, j, key);
        }
        if (i < r) {
            this.qsort(a, i, r, key);
        }
    }

    private void sort(int sortKey) {
        this.sort(this.dirDirs, 0);
        this.sort(this.dirFiles, sortKey);
    }

    public void update() {
        if (!this.contentsRead) {
            this.readContents();
            this.format(this.dirFiles);
            this.sort(this.sortKey);
            this.contentsRead = true;
        }
    }

    public int getSortStyle() {
        return this.sortKey;
    }

    public void setSortStyle(int sortKey) {
        switch (sortKey) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                return;
            }
        }
        if (this.sortKey != sortKey) {
            this.sort(sortKey);
            this.sortKey = sortKey;
        }
    }

    public FileInfo[] getDirInfos() {
        this.update();
        return this.dirDirs;
    }

    public FileInfo[] getFileInfos() {
        this.update();
        return this.dirFiles;
    }

    public FileInfo[] getFileInfos(String pattern) {
        return this.getFileInfos();
    }

    public void print() {
        int i;
        System.out.print("\nDirectory:  " + this.getAbsolutePath());
        System.out.print("\n\n    Directories:\n");
        for (i = 0; i < this.dirDirs.length; ++i) {
            System.out.print("      " + this.dirDirs[i] + "\n");
        }
        System.out.print("\n\n    Files:\n");
        for (i = 0; i < this.dirFiles.length; ++i) {
            System.out.print("      " + this.dirFiles[i] + "\n");
        }
        System.out.print("\n");
    }

    public static void main(String[] args) {
        DirInfo dirInfo = null;
        String dirName = null;
        if (args.length > 0) {
            dirName = args[0];
        }
        if (dirName == null) {
            dirName = System.getProperty("user.dir");
        }
        dirInfo = new DirInfo(dirName);
        dirInfo.update();
        dirInfo.print();
    }
}

