/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.core.util;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class Dater {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/core/util/Dater.java#2 $";
    private static DateFormat dateTF = DateFormat.getDateTimeInstance(2, 2);

    public static String getDateTime() {
        return Dater.format(new Date());
    }

    public static String format(Date date) {
        return dateTF.format(date);
    }

    public static String getUserTimeZoneID() {
        try {
            return System.getProperty("user.timezone");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean setTimeZone(String tzID) {
        TimeZone tz = TimeZone.getTimeZone(tzID);
        if (tz != null) {
            dateTF.setTimeZone(tz);
            return true;
        }
        return false;
    }

    public static String getTimeZoneID() {
        TimeZone tz = dateTF.getTimeZone();
        if (tz != null) {
            return tz.getID();
        }
        return null;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            if (args[0].startsWith("-")) {
                System.out.println("Available time zone ids:");
                String[] ids = TimeZone.getAvailableIDs();
                for (int i = 0; i < ids.length; ++i) {
                    Dater.setTimeZone(ids[i]);
                    System.out.println("  - " + ids[i] + " : " + Dater.getDateTime());
                }
                System.out.println("\nAvailable locale ids:");
                Locale[] locales = DateFormat.getAvailableLocales();
                for (int i = 0; i < locales.length; ++i) {
                    System.out.println("  - " + locales[i]);
                }
                System.out.println("\nDefault locale id: " + Locale.getDefault());
                System.exit(0);
            }
            if (!Dater.setTimeZone(args[0])) {
                System.err.println("Dater: invalid time zone " + args[0]);
                System.exit(1);
            }
        } else if (Dater.setTimeZone(Dater.getUserTimeZoneID())) {
            System.out.println("UserTimeZoneID: " + Dater.getUserTimeZoneID());
        } else {
            System.out.println("DefaultTimeZoneID: " + TimeZone.getDefault().getID());
        }
        System.out.println(Dater.getDateTime());
    }
}

