/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.core.services.tool;

import com.sap.sdt.engine.core.admin.ClientID;
import com.sap.sdt.engine.core.admin.SDTGuiAdminIF;
import com.sap.sdt.engine.core.admin.ServerAdminIF;
import com.sap.sdt.engine.core.communication.ClientConnection;
import com.sap.sdt.engine.core.communication.Configuration;
import com.sap.sdt.engine.core.event.SDTActionEvent;
import com.sap.sdt.engine.core.services.GuiServiceException;
import com.sap.sdt.engine.core.services.ServiceKey;
import com.sap.sdt.engine.core.services.tool.ToolAdapterInfo;
import com.sap.sdt.engine.core.services.tool.ToolInfo;
import com.sap.sdt.server.core.controls.SDTActionListener;
import com.sap.sdt.server.core.controls.SDTButton;
import com.sap.sdt.server.core.controls.SDTPerspective;
import com.sap.sdt.server.core.controls.SDTView;
import com.sap.sdt.server.core.services.AbstractGuiService;
import com.sap.sdt.server.core.services.AdapterException;
import com.sap.sdt.server.core.services.tool.ToolAdapterIF;
import com.sap.sdt.server.core.services.tool.ToolConnectFailedException;
import com.sap.sdt.server.core.services.tool.views.SDTNetWeaverView;

public abstract class AbstractToolService
extends AbstractGuiService {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/core/services/tool/AbstractToolService.java#2 $";
    protected ToolAdapterInfo adapterInfo = null;
    protected ToolInfo toolInfo = null;
    protected ToolAdapterIF adapter = null;
    protected SDTPerspective perspective = null;
    protected boolean isClientSide = false;
    protected boolean isWaitingForExit = false;

    public AbstractToolService(String name) {
        super(name);
    }

    public void addGui(ClientID gui) throws GuiServiceException {
        super.addGui(gui);
        try {
            this.adapter.connectTool();
        }
        catch (AdapterException aE) {
            throw new ToolConnectFailedException(this.getName(), aE);
        }
        this.setConsumer(gui);
        this.adapter.start();
    }

    public SDTView getToolView() {
        return this.adapter.getToolView();
    }

    protected void generateKey(String name) {
        if (Configuration.getType() == 0) {
            this.key = new ServiceKey(null, name, this.getInterface());
        } else {
            super.generateKey(name);
        }
    }

    protected void setPerspective(ClientID gui) {
        SDTGuiAdminIF gA = null;
        if (this.isClientSide) {
            gA = (SDTGuiAdminIF)Configuration.getClientAdmin();
        } else {
            ServerAdminIF sA = Configuration.getServerAdmin();
            gA = (SDTGuiAdminIF)sA.getClientAdmin(gui);
        }
        gA.setPerspective(this.getPerspective(gui));
        ((SDTPerspective)this.clients.get(gui)).addView(this.getToolView());
    }

    protected void setConsumer(ClientID gui) {
        if (!this.isClientSide) {
            ServerAdminIF sA = Configuration.getServerAdmin();
            ClientConnection connection = sA.getClientConnection(gui);
            this.adapter.setConsumer(connection);
        }
    }

    protected void showErrorMessage(AdapterException aE) {
        SDTButton button = new SDTButton();
        button.setCaption("Exit", 'E');
        button.setDefault(true);
        button.addActionListener(new SDTActionListener(){

            public void actionPerformed(SDTActionEvent e) {
                System.exit(0);
            }
        });
        String message = "<html>No connection to " + this.getName() + " could be established<br>";
        message = message + "Internal error message: " + aE.getMessage() + "</html>";
        SDTNetWeaverView dlg = (SDTNetWeaverView)this.adapter.getToolView();
        dlg.setTitle("Connection Error");
        dlg.setDescription(message);
        dlg.setStatus("Connection failed");
        dlg.addButton(button);
    }

    protected abstract String getName();
}

