/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.core.services.tool;

import com.sap.sdt.engine.core.services.tool.ToolInfo;
import com.sap.sdt.engine.core.services.tool.ToolServiceIF;
import com.sap.sdt.server.core.controls.SDTView;
import com.sap.sdt.server.core.resources.ResourcePool;
import com.sap.sdt.server.core.services.AbstractAdapter;
import com.sap.sdt.server.core.services.AdapterException;
import com.sap.sdt.server.core.services.tool.ConnectFailedException;
import com.sap.sdt.server.core.services.tool.SendFailedException;
import com.sap.sdt.server.core.services.tool.ToolAdapterIF;
import com.sap.sdt.util.net.CommLinkIF;
import com.sap.sdt.util.net.CommLinkObserverIF;
import com.sap.sdt.util.net.DefaultCommLink;
import com.sap.sdt.util.net.NetworkException;

public abstract class AbstractToolAdapter
extends AbstractAdapter
implements ToolAdapterIF,
CommLinkObserverIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/core/services/tool/AbstractToolAdapter.java#2 $";
    protected ToolServiceIF service = null;
    protected ToolInfo info = null;
    protected CommLinkIF commLink = null;
    protected SDTView toolView = null;
    protected final ResourcePool resourcePool;

    public AbstractToolAdapter(ToolServiceIF service, ToolInfo info) {
        super(info.getAdapterName());
        this.info = info;
        this.service = service;
        this.toolView = this.createToolView();
        this.resourcePool = new ResourcePool();
    }

    public SDTView getToolView() {
        return this.toolView;
    }

    public ToolInfo getInfo() {
        return this.info;
    }

    public void startTool() {
    }

    public void connectTool() throws AdapterException {
        this.commLink = this.createCommLink();
        try {
            this.commLink.connect(this.info.getHost(), this.info.getPort());
        }
        catch (NetworkException nwE) {
            throw new ConnectFailedException(nwE, this.info);
        }
        this.handshake();
        this.commLink.addObserver(this);
        this.commLink.start();
    }

    public void disconnectTool() {
    }

    public void killTool() {
    }

    public void send(String msg) throws AdapterException {
        if (this.commLink != null) {
            try {
                this.commLink.send(msg);
            }
            catch (NetworkException nwE) {
                throw new SendFailedException(nwE, msg);
            }
        }
    }

    public ResourcePool getResourcePool() {
        return this.resourcePool;
    }

    public void msgReceived(String msg) {
        this.inputReceived(msg);
    }

    protected CommLinkIF createCommLink() {
        return new DefaultCommLink();
    }

    protected void init() {
    }

    protected void handleInput(Object obj) throws AdapterException {
        this.handleMsg((String)obj);
    }

    protected abstract int getDefaultPort();

    protected abstract void handshake() throws AdapterException;

    protected abstract void handleMsg(String var1) throws AdapterException;

    protected abstract SDTView createToolView();
}

