/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.core.services;

import com.sap.sdt.engine.core.admin.ClientID;
import com.sap.sdt.engine.core.admin.ServerAdminIF;
import com.sap.sdt.engine.core.communication.Configuration;
import com.sap.sdt.engine.core.controls.SDTPerspectiveIF;
import com.sap.sdt.engine.core.services.GuiServiceException;
import com.sap.sdt.engine.core.services.GuiServiceIF;
import com.sap.sdt.engine.core.services.ServiceKey;
import com.sap.sdt.server.core.controls.SDTPerspective;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractGuiService
implements GuiServiceIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/core/services/AbstractGuiService.java#2 $";
    protected ServiceKey key = null;
    protected Map clients = null;
    protected boolean willExit = false;
    protected Object sync = null;

    protected AbstractGuiService(String name) {
        this.generateKey(name);
        this.clients = new HashMap();
        this.sync = new Object();
    }

    public ServiceKey getKey() {
        return this.key;
    }

    public void addGui(ClientID gui) throws GuiServiceException {
        this.clients.put(gui, this.createPerspective());
        this.setPerspective(gui);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeGui(ClientID gui) {
        Object object = this.sync;
        synchronized (object) {
            this.tryExit();
            try {
                this.sync.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.willExit) {
            if (this.clients.size() == 0) {
                ((SDTPerspective)this.clients.get(gui)).delete();
            }
            this.clients.remove(gui);
        }
        return this.willExit;
    }

    public SDTPerspectiveIF getPerspective(ClientID gui) {
        SDTPerspective perspective = (SDTPerspective)this.clients.get(gui);
        return (SDTPerspectiveIF)perspective.getDelegate();
    }

    protected abstract SDTPerspective createPerspective();

    protected abstract void setPerspective(ClientID var1);

    protected void generateKey(String name) {
        ServerAdminIF sA = Configuration.getServerAdmin();
        this.key = new ServiceKey(sA.getID(), name, this.getInterface());
    }

    protected void tryExit() {
        this.willExit(true);
    }

    protected final void willExit(boolean willExit) {
        this.willExit = willExit;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = AbstractGuiService.this.sync;
                synchronized (object) {
                    AbstractGuiService.this.sync.notify();
                }
            }
        };
        new Thread(runnable).start();
    }
}

