/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.core.services;

import com.sap.sdt.engine.core.communication.CmdConsumerIF;
import com.sap.sdt.engine.core.communication.CmdProducerIF;
import com.sap.sdt.server.core.services.AdapterException;
import com.sap.sdt.server.core.services.AdapterIF;
import com.sap.sdt.trace.TracerAdmin;
import com.sap.sdt.trace.TracerIF;
import com.sap.sdt.util.misc.SyncBuffer;

public abstract class AbstractAdapter
extends Thread
implements AdapterIF,
CmdProducerIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/core/services/AbstractAdapter.java#2 $";
    protected boolean isRunning = false;
    protected SyncBuffer buffer = new SyncBuffer();
    protected CmdConsumerIF consumer = null;
    protected TracerIF tracer = TracerAdmin.getTracer();

    public AbstractAdapter(String name) {
        super(name);
        this.logStartup();
    }

    public void start() {
        this.isRunning = true;
        super.start();
    }

    public void inputReceived(Object obj) {
        this.buffer.put(obj);
    }

    public void kill() {
        this.isRunning = false;
    }

    public TracerIF getTracer() {
        return this.tracer;
    }

    public void run() {
        try {
            this.init();
            while (this.isRunning) {
                Object obj = this.buffer.get();
                this.handleInput(obj);
                Thread.yield();
            }
        }
        catch (AdapterException aE) {
            aE.printStackTrace();
            System.exit(1);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    public void setConsumer(CmdConsumerIF consumer) {
        this.consumer = consumer;
    }

    public CmdConsumerIF getConsumer() {
        return this.consumer;
    }

    protected abstract void init();

    protected abstract void handleInput(Object var1) throws AdapterException;

    protected void logStartup() {
        this.tracer.info(AbstractAdapter.class, "Adapter {0} created", this.getName());
    }
}

