/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.core.resources;

import com.sap.sdt.server.core.resources.ResourceItem;
import com.sap.sdt.server.core.services.tool.ToolAdapterIF;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstConstants;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstException;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import java.util.ArrayList;
import java.util.Iterator;

public class ResourcePoolParser
implements SAPinstConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/core/resources/ResourcePoolParser.java#2 $";
    protected final ToolAdapterIF adapter;

    public ResourcePoolParser(ToolAdapterIF adapter) {
        this.adapter = adapter;
    }

    public void parse(XMLElementIF elem) throws SAPinstException {
        String version = "";
        try {
            version = elem.getAttrString("version");
        }
        catch (XMLException xmlE) {
            xmlE.printStackTrace();
        }
        if (version.equals("1.0")) {
            ArrayList itemList = new ArrayList(1024);
            Iterator it = elem.getSubElements();
            while (it.hasNext()) {
                XMLElementIF subElem = (XMLElementIF)it.next();
                String name = subElem.getName();
                if (name.equals("criteriapool") || !name.equals("resource")) continue;
                Iterator iter = subElem.getSubElements();
                while (iter.hasNext()) {
                    boolean ok = this.traverseArea((XMLElementIF)iter.next(), "", itemList);
                    if (ok) continue;
                    System.err.println("Error: ResourcePoolParser: reading resource pool aborted");
                    return;
                }
            }
            this.adapter.getResourcePool().addData(itemList);
        }
    }

    private boolean traverseArea(XMLElementIF areaElement, String domain, ArrayList itemList) {
        String subDomain;
        try {
            subDomain = areaElement.getAttrString("name");
        }
        catch (XMLException xmlE) {
            xmlE.printStackTrace();
            return false;
        }
        if (subDomain.length() == 0) {
            System.err.println("Error: area name must not be empty");
            return false;
        }
        if (domain.length() != 0) {
            domain = domain + '.';
        }
        domain = domain + subDomain;
        Iterator it = areaElement.getSubElements();
        while (it.hasNext()) {
            String type;
            String itemName;
            XMLElementIF subElem = (XMLElementIF)it.next();
            String elemName = subElem.getName();
            if (elemName.equals("area")) {
                if (this.traverseArea(subElem, domain, itemList)) continue;
                return false;
            }
            if (!elemName.equals("item")) continue;
            try {
                itemName = subElem.getAttrString("name");
                type = subElem.getAttrString("type");
            }
            catch (XMLException xmlE) {
                xmlE.printStackTrace();
                return false;
            }
            if (itemName.length() == 0) {
                System.err.println("Error: item name must not be empty");
                return false;
            }
            String criteria = null;
            try {
                criteria = subElem.getAttrString("criteria");
            }
            catch (XMLException xmlE) {
                // empty catch block
            }
            String content = subElem.getContentTrimmed();
            String id = domain + "." + itemName;
            ResourceItem item = new ResourceItem(id, type);
            item.setCriteria(criteria);
            item.setContent(content);
            itemList.add(item);
        }
        return true;
    }
}

