/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.core.resources;

import com.sap.sdt.server.core.resources.ResourceItem;
import com.sap.sdt.util.misc.Base64Codec;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ResourcePool {
    public static final String TYPE_HELP = "help";
    public static final String TYPE_TEXT = "text";
    public static final String TYPE_IMAGE = "image";
    private Map itemMap = null;

    public void addData(List resourceItemList) {
        if (this.itemMap == null) {
            this.itemMap = new HashMap(Math.max(resourceItemList.size(), 16));
        }
        Iterator it = resourceItemList.iterator();
        while (it.hasNext()) {
            ResourceItem item = (ResourceItem)it.next();
            boolean duplicate = this.itemMap.put(item.getID(), item) != null;
            if (!duplicate) continue;
            System.err.println("Warning: duplicate item ID = " + item.getID());
        }
    }

    public boolean containsID(String id) {
        if (this.itemMap == null) {
            return false;
        }
        return this.itemMap.containsKey(id);
    }

    public String resolveTextID(String id) {
        ResourceItem resourceItem;
        String content = null;
        content = this.itemMap == null ? "No text available.\nResource pool not initialized.\nUnable to resolve resource item ID = " + id : ((resourceItem = (ResourceItem)this.itemMap.get(id)) != null && (resourceItem.getType().equals(TYPE_HELP) || resourceItem.getType().equals(TYPE_TEXT)) ? resourceItem.getContent() : "No text available.\nUnknown resource item ID = " + id);
        return content;
    }

    public byte[] resolveImageID(String id) {
        String content;
        ResourceItem resourceItem;
        if (this.itemMap != null && (resourceItem = (ResourceItem)this.itemMap.get(id)) != null && resourceItem.getType().equals(TYPE_IMAGE) && (content = resourceItem.getContent()) != null && content.length() > 0) {
            byte[] imageData = Base64Codec.decode(content.toCharArray());
            return imageData;
        }
        return null;
    }
}

