/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.core.http;

import com.sap.sdt.server.core.http.HttpByteWorker;
import com.sap.sdt.server.core.http.HttpCharWorker;
import com.sap.sdt.server.core.http.HttpWorkerIF;
import com.sap.sdt.server.core.util.Debug;
import com.sap.sdt.server.core.util.DebugConstants;
import com.sap.sdt.server.core.util.ServerLog;
import com.sap.sdt.server.core.util.StackTrace;
import com.sap.sdt.server.core.util.SyncBuffer;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Hashtable;

public class HttpServer
implements Runnable,
DebugConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/core/http/HttpServer.java#2 $";
    public static final int ADDR_MODE_NAME = 0;
    public static final int ADDR_MODE_ADDRESS = 1;
    static Hashtable map = new Hashtable();
    private String indexFile = "index.html";
    static final int DEFAUFT_WORKERS = 3;
    static final int MAX_REQUEST = 5;
    private ServerSocket svrSocket;
    private String localHost;
    private int localPort;
    private String rootDir;
    private String encoding;
    private Thread engine;
    private HttpWorkerIF[] workers;
    private SyncBuffer syncBuffer;
    static int httpPort;
    static String httpRootDir;

    public static String getContentType(String extension) {
        String contentType = (String)map.get(extension);
        if (contentType != null) {
            return contentType;
        }
        return "text/plain";
    }

    public HttpServer(int port, String path) throws IOException {
        this(port, path, 3);
    }

    public HttpServer(int port, String path, int nWorkers) throws IOException {
        this(port, path, 3, 0);
    }

    public HttpServer(int port, String path, int nWorkers, int mode) throws IOException {
        this(port, path, 3, 0, null);
    }

    public HttpServer(int port, String path, int nWorkers, int mode, String enc) throws IOException {
        int nW = nWorkers > 3 ? nWorkers : 3;
        this.svrSocket = new ServerSocket(port);
        this.syncBuffer = new SyncBuffer(5);
        this.workers = new HttpWorkerIF[nW];
        this.setAddressMode(mode);
        this.localPort = port;
        this.rootDir = path;
        this.encoding = enc;
        for (int i = 0; i < nW; ++i) {
            this.workers[i] = this.encoding != null ? new HttpCharWorker(this) : new HttpByteWorker(this);
        }
        this.engine = new Thread(this);
        this.engine.setName("HttpServer");
        this.engine.start();
    }

    void putRequest(Socket socket) {
        this.syncBuffer.put(socket);
    }

    Socket getRequest() {
        return (Socket)this.syncBuffer.get();
    }

    public void run() {
        int reTries = 5;
        while (true) {
            try {
                while (true) {
                    this.putRequest(this.svrSocket.accept());
                    Thread.yield();
                    reTries = 5;
                }
            }
            catch (Exception e) {
                ServerLog.err("HttpServer: " + e.getMessage());
                ServerLog.err(StackTrace.getStackInfo(e));
                if (--reTries >= 0) continue;
                ServerLog.err("Shutdown HttpServer ...");
                return;
            }
            break;
        }
    }

    public void setAddressMode(int mode) throws UnknownHostException {
        InetAddress addr = InetAddress.getLocalHost();
        switch (mode) {
            case 1: {
                this.localHost = addr.getHostAddress();
                break;
            }
            default: {
                this.localHost = addr.getHostName();
            }
        }
    }

    public void setIndexFileName(String indexFile) {
        this.indexFile = indexFile;
    }

    public String getIndexFileName() {
        return this.indexFile;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public boolean isAccessible(String urlSuffix) {
        String name = urlSuffix.replace('/', File.separatorChar);
        if (name.startsWith(File.separator)) {
            name = name.substring(1);
        }
        File file = new File(this.getRootDir(), name);
        return file.canRead();
    }

    public URL getURL(String path) {
        try {
            String temp = path.startsWith(File.separator) ? path.substring(1) : path;
            temp = "/" + temp;
            return new URL("http", this.localHost, this.localPort, temp);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public URL getURLforAbsPath(String path) {
        if (!path.startsWith(this.getRootDir())) {
            return null;
        }
        String temp = path.length() > this.getRootDir().length() ? path.substring(this.getRootDir().length()) : "";
        return this.getURL(temp);
    }

    public boolean checkURL(URL url) {
        String relPath = url.getFile().replace('/', File.separatorChar);
        File file = new File(this.getRootDir(), relPath);
        Debug.print(36, "HttpServer.checkURL (" + url + " ) = " + file.canRead());
        return file.canRead();
    }

    public String concatURLPath(String prefix, String suffix) {
        int nSep = 0;
        if (prefix.endsWith("/")) {
            ++nSep;
        }
        if (suffix.startsWith("/")) {
            ++nSep;
        }
        String result = prefix;
        switch (nSep) {
            case 0: {
                result = result + "/";
                break;
            }
            case 2: {
                result = result.substring(0, result.length() - 1);
                break;
            }
        }
        result = result + suffix;
        return result;
    }

    public void shutdown() {
    }

    static void printUsage() {
        ServerLog.out("");
        ServerLog.out("valid options:");
        ServerLog.out("  -rootdir <root directory>]");
        ServerLog.out("  -port    <port number>]");
        ServerLog.out("");
        System.exit(1);
    }

    static void parseArguments(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if ("-port".compareTo(args[i]) == 0) {
                if (++i < args.length) {
                    try {
                        httpPort = Integer.parseInt(args[i]);
                    }
                    catch (NumberFormatException e) {
                        ServerLog.err("invalid http port number " + args[i]);
                        HttpServer.printUsage();
                    }
                    continue;
                }
                HttpServer.printUsage();
                continue;
            }
            if ("-rootdir".compareTo(args[i]) == 0) {
                if (++i < args.length) {
                    httpRootDir = args[i];
                    continue;
                }
                HttpServer.printUsage();
                continue;
            }
            if ("-debug".compareTo(args[i]) == 0) {
                if (++i < args.length) {
                    try {
                        Debug.setLevel(Integer.parseInt(args[i]));
                    }
                    catch (NumberFormatException e) {
                        ServerLog.err("invalid debug level " + args[i]);
                        HttpServer.printUsage();
                    }
                    continue;
                }
                HttpServer.printUsage();
                continue;
            }
            if ("-help".compareTo(args[i]) == 0) {
                HttpServer.printUsage();
                continue;
            }
            ServerLog.err("unknown option " + args[i]);
            HttpServer.printUsage();
        }
        if (httpPort == 0 || httpRootDir == null) {
            HttpServer.printUsage();
        }
    }

    public static void main(String[] args) {
        HttpServer httpServer = null;
        HttpServer.parseArguments(args);
        try {
            httpServer = new HttpServer(httpPort, httpRootDir);
        }
        catch (IOException e) {
            ServerLog.err(e.getMessage());
            System.exit(1);
        }
    }

    static {
        map.put("", "content/unknown");
        map.put(".uu", "application/octet-stream");
        map.put(".exe", "application/octet-stream");
        map.put(".ps", "application/postscript");
        map.put(".zip", "application/zip");
        map.put(".sh", "application/x-shar");
        map.put(".tar", "application/x-tar");
        map.put(".snd", "audio/basic");
        map.put(".au", "audio/basic");
        map.put(".wav", "audio/x-wav");
        map.put(".gif", "image/gif");
        map.put(".jpg", "image/jpeg");
        map.put(".jpeg", "image/jpeg");
        map.put(".htm", "text/html");
        map.put(".html", "text/html");
        map.put(".text", "text/plain");
        map.put(".c", "text/plain");
        map.put(".cc", "text/plain");
        map.put(".c++", "text/plain");
        map.put(".h", "text/plain");
        map.put(".pl", "text/plain");
        map.put(".txt", "text/plain");
        map.put(".java", "text/plain");
        map.put(".xml", "text/xml");
        map.put(".jnlp", "application/x-java-jnlp-file");
        httpPort = 0;
        httpRootDir = null;
    }
}

