/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.core.http;

import com.sap.sdt.server.core.http.HttpConstants;
import com.sap.sdt.server.core.http.HttpServer;
import com.sap.sdt.server.core.http.HttpWorkerIF;
import com.sap.sdt.server.core.util.Dater;
import com.sap.sdt.server.core.util.Debug;
import com.sap.sdt.server.core.util.DirInfo;
import com.sap.sdt.server.core.util.FileInfo;
import com.sap.sdt.server.core.util.ServerLog;
import com.sap.sdt.server.core.util.StackTrace;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.Date;

class HttpCharWorker
implements HttpWorkerIF,
HttpConstants,
Runnable {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/core/http/HttpCharWorker.java#2 $";
    private static final int ACTION_MISC = 0;
    private static final int ACTION_GET = 1;
    private static final int ACTION_HEAD = 2;
    private static final int TIMEOUT = 5000;
    private static final int BUFFER_SIZE = 2048;
    private static final String END_OF_LINE = "\r\n";
    private HttpServer server;
    private Thread engine;
    private char[] buffer;
    private InputStreamReader in;
    private OutputStreamWriter out;
    private String enc;

    HttpCharWorker(HttpServer server) {
        this.server = server;
        this.buffer = new char[2048];
        this.enc = server.getEncoding();
        this.engine = new Thread(this);
        this.engine.setName("HttpWorker");
        this.engine.start();
    }

    private int readLine(InputStreamReader in) throws IOException {
        int idx;
        for (idx = 0; idx < 2048; ++idx) {
            this.buffer[idx] = '\u0000';
        }
        int nCur = 0;
        int nSum = 0;
        boolean flag = true;
        block1: while (flag && nSum < 2048) {
            nCur = in.read(this.buffer, nSum, 2048 - nSum);
            if (nCur < 0) {
                return -1;
            }
            idx = nSum;
            nSum += nCur;
            while (idx < nSum) {
                if (this.buffer[idx] == '\n' || this.buffer[idx] == '\r') {
                    flag = false;
                    continue block1;
                }
                ++idx;
            }
        }
        return nSum;
    }

    private int extractActionType() {
        if (this.buffer[0] == 'G' && this.buffer[1] == 'E' && this.buffer[2] == 'T' && this.buffer[3] == ' ') {
            return 1;
        }
        if (this.buffer[0] == 'H' && this.buffer[1] == 'E' && this.buffer[2] == 'A' && this.buffer[3] == 'D' && this.buffer[4] == ' ') {
            return 2;
        }
        return 0;
    }

    private File extractFileName(int start, int bufLen) {
        int end;
        for (end = start; end < bufLen && this.buffer[end] != ' '; ++end) {
        }
        String fileName = new String(this.buffer, start, end - start);
        if ((fileName = fileName.replace('/', File.separatorChar)).startsWith(File.separator)) {
            fileName = fileName.substring(1);
        }
        return new File(this.server.getRootDir(), fileName);
    }

    private boolean printHeaders(File file, OutputStreamWriter out) throws IOException {
        int rCode = 0;
        String type = null;
        if (!file.exists()) {
            rCode = 404;
            this.send("HTTP/1.0 404 not found");
        } else {
            rCode = 200;
            this.send("HTTP/1.0 200 OK");
        }
        this.send(END_OF_LINE);
        this.send("Server: R/3 Upgrade Assistant");
        this.send(END_OF_LINE);
        this.send("Date: " + new Date());
        this.send(END_OF_LINE);
        if (rCode != 200) {
            return false;
        }
        if (!file.isDirectory()) {
            this.send("Content-length: " + file.length());
            this.send(END_OF_LINE);
            this.send("Last Modified: " + new Date(file.lastModified()));
            this.send(END_OF_LINE);
            String name = file.getName();
            int index = name.lastIndexOf(46);
            type = index > 0 ? HttpServer.getContentType(name.substring(index)) : "text/plain";
        } else {
            type = "text/html";
        }
        Debug.print(36, "HttpWorker.printHeaders (" + file.getAbsolutePath() + ", " + type + ")");
        this.send("Content-type: " + type);
        this.send(END_OF_LINE);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFile(File file, OutputStreamWriter out) throws IOException {
        int nRead;
        this.send(END_OF_LINE);
        if (file.isDirectory()) {
            this.listDirectory(file, out);
            return;
        }
        FileReader inStream = new FileReader(file.getAbsolutePath());
        while ((nRead = inStream.read(this.buffer)) > 0) {
            this.send(this.buffer, 0, nRead);
        }
        inStream.close();
    }

    private void sendFileNotFound(OutputStreamWriter out) throws IOException {
        this.send(END_OF_LINE);
        this.send(END_OF_LINE);
        this.send("Not Found. The requested resource was not found.");
    }

    private void listDirectory(File dir, OutputStreamWriter out) throws IOException {
        int i;
        String text = "<TITLE>Directory " + dir.getAbsolutePath() + "</TITLE><P>\n\n" + "<body bgcolor=\"#BBBBBB\">\n" + "<A HREF=\"..\">Parent Directory</A><BR>\n\n" + "<TABLE>\n";
        this.send(text);
        DirInfo dirInfo = new DirInfo(dir.getAbsolutePath(), 1);
        dirInfo.update();
        FileInfo[] dirs = dirInfo.getDirInfos();
        for (i = 0; i < dirs.length; ++i) {
            text = "  <TR> ";
            text = text + " <TH ALIGN=LEFT> <A HREF=\"" + dirs[i].getName();
            text = text + "/ \">" + dirs[i].getName() + "/ </A>";
            text = text + " <TD ALIGN=RIGHT> " + dirs[i].getSize();
            text = text + " <TD ALIGN=RIGHT> " + dirs[i].getDate();
            this.send(text);
        }
        FileInfo[] files = dirInfo.getFileInfos();
        for (i = 0; i < files.length; ++i) {
            text = "  <TR> ";
            text = text + " <TH ALIGN=LEFT> <A HREF=\"" + files[i].getName();
            text = text + "  \">" + files[i].getName() + "  </A>";
            text = text + " <TD ALIGN=RIGHT> " + files[i].getSize();
            text = text + " <TD ALIGN=RIGHT> " + files[i].getDate();
            this.send(text);
        }
        text = "</TABLE>\n\n";
        text = text + "<P><HR><BR><I>" + Dater.getDateTime() + "</I>\n";
        text = text + "</body>";
        this.send(text);
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Socket socket = this.server.getRequest();
                    this.handleRequest(socket);
                    socket.close();
                    Thread.yield();
                }
            }
            catch (Exception e) {
                ServerLog.err("HttpWorker: " + e.getMessage());
                ServerLog.err(StackTrace.getStackInfo(e));
                continue;
            }
            break;
        }
    }

    public void shutdown() {
    }

    private void send(String str) throws IOException {
        this.out.write(str, 0, str.length());
        this.out.flush();
    }

    private void send(char[] buffer, int off, int len) throws IOException {
        this.out.write(buffer, off, len);
        this.out.flush();
    }

    /*
     * WARNING - void declaration
     */
    private void handleRequest(Socket socket) throws IOException {
        void var3_3;
        File file;
        File index;
        File file2;
        if (this.enc != null) {
            this.in = new InputStreamReader(socket.getInputStream(), this.enc);
            this.out = new OutputStreamWriter(socket.getOutputStream(), this.enc);
        } else {
            this.in = new InputStreamReader(socket.getInputStream());
            this.out = new OutputStreamWriter(socket.getOutputStream());
        }
        socket.setSoTimeout(5000);
        socket.setTcpNoDelay(true);
        int nRead = this.readLine(this.in);
        if (nRead < 0) {
            return;
        }
        int action = this.extractActionType();
        switch (action) {
            case 1: {
                file2 = this.extractFileName(4, nRead);
                break;
            }
            case 2: {
                file2 = this.extractFileName(5, nRead);
                break;
            }
            default: {
                this.send("HTTP/1.0 405 unsupported method type: ");
                this.send(this.buffer, 0, 5);
                this.send(END_OF_LINE);
                this.out.flush();
                return;
            }
        }
        Debug.print(36, "HttpWorker.handleRequest (GET " + file2.getAbsolutePath() + " from " + socket.getInetAddress().getHostAddress() + ")");
        if (file2.isDirectory() && (index = new File(file2, this.server.getIndexFileName())).exists()) {
            file = index;
        }
        boolean ok = this.printHeaders(file, this.out);
        if (var3_3 == true) {
            if (ok) {
                this.sendFile(file, this.out);
            } else {
                this.sendFileNotFound(this.out);
            }
        }
    }
}

