/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.core.http;

import com.sap.sdt.server.core.http.HttpConstants;
import com.sap.sdt.server.core.http.HttpServer;
import com.sap.sdt.server.core.http.HttpWorkerIF;
import com.sap.sdt.server.core.util.Dater;
import com.sap.sdt.server.core.util.Debug;
import com.sap.sdt.server.core.util.DirInfo;
import com.sap.sdt.server.core.util.FileInfo;
import com.sap.sdt.server.core.util.ServerLog;
import com.sap.sdt.server.core.util.StackTrace;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Date;

class HttpByteWorker
implements HttpWorkerIF,
HttpConstants,
Runnable {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/core/http/HttpByteWorker.java#2 $";
    private static final int ACTION_MISC = 0;
    private static final int ACTION_GET = 1;
    private static final int ACTION_HEAD = 2;
    private static final int TIMEOUT = 5000;
    private static final int BUFFER_SIZE = 2048;
    private static final byte[] END_OF_LINE = new byte[]{13, 10};
    private HttpServer server;
    private Thread engine;
    private byte[] buffer;

    HttpByteWorker(HttpServer server) {
        this.server = server;
        this.buffer = new byte[2048];
        this.engine = new Thread(this);
        this.engine.setName("HttpWorker");
        this.engine.start();
    }

    private int readLine(InputStream in) throws IOException {
        int idx;
        for (idx = 0; idx < 2048; ++idx) {
            this.buffer[idx] = 0;
        }
        int nCur = 0;
        int nSum = 0;
        boolean flag = true;
        block1: while (flag && nSum < 2048) {
            nCur = in.read(this.buffer, nSum, 2048 - nSum);
            if (nCur < 0) {
                return -1;
            }
            idx = nSum;
            nSum += nCur;
            while (idx < nSum) {
                if (this.buffer[idx] == 10 || this.buffer[idx] == 13) {
                    flag = false;
                    continue block1;
                }
                ++idx;
            }
        }
        return nSum;
    }

    private int extractActionType() {
        if (this.buffer[0] == 71 && this.buffer[1] == 69 && this.buffer[2] == 84 && this.buffer[3] == 32) {
            return 1;
        }
        if (this.buffer[0] == 72 && this.buffer[1] == 69 && this.buffer[2] == 65 && this.buffer[3] == 68 && this.buffer[4] == 32) {
            return 2;
        }
        return 0;
    }

    private File extractFileName(int start, int bufLen) {
        int end;
        for (end = start; end < bufLen && this.buffer[end] != 32; ++end) {
        }
        String fileName = new String(this.buffer, start, end - start);
        if ((fileName = fileName.replace('/', File.separatorChar)).startsWith(File.separator)) {
            fileName = fileName.substring(1);
        }
        return new File(this.server.getRootDir(), fileName);
    }

    private boolean printHeaders(File file, PrintStream out) throws IOException {
        int rCode = 0;
        String type = null;
        if (!file.exists()) {
            rCode = 404;
            out.print("HTTP/1.0 404 not found");
        } else {
            rCode = 200;
            out.print("HTTP/1.0 200 OK");
        }
        out.write(END_OF_LINE);
        out.print("Server: R/3 Upgrade Assistant");
        out.write(END_OF_LINE);
        out.print("Date: " + new Date());
        out.write(END_OF_LINE);
        if (rCode != 200) {
            return false;
        }
        if (!file.isDirectory()) {
            out.print("Content-length: " + file.length());
            out.write(END_OF_LINE);
            out.print("Last Modified: " + new Date(file.lastModified()));
            out.write(END_OF_LINE);
            String name = file.getName();
            int index = name.lastIndexOf(46);
            type = index > 0 ? HttpServer.getContentType(name.substring(index)) : "text/plain";
        } else {
            type = "text/html";
        }
        Debug.print(36, "HttpWorker.printHeaders (" + file.getAbsolutePath() + ", " + type + ")");
        out.print("Content-type: " + type);
        out.write(END_OF_LINE);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFile(File file, PrintStream out) throws IOException {
        int nRead;
        out.write(END_OF_LINE);
        if (file.isDirectory()) {
            this.listDirectory(file, out);
            return;
        }
        FileInputStream inStream = new FileInputStream(file.getAbsolutePath());
        while ((nRead = ((InputStream)inStream).read(this.buffer)) > 0) {
            out.write(this.buffer, 0, nRead);
        }
        ((InputStream)inStream).close();
    }

    private void sendFileNotFound(PrintStream out) throws IOException {
        out.write(END_OF_LINE);
        out.write(END_OF_LINE);
        out.print("Not Found. The requested resource was not found.");
    }

    private void listDirectory(File dir, PrintStream out) throws IOException {
        int i;
        String text = "<TITLE>Directory " + dir.getAbsolutePath() + "</TITLE><P>\n\n" + "<body bgcolor=\"#BBBBBB\">\n" + "<A HREF=\"..\">Parent Directory</A><BR>\n\n" + "<TABLE>\n";
        out.println(text);
        DirInfo dirInfo = new DirInfo(dir.getAbsolutePath(), 1);
        dirInfo.update();
        FileInfo[] dirs = dirInfo.getDirInfos();
        for (i = 0; i < dirs.length; ++i) {
            text = "  <TR> ";
            text = text + " <TH ALIGN=LEFT> <A HREF=\"" + dirs[i].getName();
            text = text + "/ \">" + dirs[i].getName() + "/ </A>";
            text = text + " <TD ALIGN=RIGHT> " + dirs[i].getSize();
            text = text + " <TD ALIGN=RIGHT> " + dirs[i].getDate();
            out.println(text);
        }
        FileInfo[] files = dirInfo.getFileInfos();
        for (i = 0; i < files.length; ++i) {
            text = "  <TR> ";
            text = text + " <TH ALIGN=LEFT> <A HREF=\"" + files[i].getName();
            text = text + "  \">" + files[i].getName() + "  </A>";
            text = text + " <TD ALIGN=RIGHT> " + files[i].getSize();
            text = text + " <TD ALIGN=RIGHT> " + files[i].getDate();
            out.println(text);
        }
        text = "</TABLE>\n\n";
        text = text + "<P><HR><BR><I>" + Dater.getDateTime() + "</I>\n";
        text = text + "</body>";
        out.println(text);
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Socket socket = this.server.getRequest();
                    this.handleRequest(socket);
                    socket.close();
                    Thread.yield();
                }
            }
            catch (Exception e) {
                ServerLog.err("HttpWorker: " + e.getMessage());
                ServerLog.err(StackTrace.getStackInfo(e));
                continue;
            }
            break;
        }
    }

    public void shutdown() {
    }

    /*
     * WARNING - void declaration
     */
    private void handleRequest(Socket socket) throws IOException {
        void var5_5;
        void var4_6;
        File index;
        File file;
        BufferedInputStream in = new BufferedInputStream(socket.getInputStream());
        PrintStream out = new PrintStream(socket.getOutputStream());
        socket.setSoTimeout(5000);
        socket.setTcpNoDelay(true);
        int nRead = this.readLine(in);
        if (nRead < 0) {
            return;
        }
        int action = this.extractActionType();
        switch (action) {
            case 1: {
                file = this.extractFileName(4, nRead);
                break;
            }
            case 2: {
                file = this.extractFileName(5, nRead);
                break;
            }
            default: {
                out.print("HTTP/1.0 405 unsupported method type: ");
                out.write(this.buffer, 0, 5);
                out.write(END_OF_LINE);
                out.flush();
                return;
            }
        }
        Debug.print(36, "HttpWorker.handleRequest (GET " + file.getAbsolutePath() + " from " + socket.getInetAddress().getHostAddress() + ")");
        if (file.isDirectory() && (index = new File(file, this.server.getIndexFileName())).exists()) {
            file = index;
        }
        boolean ok = this.printHeaders((File)var4_6, out);
        if (var5_5 == true) {
            if (ok) {
                this.sendFile((File)var4_6, out);
            } else {
                this.sendFileNotFound(out);
            }
        }
    }
}

