/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.core.controls;

import com.sap.sdt.engine.core.communication.Configuration;
import com.sap.sdt.engine.core.controls.SDTControlFactoryIF;
import com.sap.sdt.engine.core.controls.SDTTextFieldIF;
import com.sap.sdt.server.core.controls.SDTCaptionComponent;

public class SDTTextField
extends SDTCaptionComponent {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/core/controls/SDTTextField.java#2 $";
    private boolean isUpperCase = false;
    private boolean isNumeric = false;
    private String regexp = null;
    private int minLength = 0;
    private int maxLength = 0;
    private int minValue = Integer.MIN_VALUE;
    private int maxValue = Integer.MAX_VALUE;
    private String text = null;

    public int getType() {
        return 7;
    }

    public void setText(String text) {
        this.text = text;
        if (this.delegate != null) {
            this.delegate().setText(text);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setUpperCase(boolean isUpperCase) {
        this.isUpperCase = isUpperCase;
    }

    public void setNumeric(boolean isNumeric) {
        this.isNumeric = isNumeric;
    }

    public void setRegexp(String regexp) {
        this.regexp = regexp;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    public void updateControl() {
        this.text = this.delegate().getText();
    }

    protected void createDelegate() {
        SDTControlFactoryIF factory = Configuration.getControlFactory();
        this.delegate = factory.createTextField();
        this.delegate().setText(this.text);
        this.delegate().setUpperCase(this.isUpperCase);
        this.delegate().setNumeric(this.isNumeric);
        this.delegate().setMaxLength(this.maxLength);
        this.delegate().setMinLength(this.minLength);
        this.delegate().setMaxValue(this.maxValue);
        this.delegate().setMinValue(this.minValue);
        this.delegate().setRegexp(this.regexp);
        super.createDelegate();
    }

    protected void deleteDelegate() {
        SDTControlFactoryIF factory = Configuration.getControlFactory();
        factory.delete(this.delegate);
    }

    private final SDTTextFieldIF delegate() {
        return (SDTTextFieldIF)this.delegate;
    }
}

