/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.core.controls;

import com.sap.sdt.engine.core.communication.Configuration;
import com.sap.sdt.engine.core.controls.SDTActionListenerIF;
import com.sap.sdt.engine.core.controls.SDTControlFactoryIF;
import com.sap.sdt.engine.core.controls.SDTTableIF;
import com.sap.sdt.engine.core.controls.table.SDTTableColumn;
import com.sap.sdt.engine.core.controls.table.SDTTableRow;
import com.sap.sdt.server.core.controls.SDTActionListener;
import com.sap.sdt.server.core.controls.SDTComponent;
import java.util.ArrayList;
import java.util.List;

public class SDTTable
extends SDTComponent {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/core/controls/SDTTable.java#2 $";
    private boolean areRowsFixed = false;
    private List columns = null;
    private List rows = null;
    private String caption = null;
    private char mnemonic = (char)35;
    private String action = null;
    private SDTActionListener listener = null;

    public SDTTable() {
        this.columns = new ArrayList();
        this.rows = new ArrayList();
    }

    public int getType() {
        return 15;
    }

    public void updateControl() {
        this.rows.clear();
        int rC = this.delegate().getRowCount();
        for (int i = 0; i < rC; ++i) {
            SDTTableRow row = this.delegate().getRow(i);
            this.rows.add(row);
        }
    }

    public void setCaption(String caption, char mnemonic) {
        this.caption = caption;
        this.mnemonic = mnemonic;
        if (this.delegate != null) {
            this.delegate().setCaption(caption, mnemonic);
        }
    }

    public void addColumn(SDTTableColumn column) {
        this.columns.add(column);
        if (this.delegate != null) {
            this.delegate().addColumn(column);
        }
    }

    public void addRow(SDTTableRow row) {
        this.rows.add(row);
        if (this.delegate != null) {
            this.delegate().addRow(row);
        }
    }

    public void removeRow(int index) {
        this.rows.remove(index);
        if (this.delegate != null) {
            this.delegate().removeRow(index);
        }
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public SDTTableRow getRow(int index) {
        return (SDTTableRow)this.rows.get(index);
    }

    public void enableAddRemove(boolean areRowsFixed) {
        this.areRowsFixed = areRowsFixed;
        if (this.delegate != null) {
            this.delegate().enableAddRemove(areRowsFixed);
        }
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public SDTTableColumn getColumn(int index) {
        return (SDTTableColumn)this.columns.get(index);
    }

    public void addBrowseListener(String action, SDTActionListener listener) {
        this.action = action;
        this.listener = listener;
        if (this.delegate != null) {
            this.delegate().addBrowseListener(action, (SDTActionListenerIF)listener.getDelegate());
        }
    }

    public Object getEditingCellValue() {
        return this.delegate().getEditingCellValue();
    }

    public void setEditingCellValue(Object value) {
        this.delegate().setEditingCellValue(value);
    }

    public SDTTableColumn getEditingColumn() {
        return this.delegate().getEditingColumn();
    }

    protected void createDelegate() {
        int i;
        SDTControlFactoryIF factory = Configuration.getControlFactory();
        this.delegate = factory.createTable();
        this.delegate().enableAddRemove(this.areRowsFixed);
        if (this.caption != null) {
            this.delegate().setCaption(this.caption, this.mnemonic);
        }
        if (this.action != null && this.listener != null) {
            this.delegate().addBrowseListener(this.action, (SDTActionListenerIF)this.listener.getDelegate());
        }
        for (i = 0; i < this.columns.size(); ++i) {
            this.delegate().addColumn((SDTTableColumn)this.columns.get(i));
        }
        for (i = 0; i < this.rows.size(); ++i) {
            this.delegate().addRow((SDTTableRow)this.rows.get(i));
        }
        super.createDelegate();
    }

    protected void deleteDelegate() {
    }

    private final SDTTableIF delegate() {
        return (SDTTableIF)this.delegate;
    }
}

