/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.core.controls;

import com.sap.sdt.engine.core.communication.Configuration;
import com.sap.sdt.engine.core.controls.SDTControlFactoryIF;
import com.sap.sdt.engine.core.controls.SDTControlIF;
import com.sap.sdt.engine.core.controls.SDTTabbedPaneIF;
import com.sap.sdt.server.core.controls.SDTComponent;
import com.sap.sdt.server.core.controls.SDTControl;
import java.util.ArrayList;
import java.util.List;

public class SDTTabbedPane
extends SDTComponent {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/core/controls/SDTTabbedPane.java#2 $";
    private List entries = new ArrayList();
    private int selectedIndex = 0;

    public void add(SDTControl control) {
        this.add(control, "");
    }

    public void add(SDTControl control, String title) {
        TabStripEntry entry = new TabStripEntry(control);
        entry.setTitle(title);
        this.entries.add(entry);
        if (this.delegate != null) {
            this.delegate().add((SDTControlIF)control.getDelegate(), title);
        }
    }

    public void remove(SDTControl control) {
        int index = this.getEntryIndex(control);
        if (index > -1) {
            this.entries.remove(index);
        }
        if (this.delegate != null) {
            this.delegate().remove((SDTControlIF)control.getDelegate());
        }
    }

    public void removeAll() {
        for (int i = 0; i < this.entries.size(); ++i) {
            this.entries.remove(i);
        }
        if (this.delegate != null) {
            this.delegate().removeAll();
        }
    }

    public void setTitleAt(String title, int index) {
        TabStripEntry entry = (TabStripEntry)this.entries.get(index);
        if (entry != null) {
            entry.setTitle(title);
        }
        if (this.delegate != null) {
            this.delegate().setTitleAt(index, title);
        }
    }

    public void setToolTipAt(String toolTip, int index) {
        TabStripEntry entry = (TabStripEntry)this.entries.get(index);
        if (entry != null) {
            entry.setToolTip(toolTip);
        }
        if (this.delegate != null) {
            this.delegate().setToolTipAt(index, toolTip);
        }
    }

    public void setEnabledAt(boolean enabled, int index) {
        TabStripEntry entry = (TabStripEntry)this.entries.get(index);
        if (entry != null) {
            entry.setEnabled(enabled);
        }
        if (this.delegate != null) {
            this.delegate().setEnabledAt(index, enabled);
        }
    }

    public void setSelectedIndex(int index) {
        this.selectedIndex = index;
        if (this.delegate != null) {
            this.delegate().setSelectedIndex(index);
        }
    }

    private final SDTTabbedPaneIF delegate() {
        return (SDTTabbedPaneIF)this.delegate;
    }

    public int getType() {
        return 25;
    }

    public void setLocked(boolean isLocked) {
        for (int i = 0; i < this.entries.size(); ++i) {
            TabStripEntry entry = (TabStripEntry)this.entries.get(i);
            SDTControl cntrl = entry.getControl();
            cntrl.setLocked(isLocked);
        }
    }

    public boolean validate() {
        boolean isValid = true;
        for (int i = 0; i < this.entries.size(); ++i) {
            TabStripEntry entry = (TabStripEntry)this.entries.get(i);
            SDTControl cntrl = entry.getControl();
            if (!cntrl.isEnabled()) continue;
            isValid &= cntrl.validate();
        }
        return isValid;
    }

    protected void createDelegate() {
        SDTControlFactoryIF factory = Configuration.getControlFactory();
        this.delegate = factory.createTabbedPane();
        for (int i = 0; i < this.entries.size(); ++i) {
            TabStripEntry entry = (TabStripEntry)this.entries.get(i);
            SDTControlIF cntrl = (SDTControlIF)entry.getControl().getDelegate();
            this.delegate().add(cntrl, entry.getTitle());
            this.delegate().setToolTipAt(i, entry.getToolTip());
            this.delegate().setEnabledAt(i, entry.isEnabled());
        }
        this.delegate().setSelectedIndex(this.selectedIndex);
        super.createDelegate();
    }

    private int getEntryIndex(SDTControl control) {
        for (int i = 0; i < this.entries.size(); ++i) {
            if (!((TabStripEntry)this.entries.get(i)).getControl().equals(control)) continue;
            return i;
        }
        return -1;
    }

    private class TabStripEntry {
        private String title = "";
        private String toolTip = "";
        private boolean isEnabled = true;
        private SDTControl control;

        public TabStripEntry(SDTControl control) {
            this.control = control;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        public String getTitle() {
            return this.title;
        }

        public String getToolTip() {
            return this.toolTip;
        }

        public void setEnabled(boolean b) {
            this.isEnabled = b;
        }

        public void setTitle(String string) {
            this.title = string;
        }

        public void setToolTip(String string) {
            this.toolTip = string;
        }

        public SDTControl getControl() {
            return this.control;
        }

        public void setControl(SDTControl control) {
            this.control = control;
        }
    }
}

