/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.core.controls;

import com.sap.sdt.engine.core.communication.Configuration;
import com.sap.sdt.engine.core.controls.SDTControlFactoryIF;
import com.sap.sdt.engine.core.controls.SDTStyledTextIF;
import com.sap.sdt.server.core.controls.SDTComponent;

public class SDTStyledText
extends SDTComponent {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/core/controls/SDTStyledText.java#2 $";
    private String text;
    private boolean selectable = false;
    private boolean bold = false;
    private boolean isScrollable = false;

    public SDTStyledText(boolean isScrollable) {
        this.isScrollable = isScrollable;
    }

    public int getType() {
        return 17;
    }

    public void setText(String text) {
        this.setText(text, false);
    }

    public void setText(String text, boolean bold) {
        this.text = text;
        this.bold = bold;
        if (this.delegate != null) {
            this.delegate().setText(text, bold);
        }
    }

    public void setSelectable(boolean isSelectable) {
        this.selectable = isSelectable;
        if (this.delegate != null) {
            this.delegate().setSelectable(this.selectable);
        }
    }

    public void updateControl() {
    }

    protected void createDelegate() {
        SDTControlFactoryIF factory = Configuration.getControlFactory();
        this.delegate = this.isScrollable ? factory.createScrollableStyledText() : factory.createStyledText();
        this.delegate().setSelectable(this.selectable);
        this.delegate().setText(this.text, this.bold);
        super.createDelegate();
    }

    protected void deleteDelegate() {
        SDTControlFactoryIF factory = Configuration.getControlFactory();
        factory.delete(this.delegate);
    }

    private final SDTStyledTextIF delegate() {
        return (SDTStyledTextIF)this.delegate;
    }
}

