/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.core.controls;

import com.sap.sdt.engine.core.communication.Configuration;
import com.sap.sdt.engine.core.controls.SDTControlFactoryIF;
import com.sap.sdt.engine.core.controls.SDTRoadMapIF;
import com.sap.sdt.server.core.controls.SDTComponent;
import java.util.ArrayList;
import java.util.List;

public class SDTRoadMap
extends SDTComponent {
    private List steps;
    private int activeIndex;

    public int getType() {
        return 27;
    }

    public void addStep(String stepName) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        this.steps.add(stepName);
        if (this.delegate != null) {
            this.delegate().addStep(stepName);
        }
    }

    public void addStep(String stepName, int index) {
        if (this.steps == null) {
            this.steps = new ArrayList();
        }
        this.steps.add(index, stepName);
        if (this.delegate != null) {
            this.delegate().addStep(stepName, index);
        }
    }

    public void setActive(String stepName) {
        this.activeIndex = this.steps.indexOf(stepName);
        if (this.delegate != null) {
            this.delegate().setActive(stepName);
        }
    }

    public void setActive(int step) {
        this.activeIndex = step;
        if (this.delegate != null) {
            this.delegate().setActive(step);
        }
    }

    public void setSteps(List steps) {
        this.steps = steps;
        if (this.delegate != null) {
            this.delegate().setSteps(steps);
        }
    }

    protected void createDelegate() {
        SDTControlFactoryIF factory = Configuration.getControlFactory();
        this.delegate = factory.createRoadMap();
        for (int i = 0; this.steps != null && i < this.steps.size(); ++i) {
            this.delegate().addStep((String)this.steps.get(i));
        }
        this.delegate().setActive(this.activeIndex);
        super.createDelegate();
    }

    private final SDTRoadMapIF delegate() {
        return (SDTRoadMapIF)this.delegate;
    }
}

