/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.core.controls;

import com.sap.sdt.engine.core.communication.Configuration;
import com.sap.sdt.engine.core.controls.SDTControlFactoryIF;
import com.sap.sdt.engine.core.controls.SDTProgressPanelIF;
import com.sap.sdt.server.core.controls.DefaultImage;
import com.sap.sdt.server.core.controls.SDTComponent;
import com.sap.sdt.server.core.resources.ResourceItem;
import com.sap.sdt.server.core.resources.ResourcePool;
import com.sap.sdt.server.ext.sapinst.controls.SAPinstConstants;
import com.sap.sdt.util.misc.Fifo;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;

public class SDTProgressPanel
extends SDTComponent
implements SAPinstConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/core/controls/SDTProgressPanel.java#4 $";
    private static final String DEFAULT_TEXT_ID = "gui.progress.DefaultText";
    private static final String DEFAULT_IMAGE_ID = "gui.progress.DefaultImage";
    private static final String DEFAULT_TEXT = "The phase is in progress.";
    private final ResourcePool resourcePool;
    private boolean syncProgressWithList = true;
    private int minValue = 0;
    private int maxValue = 0;
    private int currentValue = 0;
    private String[] itemList;
    private int currentIndex = 0;
    private boolean done = false;
    private String textID;
    private String text;
    private String imageID;
    private byte[] imageData;
    private long textDelay = 0L;
    private long imageDelay = 0L;
    private Fifo textFifo = new Fifo();
    private Fifo imageFifo = new Fifo();
    private Timer timer = new Timer();
    private TimerTask textTimeoutTask;
    private TimerTask imageTimeoutTask;
    private String lastImageID;
    private String lastTextID;

    public SDTProgressPanel(ResourcePool pool) {
        ResourceItem item;
        this.resourcePool = pool;
        if (!this.resourcePool.containsID(DEFAULT_TEXT_ID)) {
            item = new ResourceItem(DEFAULT_TEXT_ID, "text");
            item.setContent(DEFAULT_TEXT);
            this.resourcePool.addData(Arrays.asList(item));
            this.setTextImpl(DEFAULT_TEXT_ID);
        }
        if (!this.resourcePool.containsID(DEFAULT_IMAGE_ID)) {
            item = new ResourceItem(DEFAULT_IMAGE_ID, "image");
            item.setContent(DefaultImage.DATA);
            this.resourcePool.addData(Arrays.asList(item));
            this.setImageImpl(DEFAULT_IMAGE_ID);
        }
    }

    public int getType() {
        return 33;
    }

    protected void createDelegate() {
        SDTControlFactoryIF factory = Configuration.getControlFactory();
        this.delegate = factory.createProgressPanel();
        if (!this.syncProgressWithList) {
            this.delegate().setMinimum(this.minValue);
            this.delegate().setMaximum(this.maxValue);
            this.delegate().setCurrent(this.currentValue);
        }
        this.delegate().setProgressList(this.itemList);
        this.delegate().setProgressListIndex(this.currentIndex);
        this.delegate().setText(this.text);
        this.delegate().setImage(this.imageData);
    }

    protected void deleteDelegate() {
        SDTControlFactoryIF factory = Configuration.getControlFactory();
        factory.delete(this.delegate);
    }

    public void updateControl() {
    }

    public void setMinimum(int value) {
        this.minValue = value;
        this.syncProgressWithList = false;
        if (this.delegate != null) {
            this.delegate().setMinimum(this.minValue);
        }
    }

    public void setMaximum(int value) {
        this.maxValue = value;
        this.syncProgressWithList = false;
        if (this.delegate != null) {
            this.delegate().setMaximum(this.maxValue);
        }
    }

    public void setCurrent(int value) {
        this.syncProgressWithList = false;
        this.currentValue = value;
        if (this.delegate != null) {
            this.delegate().setCurrent(this.currentValue);
        }
    }

    public void setProgressList(String[] itemList) {
        this.itemList = itemList;
        if (this.delegate != null) {
            this.delegate().setProgressList(itemList);
        }
    }

    public void setProgressListIndex(int index) {
        this.currentIndex = index;
        if (this.delegate != null) {
            this.delegate().setProgressListIndex(index);
        }
    }

    public void done() {
        this.setCurrent(this.maxValue + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String id) {
        if (id != null && id.length() > 0) {
            if (this.textDelay > 0L) {
                Fifo fifo = this.textFifo;
                synchronized (fifo) {
                    if (this.textTimeoutTask != null) {
                        this.lastTextID = id;
                        this.textFifo.put(id);
                    } else {
                        this.lastTextID = id;
                        if (this.setTextImpl(id)) {
                            this.textTimeoutTask = new TextTimeoutTask();
                            this.timer.schedule(this.textTimeoutTask, this.textDelay);
                        }
                    }
                }
            } else {
                this.lastTextID = id;
                this.setTextImpl(id);
            }
        }
    }

    private boolean setTextImpl(String id) {
        this.textID = id;
        String _text = this.resourcePool.resolveTextID(this.textID);
        if (_text != null) {
            this.text = _text;
            if (this.delegate != null) {
                this.delegate().setText(this.text);
            }
            return true;
        }
        return false;
    }

    public String getText() {
        return this.lastTextID;
    }

    public void setTextDelay(long delay) {
        this.textDelay = delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(String id) {
        if (id != null && id.length() > 0) {
            if (this.imageDelay > 0L) {
                Fifo fifo = this.imageFifo;
                synchronized (fifo) {
                    if (this.imageTimeoutTask != null) {
                        this.lastImageID = id;
                        this.imageFifo.put(id);
                    } else {
                        this.lastImageID = id;
                        if (this.setImageImpl(id)) {
                            this.imageTimeoutTask = new ImageTimeoutTask();
                            this.timer.schedule(this.imageTimeoutTask, this.imageDelay);
                        }
                    }
                }
            } else {
                this.lastImageID = id;
                this.setImageImpl(id);
            }
        }
    }

    private boolean setImageImpl(String id) {
        this.imageID = id;
        byte[] data = this.resourcePool.resolveImageID(this.imageID);
        if (data != null) {
            this.imageData = data;
            if (this.delegate != null) {
                this.delegate().setImage(this.imageData);
            }
            return true;
        }
        return false;
    }

    public String getImage() {
        return this.lastImageID;
    }

    public void setImageDelay(long delay) {
        this.imageDelay = delay;
    }

    private final SDTProgressPanelIF delegate() {
        return (SDTProgressPanelIF)this.delegate;
    }

    private class ImageTimeoutTask
    extends TimerTask {
        private ImageTimeoutTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Fifo fifo = SDTProgressPanel.this.imageFifo;
            synchronized (fifo) {
                SDTProgressPanel.this.imageTimeoutTask = null;
                if (!SDTProgressPanel.this.imageFifo.isEmpty()) {
                    String id = (String)SDTProgressPanel.this.imageFifo.get();
                    SDTProgressPanel.this.setImageImpl(id);
                    SDTProgressPanel.this.imageTimeoutTask = new ImageTimeoutTask();
                    SDTProgressPanel.this.timer.schedule(SDTProgressPanel.this.imageTimeoutTask, SDTProgressPanel.this.imageDelay);
                }
            }
        }
    }

    private class TextTimeoutTask
    extends TimerTask {
        private TextTimeoutTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Fifo fifo = SDTProgressPanel.this.textFifo;
            synchronized (fifo) {
                SDTProgressPanel.this.textTimeoutTask = null;
                if (!SDTProgressPanel.this.textFifo.isEmpty()) {
                    String id = (String)SDTProgressPanel.this.textFifo.get();
                    SDTProgressPanel.this.setTextImpl(id);
                    SDTProgressPanel.this.textTimeoutTask = new TextTimeoutTask();
                    SDTProgressPanel.this.timer.schedule(SDTProgressPanel.this.textTimeoutTask, SDTProgressPanel.this.textDelay);
                }
            }
        }
    }
}

