/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.core.controls;

import com.sap.sdt.engine.core.communication.Configuration;
import com.sap.sdt.engine.core.controls.SDTControlFactoryIF;
import com.sap.sdt.engine.core.controls.SDTPasswordFieldIF;
import com.sap.sdt.server.core.controls.SDTCaptionComponent;
import java.util.Arrays;

public class SDTPasswordField
extends SDTCaptionComponent {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/core/controls/SDTPasswordField.java#2 $";
    private boolean isConfirm = false;
    private String password = null;
    private String confirmPassword = null;
    private int maxLength;
    private int minLength;

    public int getType() {
        return 8;
    }

    public void setText(String password) {
        this.password = password;
        if (this.delegate != null) {
            this.delegate().setText(password);
        }
    }

    public String getText() {
        return this.password;
    }

    public String getConfirmText() {
        return this.confirmPassword;
    }

    public void setConfirm(boolean isConfirm) {
        this.isConfirm = isConfirm;
        if (this.delegate != null) {
            this.delegate().setConfirm(isConfirm);
        }
    }

    public void updateControl() {
        char[] pwd = this.delegate().getText();
        this.password = new String(pwd);
        Arrays.fill(pwd, 'X');
        char[] confirm = this.delegate().getConfirmText();
        this.confirmPassword = new String(confirm);
        Arrays.fill(confirm, 'X');
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        if (this.delegate != null) {
            this.delegate().setMaxLength(maxLength);
        }
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
        if (this.delegate != null) {
            this.delegate().setMinLength(minLength);
        }
    }

    protected void createDelegate() {
        SDTControlFactoryIF factory = Configuration.getControlFactory();
        this.delegate = factory.createPasswordField();
        this.delegate().setText(this.password);
        this.delegate().setConfirm(this.isConfirm);
        this.delegate().setMaxLength(this.maxLength);
        this.delegate().setMinLength(this.minLength);
        super.createDelegate();
    }

    protected void deleteDelegate() {
        SDTControlFactoryIF factory = Configuration.getControlFactory();
        factory.delete(this.delegate);
    }

    private final SDTPasswordFieldIF delegate() {
        return (SDTPasswordFieldIF)this.delegate;
    }
}

