/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.core.controls;

import com.sap.sdt.engine.core.communication.Configuration;
import com.sap.sdt.engine.core.controls.SDTControlFactoryIF;
import com.sap.sdt.engine.core.controls.SDTControlIF;
import com.sap.sdt.engine.core.controls.SDTDynamicControlIF;
import com.sap.sdt.server.core.controls.SDTControl;

public class SDTDynamicControl
extends SDTControl {
    private SDTControl dynamicPart = null;
    private SDTControl staticPart = null;
    private boolean isEnabled = true;
    private int orientation;

    public void setOrientation(int orientation) {
        this.orientation = orientation;
        if (this.delegate != null) {
            this.delegate().setOrientation(orientation);
        }
    }

    public void setDynamicPart(SDTControl dynamicPart) {
        this.dynamicPart = dynamicPart;
        if (this.delegate != null) {
            this.delegate().setDynamicPart((SDTControlIF)dynamicPart.getDelegate());
        }
    }

    public void setStaticPart(SDTControl staticPart) {
        this.staticPart = staticPart;
        if (this.delegate != null) {
            this.delegate().setStaticPart((SDTControlIF)this.dynamicPart.getDelegate());
        }
    }

    public void showDynamicPart() {
        if (this.delegate != null) {
            this.delegate().showDynamicPart();
        }
    }

    public void hideDynamicPart() {
        if (this.delegate != null) {
            this.delegate().hideDynamicPart();
        }
    }

    public SDTControl getDynamicPart() {
        return this.dynamicPart;
    }

    protected void createDelegate() {
        SDTControlFactoryIF factory = Configuration.getControlFactory();
        this.delegate = factory.createDynamicControl();
        this.delegate().setStaticPart((SDTControlIF)this.staticPart.getDelegate());
        if (this.dynamicPart != null) {
            this.delegate().setDynamicPart((SDTControlIF)this.dynamicPart.getDelegate());
        }
        this.delegate().setEnabled(this.isEnabled);
        this.delegate().setOrientation(this.orientation);
        super.createDelegate();
    }

    private final SDTDynamicControlIF delegate() {
        return (SDTDynamicControlIF)this.delegate;
    }

    public int getType() {
        return 26;
    }

    public void refresh() {
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        if (this.delegate != null) {
            this.delegate().setEnabled(isEnabled);
        }
    }

    public void setLocked(boolean isLocked) {
        if (this.delegate != null) {
            this.delegate().setEnabled(this.isEnabled && !isLocked);
        }
    }

    public boolean validate() {
        return this.dynamicPart.validate() && this.staticPart.validate();
    }
}

