/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.core.controls;

import com.sap.sdt.engine.core.controls.SDTContainerIF;
import com.sap.sdt.engine.core.controls.SDTControlIF;
import com.sap.sdt.server.core.controls.SDTControl;
import java.util.Iterator;
import java.util.Vector;

public abstract class SDTContainer
extends SDTControl {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/core/controls/SDTContainer.java#2 $";
    protected Vector controls = new Vector();

    protected SDTContainer() {
        this.isEnabled = true;
    }

    public final void setEnabled(boolean isEnabled) {
    }

    public final void setLocked(boolean isLocked) {
        Iterator it = this.controls.iterator();
        while (it.hasNext()) {
            SDTControl control = (SDTControl)it.next();
            control.setLocked(isLocked);
        }
    }

    public final void refresh() {
        Iterator it = this.controls.iterator();
        while (it.hasNext()) {
            SDTControl control = (SDTControl)it.next();
            control.refresh();
        }
        if (this.delegate != null) {
            this.delegate().refresh();
        }
    }

    public void add(SDTControl control) {
        this.controls.add(control);
        if (this.delegate != null) {
            this.delegate().add((SDTControlIF)control.getDelegate());
        }
    }

    public void remove(SDTControl control) {
        this.controls.remove(control);
        if (this.delegate != null) {
            this.delegate().remove((SDTControlIF)control.getDelegate());
        }
        control.delete();
    }

    public void removeAll() {
        this.controls.removeAllElements();
        if (this.delegate != null) {
            this.delegate().removeAll();
        }
    }

    public Vector getControls() {
        return this.controls;
    }

    public final boolean validate() {
        boolean isValid = true;
        Iterator it = this.controls.iterator();
        while (it.hasNext()) {
            SDTControl control = (SDTControl)it.next();
            if (!control.isEnabled()) continue;
            isValid &= control.validate();
        }
        return isValid;
    }

    public void updateControl() {
        Iterator it = this.controls.iterator();
        while (it.hasNext()) {
            SDTControl control = (SDTControl)it.next();
            control.updateControl();
        }
    }

    protected void createDelegate() {
        Iterator it = this.controls.iterator();
        while (it.hasNext()) {
            SDTControl control = (SDTControl)it.next();
            this.delegate().add((SDTControlIF)control.getDelegate());
        }
        super.createDelegate();
    }

    protected void deleteDelegate() {
        Iterator it = this.controls.iterator();
        while (it.hasNext()) {
            SDTControl control = (SDTControl)it.next();
            this.delegate().remove((SDTControlIF)control.getDelegate());
            control.delete();
        }
    }

    private final SDTContainerIF delegate() {
        return (SDTContainerIF)this.delegate;
    }
}

