/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.core;

import com.sap.sdt.engine.core.communication.Configuration;
import com.sap.sdt.engine.core.communication.ServiceManager;
import com.sap.sdt.engine.core.services.GuiServiceIF;
import com.sap.sdt.server.core.ServerArguments;
import com.sap.sdt.server.core.ServerConstants;
import com.sap.sdt.server.core.ServerException;
import com.sap.sdt.server.core.ServerTraceIF;
import com.sap.sdt.server.core.admin.SDTServerAdmin;
import com.sap.sdt.server.core.config.LoggingConfigException;
import com.sap.sdt.server.core.config.Mapper;
import com.sap.sdt.server.core.config.ServerConfigException;
import com.sap.sdt.server.core.config.ServiceInstantiationException;
import com.sap.sdt.server.core.controls.ServerControlFactory;
import com.sap.sdt.trace.SapLoggingAdmin;
import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.JavaException;
import com.sap.sdt.util.xml.EntityResolverIF;
import com.sap.sdt.util.xml.XMLAdmin;
import com.sap.sdt.util.xml.XMLElementFactoryIF;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;

public final class SDTServer
implements EntityResolverIF,
ServerConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/core/SDTServer.java#2 $";
    private static final String SERVER_NAME = "SDTServer";
    private ServerArguments serverArgs = null;
    private SDTServerAdmin sA = null;
    private int port = -1;
    private String rootDir = null;
    private String logDir = null;
    private String libDir = null;
    private String propDir = null;
    private XMLElementFactoryIF xmlFactory = null;

    private SDTServer() {
    }

    public static void main(String[] args) {
        Thread.currentThread().setName(SERVER_NAME);
        try {
            new SDTServer().start(args);
        }
        catch (DiagException diagE) {
            SDTServer.exit("Fatal error: " + diagE.getMessage());
        }
    }

    public InputStream resolveEntity(String publicId, String systemId) throws XMLException {
        InputStream in = null;
        String file = "config" + File.separator + systemId;
        if (systemId.equals("configuration.dtd")) {
            in = SDTServer.class.getResourceAsStream(file);
        } else {
            try {
                in = new FileInputStream(this.rootDir + File.separator + file);
            }
            catch (FileNotFoundException fnfE) {
                throw new XMLException(new JavaException(fnfE));
            }
        }
        return in;
    }

    private void start(String[] args) throws ServerException {
        this.serverArgs = new ServerArguments();
        this.serverArgs.parseArgs(args);
        this.initServer(this.serverArgs);
        String rootDir = null;
        if (args[0].equals("-rootDir")) {
            rootDir = args[1];
        } else {
            SDTServer.exit("No root directory specified - exiting.");
        }
        this.configure(rootDir);
        this.sA.start(this.port);
    }

    private void initServer(ServerArguments serverArgs) throws ServerException {
    }

    private void configure(String rootDir) throws ServerException {
        this.rootDir = rootDir;
        this.configureXMLFactory();
        String configPath = "config" + File.separator + "configuration.xml";
        File configFile = new File(rootDir + File.separator + configPath);
        if (configFile.exists()) {
            this.configure(configFile);
        } else {
            this.configure(SDTServer.class.getResourceAsStream(configPath));
        }
    }

    private void configure(InputStream configStream) throws ServerException {
        try {
            this.configure(this.xmlFactory.createXMLElement(configStream));
        }
        catch (XMLException xmlE) {
            throw new ServerConfigException(xmlE);
        }
    }

    private void configure(File configFile) throws ServerException {
        try {
            this.configure(this.xmlFactory.createXMLElement(configFile));
        }
        catch (XMLException xmlE) {
            throw new ServerConfigException(xmlE);
        }
    }

    private void configure(XMLElementIF configuration) throws ServerException {
        if (!configuration.getName().equals("SDTServerConfiguration")) {
            throw new ServerConfigException(configuration);
        }
        Iterator it = configuration.getSubElements();
        block4: while (it.hasNext()) {
            XMLElementIF section = (XMLElementIF)it.next();
            int type = Mapper.getSectionType(section.getName());
            switch (type) {
                case 0: {
                    this.readGeneralSettings(section);
                    continue block4;
                }
                case 1: {
                    this.readServices(section);
                    continue block4;
                }
            }
            throw new ServerConfigException(section);
        }
    }

    private void configureXMLFactory() {
        try {
            this.xmlFactory = XMLAdmin.getNewElementFactory();
        }
        catch (XMLException xmlE) {
            xmlE.printStackTrace();
            System.exit(1);
        }
        this.xmlFactory.setChecksumming(false);
        this.xmlFactory.setIgnoreWhitespace(true);
        this.xmlFactory.setEntityResolver(this);
    }

    private void readGeneralSettings(XMLElementIF generalSettings) throws ServerException {
        Iterator it = generalSettings.getSubElements();
        block6: while (it.hasNext()) {
            XMLElementIF entry = (XMLElementIF)it.next();
            int type = Mapper.getEntryType(entry.getName());
            switch (type) {
                case 0: {
                    this.readPortNumber(entry);
                    continue block6;
                }
                case 1: {
                    this.readLogDir(entry);
                    continue block6;
                }
                case 2: {
                    this.readLibDir(entry);
                    continue block6;
                }
                case 3: {
                    this.readPropDir(entry);
                    continue block6;
                }
            }
            throw new ServerConfigException(entry);
        }
        this.generateDefaultPathes();
        this.initLogging();
        this.initConfig();
    }

    private void readPortNumber(XMLElementIF entry) throws ServerException {
        try {
            this.port = Integer.parseInt(entry.getContent());
        }
        catch (NumberFormatException nfE) {
            throw new ServerConfigException(entry, new JavaException(nfE));
        }
    }

    private void readLogDir(XMLElementIF entry) throws ServerException {
        this.logDir = entry.getContent();
        this.checkPath(this.logDir);
    }

    private void readLibDir(XMLElementIF entry) throws ServerException {
        this.libDir = entry.getContent();
        this.checkPath(this.libDir);
    }

    private void readPropDir(XMLElementIF entry) throws ServerException {
        this.propDir = entry.getContent();
        this.checkPath(this.propDir);
    }

    private void checkPath(String path) throws ServerException {
    }

    private void readServices(XMLElementIF serviceSettings) throws ServerException {
        Iterator it = serviceSettings.getSubElements();
        block3: while (it.hasNext()) {
            XMLElementIF entry = (XMLElementIF)it.next();
            int type = Mapper.getEntryType(entry.getName());
            switch (type) {
                case 4: {
                    this.readService(entry);
                    continue block3;
                }
            }
            throw new ServerConfigException(entry);
        }
    }

    private void readService(XMLElementIF entry) throws ServerException {
        String name = null;
        String cls = null;
        String jar = null;
        String config = null;
        GuiServiceIF gS = null;
        try {
            name = entry.getAttrString("name");
        }
        catch (XMLException xmlE) {
            throw new ServerConfigException(entry, xmlE);
        }
        Iterator it = entry.getSubElements();
        while (it.hasNext()) {
            XMLElementIF elem = (XMLElementIF)it.next();
            int type = Mapper.getEntryType(elem.getName());
            switch (type) {
                case 5: {
                    cls = elem.getContent();
                    break;
                }
                case 7: {
                    jar = elem.getContent();
                    break;
                }
                case 6: {
                    config = elem.getContent();
                    break;
                }
            }
        }
        try {
            gS = (GuiServiceIF)Class.forName(cls).newInstance();
        }
        catch (InstantiationException iE) {
            throw new ServiceInstantiationException(cls, new JavaException(iE));
        }
        catch (IllegalAccessException iaE) {
            throw new ServiceInstantiationException(cls, new JavaException(iaE));
        }
        catch (ClassNotFoundException cnfE) {
            throw new ServiceInstantiationException(cls, new JavaException(cnfE));
        }
        XMLElementIF serviceConfiguration = null;
        try {
            serviceConfiguration = this.xmlFactory.createXMLElement(this.rootDir + File.separator + "config" + File.separator + config);
        }
        catch (XMLException xmlE) {
            throw new ServerConfigException(entry, xmlE);
        }
        gS.configure(serviceConfiguration);
        ServiceManager.register(name, gS.getInterface(), gS);
    }

    private void generateDefaultPathes() {
        if (this.logDir == null) {
            this.logDir = this.rootDir + File.separator + "log";
        }
        if (this.libDir == null) {
            this.libDir = this.rootDir + File.separator + "lib";
        }
        if (this.propDir == null) {
            this.propDir = this.rootDir + File.separator + "properties";
        }
    }

    private void initLogging() throws ServerException {
        String logProps = this.propDir + File.separator + "logging.properties";
        File propFile = new File(logProps);
        if (!propFile.exists()) {
            FileNotFoundException fnfE = new FileNotFoundException(logProps);
            throw new LoggingConfigException(new JavaException(fnfE));
        }
        Properties prop = new Properties();
        File log = new File(this.logDir);
        try {
            String logDir = log.getAbsolutePath() + File.separator;
            prop.load(new FileInputStream(propFile));
            prop.setProperty("log[engine].pattern", logDir + "engine.trc");
            prop.setProperty("log[server].pattern", logDir + "server.trc");
            prop.setProperty("log[SAPinst].pattern", logDir + "adapter.sapinst.%u.trc");
            SapLoggingAdmin.configure(prop);
        }
        catch (Exception e) {
            throw new LoggingConfigException(new JavaException(e));
        }
    }

    private void initConfig() {
        Configuration.setType(1);
        Configuration.setTracer(ServerTraceIF.trc);
        this.sA = new SDTServerAdmin();
        Configuration.setServerAdmin(this.sA);
        Configuration.setControlFactory(ServerControlFactory.instance());
    }

    private static void exit(String msg) {
        System.err.println(msg);
        System.exit(1);
    }
}

