/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.ext.sapinst.swing.controls.stepbrowser;

import com.sap.sdt.engine.ext.sapinst.controls.SAPinstStepBrowserNode;
import com.sap.sdt.gui.core.resources.ResourceConstants;
import com.sap.sdt.gui.core.swing.ui.GuiAction;
import com.sap.sdt.gui.ext.sapinst.images.ImageHolder;
import com.sap.sdt.gui.ext.sapinst.swing.controls.stepbrowser.AbstractTreeNode;
import com.sap.sdt.gui.ext.sapinst.swing.controls.stepbrowser.ComponentTreeNode;
import com.sap.sdt.gui.ext.sapinst.swing.controls.stepbrowser.RootTreeNode;
import com.sap.sdt.gui.ext.sapinst.swing.controls.stepbrowser.StepBrowserStatusControl;
import com.sap.sdt.gui.ext.sapinst.swing.controls.stepbrowser.StepBrowserTreeCellRenderer;
import com.sap.sdt.gui.ext.sapinst.swing.controls.stepbrowser.StepBrowserTreeModel;
import com.sap.sdt.gui.ext.sapinst.swing.controls.stepbrowser.StepDialogTreeNode;
import com.sap.sdt.gui.ext.sapinst.swing.controls.stepbrowser.StepInstTreeNode;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class StepBrowserTreeControl
extends JTree
implements TreeSelectionListener,
TreeModelListener,
TreeExpansionListener,
ActionListener,
MouseListener,
ResourceConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/ext/sapinst/swing/controls/stepbrowser/StepBrowserTreeControl.java#2 $";
    private String version = "Tree";
    private JPopupMenu popUp = new JPopupMenu();
    private GuiAction item_reset = null;
    private GuiAction item_repeat = null;
    private GuiAction item_skip = null;
    private GuiAction item_append_dlgup = null;
    private GuiAction item_append_dlgdown = null;
    private GuiAction item_append_instup = null;
    private GuiAction item_append_instdown = null;
    private GuiAction item_remove_step = null;
    private StepBrowserTreeModel model;
    private TreeSelectionModel selectionmodel;
    private StepBrowserStatusControl status;
    private SAPinstStepBrowserNode data;
    private boolean show_display = true;
    private static final int COLLAPSE_ALL = 0;
    private static final int EXPAND_ALL = 1;
    private static final int EXPAND_ERRORS = 2;
    private static final int ALL_STEPS = 2;
    private static final int DLG_STEPS = 0;
    private static final int INST_STEPS = 1;
    private int steps = 2;
    private ArrayList expandNodes = new ArrayList();
    private GuiAction back;
    private GuiAction forward;
    ArrayList result;
    int br;
    private ArrayList expandstatus = new ArrayList();

    public StepBrowserTreeControl(StepBrowserStatusControl status) {
        this.status = status;
        this.setBackground(new Color(255, 255, 245));
        this.setRootVisible(true);
        this.addTreeSelectionListener(this);
        this.addMouseListener(this);
        this.addTreeExpansionListener(this);
        this.initPopupItems();
    }

    private void initPopupItems() {
        this.item_reset = new GuiAction(this, "RESET_STEP", ImageHolder.STEP_BROWSER_POPUP_RESET_ICON);
        this.item_repeat = new GuiAction(this, "REPEAT_STEP", ImageHolder.STEP_BROWSER_POPUP_REPEAT_ICON);
        this.item_skip = new GuiAction(this, "SKIP_STEP", ImageHolder.STEP_BROWSER_POPUP_SKIP_ICON);
        this.item_append_dlgup = new GuiAction(this, "ADD_DIALOG_UP", ImageHolder.STEP_BROWSER_POPUP_DLG_UP_ICON);
        this.item_append_dlgdown = new GuiAction(this, "ADD_DIALOG_DOWN", ImageHolder.STEP_BROWSER_POPUP_DLG_DOWN_ICON);
        this.item_append_instup = new GuiAction(this, "ADD_INST_EXIT_STEP_UP", ImageHolder.STEP_BROWSER_POPUP_INST_UP_ICON);
        this.item_append_instdown = new GuiAction(this, "ADD_INST_EXIT_STEP_DOWN", ImageHolder.STEP_BROWSER_POPUP_INST_DOWN_ICON);
        this.item_remove_step = new GuiAction(this, "REMOVE_STEP", ImageHolder.STEP_BROWSER_POPUP_RESET_ICON);
    }

    public AbstractTreeNode get_SelectedNode() {
        TreePath tP = this.getSelectionPath();
        if (tP != null) {
            AbstractTreeNode node = (AbstractTreeNode)tP.getLastPathComponent();
            return node;
        }
        return null;
    }

    public void setTreeData(SAPinstStepBrowserNode root) {
        this.setCellRenderer(new StepBrowserTreeCellRenderer());
        RootTreeNode root_to_add = new RootTreeNode(root);
        this.data = root;
        this.model = new StepBrowserTreeModel((TreeNode)root_to_add, this.data);
        this.setModel(this.model);
        List children = root.getChildren();
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                this.addNode((SAPinstStepBrowserNode)children.get(i), root_to_add);
            }
        }
        this.expandPath(new TreePath(root_to_add.getPath()));
        this.updateExpansion();
    }

    private void addNode(SAPinstStepBrowserNode node, AbstractTreeNode parent) {
        int type = node.getType();
        AbstractTreeNode node_to_add = null;
        switch (type) {
            case 1: {
                node_to_add = new ComponentTreeNode(node);
                break;
            }
            case 2: {
                node_to_add = new StepDialogTreeNode(node);
                break;
            }
            case 3: {
                node_to_add = new StepInstTreeNode(node);
                break;
            }
        }
        if (node_to_add != null && parent != null) {
            this.model.insertNodeInto(node_to_add, parent, parent.getChildCount());
            List children = node.getChildren();
            if (children != null) {
                for (int i = 0; i < children.size(); ++i) {
                    this.addNode((SAPinstStepBrowserNode)children.get(i), node_to_add);
                }
            }
        }
    }

    private void build_PopUp() {
        this.popUp = new JPopupMenu();
        if (this.getSelectionCount() > 1) {
            this.popUp.add(this.item_reset);
            this.popUp.add(this.item_repeat);
            this.popUp.add(this.item_skip);
            return;
        }
        AbstractTreeNode tree_node = this.get_SelectedNode();
        if (tree_node == null) {
            return;
        }
        DefaultMutableTreeNode tree_parent = (DefaultMutableTreeNode)tree_node.getParent();
        if (tree_node.getType() == 2 || tree_node.getType() == 3) {
            if (tree_node.getCondition() == 3) {
                this.popUp.add(this.item_remove_step);
            } else {
                int condition = tree_node.getCondition();
                switch (condition) {
                    case 0: {
                        this.popUp.add(this.item_repeat);
                        this.popUp.add(this.item_skip);
                        break;
                    }
                    case 1: {
                        this.popUp.add(this.item_reset);
                        this.popUp.add(this.item_skip);
                        break;
                    }
                    case 2: {
                        this.popUp.add(this.item_reset);
                        this.popUp.add(this.item_repeat);
                    }
                }
                if (tree_parent.getFirstChild().equals(tree_node)) {
                    if (tree_node.getType() == 3) {
                        if (this.getSteps() != 1) {
                            this.popUp.add(this.item_append_dlgup);
                        }
                        if (this.getSteps() != 0) {
                            this.popUp.add(this.item_append_instup);
                        }
                        if (this.getSteps() != 0) {
                            this.popUp.add(this.item_append_instdown);
                        }
                    } else {
                        if (this.getSteps() != 1) {
                            this.popUp.add(this.item_append_dlgup);
                        }
                        if (!tree_parent.getLastChild().equals(tree_node)) {
                            AbstractTreeNode new_temp = (AbstractTreeNode)tree_parent.getChildAfter(tree_node);
                            if (new_temp.getType() == 3) {
                                if (this.getSteps() != 1) {
                                    this.popUp.add(this.item_append_dlgdown);
                                }
                                if (this.getSteps() != 0) {
                                    this.popUp.add(this.item_append_instdown);
                                }
                            } else if (this.getSteps() != 1) {
                                this.popUp.add(this.item_append_dlgdown);
                            }
                        } else {
                            if (this.getSteps() != 1) {
                                this.popUp.add(this.item_append_dlgdown);
                            }
                            if (this.getSteps() != 0) {
                                this.popUp.add(this.item_append_instdown);
                            }
                        }
                    }
                    return;
                }
                if (tree_parent.getLastChild().equals(tree_node)) {
                    if (tree_node.getType() == 3) {
                        AbstractTreeNode new_temp = (AbstractTreeNode)tree_parent.getChildBefore(tree_node);
                        if (new_temp.getType() == 3) {
                            if (this.getSteps() != 1) {
                                this.popUp.add(this.item_append_instup);
                            }
                        } else {
                            if (this.getSteps() != 1) {
                                this.popUp.add(this.item_append_dlgup);
                            }
                            if (this.getSteps() != 0) {
                                this.popUp.add(this.item_append_instup);
                            }
                        }
                        this.popUp.add(this.item_append_instdown);
                    } else {
                        if (this.getSteps() != 1) {
                            this.popUp.add(this.item_append_dlgup);
                            this.popUp.add(this.item_append_dlgdown);
                        }
                        if (this.getSteps() != 0) {
                            this.popUp.add(this.item_append_instdown);
                        }
                    }
                    return;
                }
                AbstractTreeNode new_before = (AbstractTreeNode)tree_parent.getChildBefore(tree_node);
                AbstractTreeNode new_after = (AbstractTreeNode)tree_parent.getChildAfter(tree_node);
                if (tree_node.getType() == 3) {
                    if (new_before.getType() == 3) {
                        if (this.getSteps() != 0) {
                            this.popUp.add(this.item_append_instup);
                        }
                    } else {
                        if (this.getSteps() != 1) {
                            this.popUp.add(this.item_append_dlgup);
                        }
                        if (this.getSteps() != 0) {
                            this.popUp.add(this.item_append_instup);
                        }
                    }
                    if (this.getSteps() != 1) {
                        this.popUp.add(this.item_append_instdown);
                    }
                } else {
                    if (this.getSteps() != 1) {
                        this.popUp.add(this.item_append_dlgup);
                    }
                    if (new_after.getType() == 3) {
                        if (this.getSteps() != 1) {
                            this.popUp.add(this.item_append_dlgdown);
                        }
                        if (this.getSteps() != 0) {
                            this.popUp.add(this.item_append_instdown);
                        }
                    } else if (this.getSteps() != 1) {
                        this.popUp.add(this.item_append_dlgdown);
                    }
                }
            }
        } else {
            this.popUp.add(this.item_reset);
            this.popUp.add(this.item_repeat);
            this.popUp.add(this.item_skip);
        }
    }

    private void showNodeInfo(AbstractTreeNode node) {
        this.status.clear_Textpane();
        if (node.getType() == 3 || node.getType() == 2) {
            this.status.insert_Line_withPrefix("Name:   ", node.getData().getName(), 1, 1);
            this.status.insert_Line_withPrefix("Type:   ", node.getType() == 3 ? "dialog-step" : "isnt-step", 1, 1);
            this.status.insert_Line_withPrefix("State:  ", node.getStateToString(), 1, 2);
            this.status.insert_Line_withPrefix("Description: ", node.getData().getDescription(), 1, 3);
        } else if (node.getType() == 1) {
            this.status.insert_Line_withPrefix("Tech-Name:     ", node.getData().getTech_name(), 1, 1);
            this.status.insert_Line_withPrefix("Display-Name:  ", node.getName(), 1, 1);
            this.status.insert_Line_withPrefix("ID:            ", node.getData().getId(), 1, 1);
            this.status.insert_Line_withPrefix("State:         ", node.getStateToString(), 1, 2);
            this.status.insert_Line_withPrefix("Description: ", node.getData().getDescription(), 1, 3);
        } else if (node.getType() == 0) {
            this.status.insert_Line_withPrefix("Version: ", node.getData().getVersion(), 1, 3);
        }
    }

    public boolean expandERRORNodes() {
        this.collapseAll();
        return this.expandERRORNodes((AbstractTreeNode)this.getModel().getRoot());
    }

    public boolean expandERRORNodes(AbstractTreeNode parent) {
        boolean result = false;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            AbstractTreeNode node = (AbstractTreeNode)parent.getChildAt(i);
            if (node.getType() == 1 && node.getState() == 0) {
                this.expandPath(new TreePath(node.getPath()));
                result = true;
            }
            this.expandERRORNodes(node);
        }
        return result;
    }

    private void collapseAll(AbstractTreeNode parent) {
        TreeModel model = this.getModel();
        Object root = model.getRoot();
        if (root != null) {
            this.traverseTree(model, root, new TreePath(root), false);
            this.expandRow(0);
        }
        this.grabFocus();
    }

    private void traverseTree(TreeModel model, Object node, TreePath path, boolean doExpand) {
        try {
            int nChildren = model.getChildCount(node);
            if (nChildren > 0) {
                for (int i = 0; i < nChildren; ++i) {
                    Object child = model.getChild(node, i);
                    this.traverseTree(model, child, path.pathByAddingChild(child), doExpand);
                }
            }
            if (doExpand) {
                this.expandPath(path);
            } else {
                this.collapsePath(path);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void collapseAll() {
        this.collapseAll((AbstractTreeNode)this.getModel().getRoot());
    }

    public void expandAll() {
        this.expandAll((AbstractTreeNode)this.getModel().getRoot());
    }

    private void expandAll(AbstractTreeNode parent) {
        TreeModel model = this.getModel();
        Object root = model.getRoot();
        if (root != null) {
            this.traverseTree(model, root, new TreePath(root), true);
            this.expandRow(0);
        }
        this.grabFocus();
    }

    public void show_componetDisplayname() {
        this.init_Search();
        this.show_componetDisplayname((AbstractTreeNode)this.getModel().getRoot());
        this.repaint();
    }

    private void show_componetDisplayname(AbstractTreeNode parent) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            AbstractTreeNode node = (AbstractTreeNode)parent.getChildAt(i);
            if (node.getType() == 1) {
                node.setName(node.getData().getName());
            }
            this.show_componetDisplayname(node);
        }
    }

    public void show_componetTechname() {
        this.init_Search();
        this.showComponentTechName((AbstractTreeNode)this.getModel().getRoot());
        this.repaint();
    }

    private void showComponentTechName(AbstractTreeNode parent) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            AbstractTreeNode node = (AbstractTreeNode)parent.getChildAt(i);
            if (node.getType() == 1) {
                node.setName(node.getData().getTech_name());
            }
            this.showComponentTechName(node);
        }
    }

    public void show_dlgSteps() {
        this.init_Search();
        this.removeAll();
        this.setTreeData(this.model.getData());
        this.show_dlgSteps((AbstractTreeNode)this.getModel().getRoot());
        this.setSteps(0);
        this.updateExpansion();
        this.repaint();
    }

    private void show_dlgSteps(AbstractTreeNode parent) {
        for (int i = parent.getChildCount() - 1; i >= 0; --i) {
            AbstractTreeNode node = (AbstractTreeNode)parent.getChildAt(i);
            this.show_dlgSteps(node);
            if (node.getType() != 3) continue;
            this.model.removeNodeFromParent(node);
        }
    }

    public void show_instSteps() {
        this.init_Search();
        this.removeAll();
        this.setTreeData(this.model.getData());
        this.show_instSteps((AbstractTreeNode)this.getModel().getRoot());
        this.setSteps(1);
        this.repaint();
    }

    private void show_instSteps(AbstractTreeNode parent) {
        for (int i = parent.getChildCount() - 1; i >= 0; --i) {
            AbstractTreeNode node = (AbstractTreeNode)parent.getChildAt(i);
            this.show_instSteps(node);
            if (node.getType() != 2) continue;
            this.model.removeNodeFromParent(node);
        }
    }

    public void show_allSteps() {
        this.init_Search();
        this.removeAll();
        this.setTreeData(this.model.getData());
        this.setSteps(2);
    }

    private void expandPath_(TreePath path, AbstractTreeNode root) {
        TreePath compare_path = new TreePath(root.getPath());
        if (compare_path.toString().equals(path.toString())) {
            this.expandPath(compare_path);
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.expandPath_(path, (AbstractTreeNode)root.getChildAt(i));
        }
    }

    private void updateExpansion() {
        for (int i = 0; i < this.expandNodes.size(); ++i) {
            TreePath temp = (TreePath)this.expandNodes.get(i);
            this.expandPath_(temp, (AbstractTreeNode)this.model.getRoot());
        }
    }

    private void init_Search() {
        if (this.back != null) {
            this.back.setEnabled(false);
        }
        if (this.forward != null) {
            this.forward.setEnabled(false);
        }
    }

    public void init_searchButtons(GuiAction back, GuiAction forward) {
        this.back = back;
        this.forward = forward;
        back.setEnabled(false);
        forward.setEnabled(false);
    }

    public void search(String str) {
        this.result = new ArrayList();
        this.br = 0;
        this.model.searchNodes((AbstractTreeNode)this.model.getRoot(), str, this.result);
        if (this.result.size() > 1) {
            this.back.setEnabled(false);
            this.forward.setEnabled(true);
            AbstractTreeNode node = (AbstractTreeNode)this.result.get(0);
            this.setSelectionPath(new TreePath(node.getPath()));
        } else if (this.result.size() > 0) {
            this.back.setEnabled(false);
            this.forward.setEnabled(false);
            AbstractTreeNode node = (AbstractTreeNode)this.result.get(0);
            this.setSelectionPath(new TreePath(node.getPath()));
        } else {
            this.back.setEnabled(false);
            this.forward.setEnabled(false);
        }
    }

    public void next_Result() {
        ++this.br;
        AbstractTreeNode node = (AbstractTreeNode)this.result.get(this.br);
        this.setSelectionPath(new TreePath(node.getPath()));
        this.back.setEnabled(true);
        if (this.br + 1 > this.result.size() - 1) {
            this.forward.setEnabled(false);
        }
    }

    public void previous_Result() {
        --this.br;
        AbstractTreeNode node = (AbstractTreeNode)this.result.get(this.br);
        this.setSelectionPath(new TreePath(node.getPath()));
        this.forward.setEnabled(true);
        if (this.br - 1 < 0) {
            this.back.setEnabled(false);
        }
    }

    public void repeat_all_steps() {
        this.repeat_all_steps((AbstractTreeNode)this.model.getRoot());
        this.repaint();
        this.build_PopUp();
    }

    private void repeat_all_steps(AbstractTreeNode parent) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            AbstractTreeNode node = (AbstractTreeNode)parent.getChildAt(i);
            if (node.getType() == 2 || node.getType() == 3) {
                node.setCondition(1);
            }
            this.repeat_all_steps(node);
        }
        this.build_PopUp();
    }

    public void skip_all_steps() {
        this.skip_all_steps((AbstractTreeNode)this.model.getRoot());
        this.repaint();
        this.build_PopUp();
    }

    private void skip_all_steps(AbstractTreeNode parent) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            AbstractTreeNode node = (AbstractTreeNode)parent.getChildAt(i);
            if (node.getType() == 2 || node.getType() == 3) {
                node.setCondition(2);
            }
            this.skip_all_steps(node);
        }
    }

    public void reset_all_steps() {
        this.reset_all_steps((AbstractTreeNode)this.getModel().getRoot());
        this.repaint();
        this.build_PopUp();
    }

    private void reset_all_steps(AbstractTreeNode parent) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            AbstractTreeNode node = (AbstractTreeNode)parent.getChildAt(i);
            if (node.getType() == 2 || node.getType() == 3) {
                node.setCondition(0);
            }
            this.reset_all_steps(node);
        }
    }

    public void reset_Node(AbstractTreeNode node) {
        if (node.isLeaf()) {
            node.setCondition(0);
        } else {
            this.setComponentCondition(node, 0);
        }
        this.repaint();
        this.build_PopUp();
    }

    private void setComponentCondition(AbstractTreeNode parent, int condition) {
        parent.setCondition(condition);
        for (int i = 0; i < parent.getChildCount(); ++i) {
            AbstractTreeNode node = (AbstractTreeNode)parent.getChildAt(i);
            if (node.getType() == 2 || node.getType() == 3) {
                node.setCondition(condition);
            }
            this.setComponentCondition(node, condition);
        }
    }

    public void repeat_Node(AbstractTreeNode node) {
        if (node.isLeaf()) {
            node.setCondition(1);
        } else {
            this.setComponentCondition(node, 1);
        }
        this.repaint();
        this.build_PopUp();
    }

    public void skip_Node(AbstractTreeNode node) {
        if (node.isLeaf()) {
            node.setCondition(2);
        } else {
            this.setComponentCondition(node, 2);
        }
        this.repaint();
        this.build_PopUp();
    }

    private void append_to_step(AbstractTreeNode node, boolean before, boolean dlg_step) {
        String name = before ? node.getName() + "_Exit(before)" : node.getName() + "_Exit(after)";
        AbstractTreeNode tree_node = null;
        DefaultMutableTreeNode tree_parent = (DefaultMutableTreeNode)node.getParent();
        SAPinstStepBrowserNode data = new SAPinstStepBrowserNode();
        data.setName(name);
        data.setState(3);
        data.setCondition(3);
        tree_node = dlg_step ? new StepDialogTreeNode(data) : new StepInstTreeNode(data);
        if (before) {
            this.model.addNode(tree_node, (AbstractTreeNode)node.getParent(), tree_parent.getIndex(node));
        } else {
            this.model.addNode(tree_node, (AbstractTreeNode)node.getParent(), tree_parent.getIndex(node) + 1);
        }
        this.repaint();
    }

    private void remove_EXITstep(AbstractTreeNode tree_node) {
        this.model.deleteNode(tree_node);
    }

    public void valueChanged(TreeSelectionEvent event) {
        TreePath tP = this.getSelectionPath();
        if (tP != null) {
            AbstractTreeNode node = (AbstractTreeNode)tP.getLastPathComponent();
            this.showNodeInfo(node);
        }
        this.build_PopUp();
    }

    public void treeNodesChanged(TreeModelEvent arg0) {
    }

    public void treeNodesRemoved(TreeModelEvent arg0) {
    }

    public void treeStructureChanged(TreeModelEvent arg0) {
    }

    public void treeNodesInserted(TreeModelEvent event) {
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        TreePath path = event.getPath();
        for (int i = 0; i < this.expandNodes.size(); ++i) {
            TreePath next = (TreePath)this.expandNodes.get(i);
            if (!next.equals(path)) continue;
            this.expandNodes.remove(next);
        }
    }

    public void treeExpanded(TreeExpansionEvent event) {
        TreePath path = event.getPath();
        for (int i = 0; i < this.expandNodes.size(); ++i) {
            TreePath next = (TreePath)this.expandNodes.get(i);
            if (!next.equals(path)) continue;
            return;
        }
        this.expandNodes.add(path);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("RESET_STEP")) {
            if (this.getSelectionCount() > 1) {
                TreePath[] paths = this.getSelectionPaths();
                for (int i = 0; i < paths.length; ++i) {
                    AbstractTreeNode temp = (AbstractTreeNode)paths[i].getLastPathComponent();
                    this.reset_Node(temp);
                }
            } else {
                this.reset_Node(this.get_SelectedNode());
            }
        } else if (command.equals("REPEAT_STEP")) {
            if (this.getSelectionCount() > 1) {
                TreePath[] paths = this.getSelectionPaths();
                for (int i = 0; i < paths.length; ++i) {
                    AbstractTreeNode temp = (AbstractTreeNode)paths[i].getLastPathComponent();
                    this.repeat_Node(temp);
                }
            } else {
                this.repeat_Node(this.get_SelectedNode());
            }
        } else if (command.equals("SKIP_STEP")) {
            if (this.getSelectionCount() > 1) {
                TreePath[] paths = this.getSelectionPaths();
                for (int i = 0; i < paths.length; ++i) {
                    AbstractTreeNode temp = (AbstractTreeNode)paths[i].getLastPathComponent();
                    this.skip_Node(temp);
                }
            } else {
                this.skip_Node(this.get_SelectedNode());
            }
        } else if (command.equals("ADD_DIALOG_UP")) {
            this.append_to_step(this.get_SelectedNode(), true, true);
        } else if (command.equals("ADD_DIALOG_DOWN")) {
            this.append_to_step(this.get_SelectedNode(), false, true);
        } else if (command.equals("ADD_INST_EXIT_STEP_UP")) {
            this.append_to_step(this.get_SelectedNode(), true, false);
        } else if (command.equals("ADD_INST_EXIT_STEP_DOWN")) {
            this.append_to_step(this.get_SelectedNode(), false, false);
        } else if (command.equals("REMOVE_STEP")) {
            this.remove_EXITstep(this.get_SelectedNode());
        }
    }

    public void mouseClicked(MouseEvent arg0) {
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            if (this.getSelectionCount() < 2) {
                TreePath treepath = this.getPathForLocation(e.getX(), e.getY());
                if (treepath != null) {
                    this.setSelectionPath(treepath);
                    this.build_PopUp();
                    this.popUp.show((JComponent)e.getSource(), e.getX(), e.getY());
                }
            } else {
                TreePath treepath = this.getPathForLocation(e.getX(), e.getY());
                if (treepath == null) {
                    return;
                }
                TreePath[] paths = this.getSelectionPaths();
                boolean is_in = false;
                for (int i = 0; i < paths.length; ++i) {
                    if (!treepath.equals(paths[i])) continue;
                    is_in = true;
                }
                if (is_in) {
                    if (treepath != null) {
                        this.build_PopUp();
                        this.popUp.show((JComponent)e.getSource(), e.getX(), e.getY());
                    }
                } else if (treepath != null) {
                    this.setSelectionPath(treepath);
                    this.build_PopUp();
                    this.popUp.show((JComponent)e.getSource(), e.getX(), e.getY());
                }
            }
        }
    }

    public void getAllData() {
        this.model.getAllData();
    }

    public int getSteps() {
        return this.steps;
    }

    public void setSteps(int i) {
        this.steps = i;
    }
}

