/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.gui.ext.sapinst.swing.controls.stepbrowser;

import com.sap.sdt.gui.ext.sapinst.images.ImageHolder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class StepBrowserButton
extends JButton
implements MouseListener,
ActionListener,
PopupMenuListener {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_gui/java/com/sap/sdt/gui/ext/sapinst/swing/controls/stepbrowser/StepBrowserButton.java#2 $";
    private ImageIcon ico_choise = ImageHolder.STEP_BROWSER_TREE_CHOICE_BUTTON_ICON;
    private ImageIcon ico1 = null;
    private ImageIcon ico2 = null;
    private Insets m = new Insets(0, 0, 0, 0);
    private boolean deaktivate = false;
    private boolean windows = false;
    private StepBrowserButton button = null;
    private JPopupMenu popUP = null;
    private JToolBar parent;
    private EmptyBorder border = new EmptyBorder(3, 2, 3, 2);

    public StepBrowserButton(Icon ico, ActionListener listener, String ToolTip) {
        super(ico);
        this.addMouseListener(this);
        this.setFocusPainted(false);
        this.setToolTipText(ToolTip);
        this.setMargin(this.m);
        this.addActionListener(listener);
        this.setBorder(this.border);
    }

    public StepBrowserButton(JToolBar parent, ImageIcon ico1, ImageIcon ico2, ActionListener listener, String ToolTip) {
        super(ico1);
        this.ico1 = ico1;
        this.ico2 = ico2;
        this.parent = parent;
        this.button = new StepBrowserButton(this.ico_choise, this, ToolTip);
        this.button.append_Button(this);
        this.addMouseListener(this);
        this.setFocusPainted(false);
        this.setToolTipText(ToolTip);
        this.setMargin(this.m);
        this.addActionListener(listener);
        parent.add(this);
        parent.add(this.button);
        this.setBorder(this.border);
        this.button.deactivateButton(true);
        this.deactivateButton(true);
    }

    public StepBrowserButton getChoise() {
        return this.button;
    }

    public void append_Button(StepBrowserButton button) {
        this.button = button;
    }

    public void set_ChoisePopup(JPopupMenu popUP) {
        this.popUP = popUP;
        this.popUP.addPopupMenuListener(this);
        this.button.deactivateButton(false);
        this.deactivateButton(false);
    }

    public void deactivateButton(boolean value) {
        if (value == this.deaktivate) {
            return;
        }
        this.setEnabled(!value);
        if (value) {
            this.setBorder(this.border);
        }
        this.deaktivate = value;
    }

    public void set_Ico1() {
        this.setIcon(this.ico1);
    }

    public void set_Ico2() {
        this.setIcon(this.ico2);
    }

    public void mouseClicked(MouseEvent arg0) {
    }

    public void mouseEntered(MouseEvent event) {
        if (this.deaktivate) {
            return;
        }
        if (this.windows) {
            this.setBorder(new Border(0));
        } else {
            this.setBorder(new EtchedBorder());
        }
        if (this.button != null) {
            this.button.setBorder(this.getBorder());
        }
    }

    public void mouseExited(MouseEvent event) {
        if (this.deaktivate) {
            return;
        }
        this.setBorder(this.border);
        if (this.button != null) {
            this.button.setBorder(this.border);
        }
    }

    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (this.popUP == null || this.popUP.getComponentCount() == 0) {
            return;
        }
        Rectangle rec = this.button.getBounds();
        this.popUP.show(this.parent, rec.x - this.getWidth(), rec.y + rec.height);
        this.popUP.requestFocus();
    }

    public void popupMenuCanceled(PopupMenuEvent e) {
        this.deactivateButton(false);
        this.button.deactivateButton(false);
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.deactivateButton(false);
        this.button.deactivateButton(false);
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.deactivateButton(true);
        this.button.deactivateButton(true);
    }

    class Border
    extends SoftBevelBorder {
        public Border(int status) {
            super(status);
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color oldColor = g.getColor();
            g.translate(x, y);
            if (this.bevelType == 0) {
                g.setColor(this.getHighlightOuterColor(c));
                g.drawLine(0, 0, width - 2, 0);
                g.drawLine(0, 0, 0, height - 2);
                g.setColor(this.getHighlightInnerColor(c));
                g.drawLine(0, height - 1, 0, height - 2);
                g.drawLine(width - 1, 0, width - 1, 0);
                g.setColor(this.getShadowOuterColor(c));
                g.drawLine(0, height - 1, width - 1, height - 1);
                g.drawLine(width - 1, 1, width - 1, height - 1);
            } else if (this.bevelType == 1) {
                // empty if block
            }
            g.translate(-x, -y);
            g.setColor(oldColor);
        }
    }
}

